/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.data.raw;

import me.phoenixra.atumvr.api.enums.ControllerType;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.core.client.data.raw.RawController;
import me.phoenixra.visor.core.client.data.raw.RawHmd;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class RawPoseHandler {
    protected RawHmd hmdData = new RawHmd();
    protected RawController controllerLeftData = new RawController();
    protected RawController controllerRightData = new RawController();
    protected float gunAngle = 0.0f;

    public abstract void updatePose();

    public Matrix4f getSmoothedRotation(ControllerHand controller, float lenSec) {
        RawController controllerData = this.getControllerData(controller);
        Vector3f averagePosForward = controllerData.getForwardHistory().averagePosition(lenSec);
        Vector3f averagePosUp = controllerData.getUpHistory().averagePosition(lenSec);
        Vector3f cross = averagePosForward.cross((Vector3fc)averagePosUp);
        return new Matrix4f(cross.x, averagePosForward.x, averagePosUp.x, 0.0f, cross.y, averagePosForward.y, averagePosUp.y, 0.0f, cross.z, averagePosForward.z, averagePosUp.z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public RawController getControllerData(ControllerHand controller) {
        if (controller.getType(VRClientSettings.isLeftHanded()) == ControllerType.LEFT) {
            return this.controllerLeftData;
        }
        return this.controllerRightData;
    }

    public RawHmd getHmdData() {
        return this.hmdData;
    }

    public float getGunAngle() {
        return this.gunAngle;
    }
}

