/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.visor.api.client.gui.OverlayConfigAccessor;
import me.phoenixra.visor.api.client.gui.VRKeyboardAccessor;
import me.phoenixra.visor.api.client.gui.VROverlayManager;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayFrameBuffer;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionsScreen;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsGeneral;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsIdentity;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsMisc;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsPose;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsScreenRegion;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.gui.registry.VROverlayRegistry;
import me.phoenixra.visor.core.client.gui.registry.VROverlayTemplateRegistry;
import me.phoenixra.visor.core.client.gui.screens.overlayoptions.OptionsScreenGeneral;
import me.phoenixra.visor.core.client.gui.screens.overlayoptions.OptionsScreenIdentity;
import me.phoenixra.visor.core.client.gui.screens.overlayoptions.OptionsScreenMisc;
import me.phoenixra.visor.core.client.gui.screens.overlayoptions.OptionsScreenPose;
import me.phoenixra.visor.core.client.gui.screens.overlayoptions.OptionsScreenRegion;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.render.helpers.RenderGuiHelper;
import me.phoenixra.visor.core.client.render.helpers.RenderPoseHelper;
import me.phoenixra.visor.modified.client.render.GameRendererModified;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_8251;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class VROverlayManagerImpl
implements VROverlayManager {
    private final VROverlayRegistry overlaysRegistry = new VROverlayRegistry();
    private final VROverlayTemplateRegistry overlayTemplatesRegistry = new VROverlayTemplateRegistry();
    private VRKeyboardAccessor keyboardAccessor;
    private final List<VROverlay> preparedOverlays = new ArrayList<VROverlay>();

    public void tick() {
        for (VROverlay overlay : this.overlaysRegistry.getSortedElements()) {
            if (!overlay.isEnabled()) continue;
            overlay.method_25393();
        }
    }

    public void prepareOverlaysAndCursor(float partialTicks) {
        this.preparedOverlays.clear();
        for (VROverlay overlay : this.overlaysRegistry.getSortedElements()) {
            class_276 target;
            if (!overlay.isVisible() || (target = overlay.getRenderTarget()) == null) continue;
            overlay.updatePose(partialTicks);
            if (!overlay.isInViewDistance()) continue;
            this.preparedOverlays.add(overlay);
        }
        ClientContext.cursorHandler.process();
    }

    public void renderOverlayTextures(class_3695 profiler, class_332 guiGraphics, float partialTicks) {
        if (this.preparedOverlays.isEmpty()) {
            return;
        }
        Matrix4f projection = new Matrix4f();
        int prevOverlayWidth = -1;
        int prevOverlayHeight = -1;
        RenderSystem.backupProjectionMatrix();
        class_4587 posestack = RenderSystem.getModelViewStack();
        posestack.method_22903();
        posestack.method_34426();
        posestack.method_22904(0.0, 0.0, -11000.0);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        for (VROverlay overlay : this.preparedOverlays) {
            class_276 target = overlay.getRenderTarget();
            if (target == null) {
                throw new RuntimeException("Tried to render overlay quad with null renderTarget: " + overlay.getId());
            }
            profiler.method_15396("VROverlay Texture: " + overlay.getId());
            if (overlay instanceof VROverlayScreen) {
                VROverlayScreen overlayScreen = (VROverlayScreen)overlay;
                VisorClientImpl.MC.field_1689 = target;
                target.method_1230(class_310.field_1703);
                target.method_1235(true);
                if (prevOverlayWidth != overlayScreen.field_22789 || prevOverlayHeight != overlayScreen.field_22790) {
                    projection.setOrtho(0.0f, (float)overlayScreen.field_22789, (float)overlayScreen.field_22790, 0.0f, 1000.0f, 21000.0f);
                    RenderSystem.setProjectionMatrix((Matrix4f)projection, (class_8251)class_8251.field_43361);
                    prevOverlayWidth = overlayScreen.field_22789;
                    prevOverlayHeight = overlayScreen.field_22790;
                }
                overlayScreen.method_47413(guiGraphics, overlayScreen.getMouseX(), overlayScreen.getMouseY(), partialTicks);
                guiGraphics.method_51452();
            } else if (overlay instanceof VROverlayFrameBuffer) {
                VROverlayFrameBuffer overlayFrameBuffer = (VROverlayFrameBuffer)overlay;
                overlayFrameBuffer.render(partialTicks);
            } else {
                throw new RuntimeException("Tried to render overlay of unsupported abstract class: " + overlay.getId());
            }
            profiler.method_15407();
            GLUtils.checkGLError("post VROverlay texture: " + overlay.getId());
        }
        RenderSystem.restoreProjectionMatrix();
        posestack.method_22909();
    }

    public void renderOverlays(float partialTicks, class_4587 poseStack) {
        if (this.preparedOverlays.isEmpty()) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_34426();
        RenderPoseHelper.applyDisplayOrientation(VRRenderState.getCurrentVRDisplay(), poseStack);
        ((GameRendererModified)VisorClientImpl.MC.field_1773).visor$resetProjectionMatrix(partialTicks);
        GLUtils.checkGLError("before overlays");
        for (VROverlay overlay : this.preparedOverlays) {
            if (!overlay.isVisible()) continue;
            class_276 target = overlay.getRenderTarget();
            if (target == null) {
                throw new RuntimeException("Tried to render overlay quad with null renderTarget: " + overlay.getId());
            }
            RenderGuiHelper.renderOverlayQuad(overlay, poseStack, overlay.getPose().getPosition(), overlay.getPose().getRotation(), !overlay.supportsDepth(), overlay.supportsLight(), overlay.getPose().getScale());
            GLUtils.checkGLError("post VROverlay quad: " + overlay.getId());
        }
        poseStack.method_22909();
    }

    @Override
    public VROverlay getOverlay(@NotNull String id) {
        return this.overlaysRegistry.getElement(id);
    }

    @Override
    @NotNull
    public OverlayConfigAccessor getOverlayConfigAccessor() {
        return ClientContext.settingsHandler.getOverlayConfigsAccessor();
    }

    @Override
    @NotNull
    public OptionsScreen<?> getOptionsScreenFor(@NotNull OverlayOptionGroup<?> category) {
        if (category instanceof OverlayOptionsMisc) {
            OverlayOptionsMisc type = (OverlayOptionsMisc)category;
            return new OptionsScreenMisc(type);
        }
        if (category instanceof OverlayOptionsPose) {
            OverlayOptionsPose type = (OverlayOptionsPose)category;
            return new OptionsScreenPose(type);
        }
        if (category instanceof OverlayOptionsIdentity) {
            OverlayOptionsIdentity type = (OverlayOptionsIdentity)category;
            return new OptionsScreenIdentity(type);
        }
        if (category instanceof OverlayOptionsGeneral) {
            OverlayOptionsGeneral type = (OverlayOptionsGeneral)category;
            return new OptionsScreenGeneral(type);
        }
        if (category instanceof OverlayOptionsScreenRegion) {
            OverlayOptionsScreenRegion type = (OverlayOptionsScreenRegion)category;
            return new OptionsScreenRegion(type);
        }
        return null;
    }

    public VROverlayRegistry getOverlaysRegistry() {
        return this.overlaysRegistry;
    }

    public VROverlayTemplateRegistry getOverlayTemplatesRegistry() {
        return this.overlayTemplatesRegistry;
    }

    @Override
    public VRKeyboardAccessor getKeyboardAccessor() {
        return this.keyboardAccessor;
    }

    public List<VROverlay> getPreparedOverlays() {
        return this.preparedOverlays;
    }

    @Override
    public void setKeyboardAccessor(VRKeyboardAccessor keyboardAccessor) {
        this.keyboardAccessor = keyboardAccessor;
    }
}

