/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.overlays.builtin;

import me.phoenixra.visor.api.client.data.PoseAnchor;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayHelper;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VROverlayThirdPersonCamera
extends VROverlayScreen {
    public static final String ID = "third_person_camera";
    private final GuiTexture cameraTexture = new GuiTexture(new class_2960("visor", "textures/gui/overlays/camera.png"));
    private final Vector3f posDragOffset = new Vector3f(0.0f, 0.0f, -0.3f);
    private final Vector3f rotationDragOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    private float offsetZWaiting;
    private float preTickOffsetZ = -0.3f;
    private float postTickOffsetZ = -0.3f;
    boolean changingPosition;

    public VROverlayThirdPersonCamera(@NotNull VisorAddon owner, @NotNull String id) {
        super(owner, id, ElementPriority.HIGHER, 0.35f);
        this.setEnabled(true);
    }

    @Override
    protected void onTick() {
        this.preTickOffsetZ = this.postTickOffsetZ;
        if (this.offsetZWaiting != 0.0f) {
            this.postTickOffsetZ += this.offsetZWaiting;
            if (this.postTickOffsetZ >= -0.1f) {
                this.postTickOffsetZ = -0.1f;
            }
        }
        this.offsetZWaiting = 0.0f;
    }

    @Override
    protected void onRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.cameraTexture.blit(guiGraphics, this.field_22789 / 2 - 128, this.field_22790 / 2 - 128, 256, 256);
    }

    @Override
    public void onUpdatePose(float partialTicks) {
        if (this.changingPosition) {
            PoseAnchor anchor = ClientContext.cursorHandler.getCursorHand() == ControllerHand.MAIN ? PoseAnchor.MAIN_HAND : PoseAnchor.OFFHAND;
            this.posDragOffset.z = class_3532.method_16439((float)partialTicks, (float)this.preTickOffsetZ, (float)this.postTickOffsetZ);
            VROverlayHelper.applyPose(this, anchor, anchor, this.getPose().getScale(), true, (Vector3fc)this.posDragOffset, (Vector3fc)this.rotationDragOffset);
            this.updateCameraPose(false);
            return;
        }
        PoseDataImpl renderData = ClientContext.player.getPoseData(PoseDataType.RENDER);
        Vector3fc camPosition = renderData.getThirdPersonCamera().getPosition();
        Matrix4fc camRotation = renderData.getThirdPersonCamera().getRotation();
        this.getPose().update(camPosition, (Matrix4fc)camRotation.rotateY((float)Math.PI, new Matrix4f()), this.getPose().getScale());
    }

    public void setChangingPosition(boolean flag) {
        if (this.changingPosition && !flag) {
            this.updatePose(1.0f);
            this.updateCameraPose(true);
            this.posDragOffset.z = -0.3f;
            this.preTickOffsetZ = -0.3f;
            this.postTickOffsetZ = -0.3f;
            this.offsetZWaiting = 0.0f;
        }
        this.changingPosition = flag;
    }

    private void updateCameraPose(boolean save) {
        PoseDataImpl roomData = ClientContext.player.getPoseData(PoseDataType.ROOM);
        Vector3f newPosition = roomData.convertPositionFrom(PoseDataType.RENDER, this.getPose().getPosition());
        Quaternionf newRotation = roomData.convertRotationFrom(PoseDataType.RENDER, this.getPose().getRotation()).getUnnormalizedRotation(new Quaternionf()).rotateY((float)Math.PI);
        VRClientSettings.updateThirdPersonCamera((Vector3fc)newPosition, (Quaternionfc)newRotation, save);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollDelta) {
        if (this.changingPosition) {
            this.offsetZWaiting += (float)(-scrollDelta) * 0.01f;
        }
        return true;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int buttonType) {
        if (this.changingPosition) {
            this.setChangingPosition(false);
        }
        return true;
    }

    @Override
    public boolean supportsCursor() {
        return this.changingPosition;
    }

    @Override
    protected boolean updateVisibility() {
        return VRRenderState.getVRWorldDisplays().contains((Object)VRDisplay.THIRD_PERSON);
    }

    @Override
    public boolean isInViewDistance() {
        return true;
    }

    @Override
    @NotNull
    public class_2561 getName() {
        return class_2561.method_43471((String)"visor.overlay.%s.name".formatted(this.getId()));
    }

    @Override
    @NotNull
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"visor.overlay.%s.description".formatted(this.getId()));
    }

    public boolean isChangingPosition() {
        return this.changingPosition;
    }
}

