/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.overlays.builtin.settings.widgets;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionTextures;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoCheckboxList;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoImage;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoSelectionList;
import me.phoenixra.visor.api.client.gui.widgets.lists.FilterListType;
import me.phoenixra.visor.api.client.gui.widgets.lists.TexturedSelectionList;
import me.phoenixra.visor.api.client.gui.widgets.sets.DynamicWidgetSet;
import me.phoenixra.visor.api.client.gui.widgets.sets.FilterListBinaryWidgetSet;
import me.phoenixra.visor.api.client.gui.widgets.sets.SearchableListWidgetSet;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.SettingsTextures;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.VROverlayOptionsMenu;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.VROverlaySettings;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.widgets.SetupOverlayWidgetSet;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlaysWidgetSet
extends DynamicWidgetSet {
    private final VROverlaySettings owner;
    private SearchableListWidgetSet overlaysList;
    private SetupOverlayWidgetSet overlaySetup;
    private final Map<String, String> addonFiltersName = new LinkedHashMap<String, String>();
    private final Map<String, Function<String, Boolean>> addonFiltersFunc = new LinkedHashMap<String, Function<String, Boolean>>();
    private final Map<String, String> mainFiltersName = new LinkedHashMap<String, String>();
    private final Map<String, Function<String, Boolean>> mainFiltersFunc = new LinkedHashMap<String, Function<String, Boolean>>();
    private OverlayOptionGroup<?> copiedOptionGroup;

    public OverlaysWidgetSet(@NotNull VROverlaySettings owner, @NotNull Runnable onWidgetsChanged) {
        super(onWidgetsChanged);
        this.owner = owner;
    }

    @Override
    public <T extends class_364 & class_4068> List<T> initWidgets() {
        String id = "custom_only";
        class_5250 name = class_2561.method_43471((String)("visor.overlay.options.main.overlays.filters.main." + id));
        this.mainFiltersName.put(id, name.getString());
        this.mainFiltersFunc.put(id, it -> {
            VROverlay overlay = ClientContext.overlayManager.getOverlay((String)it);
            if (overlay == null) {
                return false;
            }
            return overlay.isCustom();
        });
        id = "built_in_only";
        name = class_2561.method_43471((String)("visor.overlay.options.main.overlays.filters.main." + id));
        this.mainFiltersName.put(id, name.getString());
        this.mainFiltersFunc.put(id, it -> {
            VROverlay overlay = ClientContext.overlayManager.getOverlay((String)it);
            if (overlay == null) {
                return false;
            }
            return overlay.isBuiltIn();
        });
        id = "has_options";
        name = class_2561.method_43471((String)("visor.overlay.options.main.overlays.filters.main." + id));
        this.mainFiltersName.put(id, name.getString());
        this.mainFiltersFunc.put(id, it -> {
            VROverlay overlay = ClientContext.overlayManager.getOverlay((String)it);
            if (overlay == null) {
                return false;
            }
            return !overlay.getOptions().isEmpty();
        });
        id = "no_options";
        name = class_2561.method_43471((String)("visor.overlay.options.main.overlays.filters.main." + id));
        this.mainFiltersName.put(id, name.getString());
        this.mainFiltersFunc.put(id, it -> {
            VROverlay overlay = ClientContext.overlayManager.getOverlay((String)it);
            if (overlay == null) {
                return false;
            }
            return overlay.getOptions().isEmpty();
        });
        for (VisorAddon addon : VisorAPI.addonManager().getAddons()) {
            String filterId = "addon_" + addon.getAddonId();
            this.addonFiltersName.put(filterId, addon.getAddonName().getString());
            this.addonFiltersFunc.put(filterId, it -> {
                VROverlay overlay = ClientContext.overlayManager.getOverlay((String)it);
                if (overlay == null) {
                    return false;
                }
                return overlay.getOwner().getAddonId().equals(addon.getAddonId());
            });
        }
        this.overlaySetup = null;
        this.setOptionsMenu(null);
        ArrayList<String> filtersMain = new ArrayList<String>();
        filtersMain.add("has_options");
        ArrayList<String> filtersAddons = new ArrayList<String>(this.addonFiltersName.keySet().stream().toList());
        if (this.overlaysList != null) {
            FilterListBinaryWidgetSet binaryFilter = (FilterListBinaryWidgetSet)this.overlaysList.getFilterWidgetSet();
            filtersMain.clear();
            filtersMain.addAll(binaryFilter.getFiltersWidgetFirst().getActiveFilterIds());
            filtersAddons.clear();
            filtersAddons.addAll(binaryFilter.getFiltersWidgetSecond().getActiveFilterIds());
        }
        LinkedHashMap<String, String> overlaysMap = new LinkedHashMap<String, String>();
        ClientContext.overlayManager.getOverlaysRegistry().getSortedByName().forEach(it -> overlaysMap.put(it.getId(), it.getName().getString()));
        WidgetInfoImage filterBackgroundInfo = new WidgetInfoImage().pos(this.owner.getMenuBoundsX() - 117, this.owner.getMenuBoundsY() + 31).size(114, 220).setTexture(SettingsTextures.FILTER_BACKGROUND);
        FilterListBinaryWidgetSet<String> filterWidgetSet = new FilterListBinaryWidgetSet.Builder(new WidgetInfoCheckboxList().pos(this.owner.getMenuBoundsX() - 117, this.owner.getMenuBoundsY() + 76).size(114, 167).textures(OptionTextures.BLACK_TEXTURE, SettingsTextures.CHECKBOX_BUTTON, SettingsTextures.CHECKBOX_BUTTON_HOVERED, SettingsTextures.CHECKBOX_BUTTON_SELECTED, SettingsTextures.CHECKBOX_BUTTON_HOVERED_SELECTED).setTextColor(VROverlaySettings.TEXT_COLOR), this.onWidgetsChanged).first(FilterListType.ALL, filterBackgroundInfo, new WidgetInfoButtonImaged().pos(this.owner.getMenuBoundsX() - 114, this.owner.getMenuBoundsY() + 35).size(52, 15).setTexture(OptionTextures.BLACK_TEXTURE).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT).setText((class_2561)class_2561.method_43471((String)"visor.overlay.options.main.overlays.filters.main")).setTextColor(VROverlaySettings.TEXT_COLOR), this.mainFiltersName, this.mainFiltersFunc, () -> filtersMain).second(FilterListType.AT_LEAST_ONE, filterBackgroundInfo, new WidgetInfoButtonImaged().pos(this.owner.getMenuBoundsX() - 58, this.owner.getMenuBoundsY() + 35).size(52, 15).setTexture(OptionTextures.BLACK_TEXTURE).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT).setText((class_2561)class_2561.method_43471((String)"visor.overlay.options.main.overlays.filters.addons")).setTextColor(VROverlaySettings.TEXT_COLOR), this.addonFiltersName, this.addonFiltersFunc, () -> filtersAddons).checkboxAll(new WidgetInfoButtonImaged().pos(this.owner.getMenuBoundsX() - 111, this.owner.getMenuBoundsY() + 62).size(12, 14).textures(SettingsTextures.CHECKBOX_BUTTON, SettingsTextures.CHECKBOX_BUTTON_HOVERED, SettingsTextures.CHECKBOX_BUTTON_SELECTED, SettingsTextures.CHECKBOX_BUTTON_HOVERED_SELECTED, null).setInactiveOnSelected(false)).searchBox(new WidgetInfoEditBox().pos(this.owner.getMenuBoundsX() - 95, this.owner.getMenuBoundsY() + 62).size(86, 14).setTexture(OptionTextures.BLACK_TEXTURE).setTextColor(VROverlaySettings.TEXT_COLOR).setHint(VROverlaySettings.TEXT_FIND)).build();
        this.overlaysList = new SearchableListWidgetSet.Builder(new WidgetInfoSelectionList().pos(this.owner.getMenuBoundsX() + 6, this.owner.getMenuBoundsY() + 54).size(111, 191).setEntryButton(new WidgetInfoButtonImaged().setTexture(OptionTextures.GRAY_TEXTURE).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT)).setTextureScrollBarActive(OptionTextures.SCROLL_BAR_ACTIVE).setEntryHeight(21).setTextColor(VROverlaySettings.TEXT_COLOR), overlaysMap, selected -> {
            VROverlay overlay = ClientContext.overlayManager.getOverlay(selected.getId());
            if (overlay == null) {
                return;
            }
            this.createOverlaySetup(overlay);
        }, this.onWidgetsChanged).filterButton(new WidgetInfoButtonImaged().pos(this.owner.getMenuBoundsX() + 5, this.owner.getMenuBoundsY() + 34).size(17, 17).textures(SettingsTextures.FILTER_BLACK_BUTTON, SettingsTextures.FILTER_BLACK_BUTTON_HOVERED, SettingsTextures.FILTER_BLACK_BUTTON_SELECTED).setInactiveOnSelected(false), filterWidgetSet).searchBox(new WidgetInfoEditBox().pos(this.owner.getMenuBoundsX() + 25, this.owner.getMenuBoundsY() + 35).size(92, 15).setTexture(OptionTextures.BLACK_TEXTURE).setTextColor(VROverlaySettings.TEXT_COLOR).setHint(VROverlaySettings.TEXT_FIND)).build();
        this.overlaysList.initWidgets();
        return this.getWidgets();
    }

    @Override
    public <T extends class_364 & class_4068> List<T> getWidgets() {
        ArrayList list = new ArrayList(this.overlaysList.getWidgets());
        if (this.overlaySetup != null) {
            list.addAll(this.overlaySetup.getWidgets());
        }
        return list;
    }

    @Override
    public void onPreRender(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.overlaysList.onPreRender(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.overlaysList.getFilterButton().isSelected()) {
            this.owner.setCursorBoundsOffsetX(-this.owner.getMenuBoundsX());
            this.owner.setCursorBoundsOffsetY(-this.owner.getMenuBoundsY());
            this.owner.setCursorBoundsOffsetWidth(this.owner.getMenuBoundsX());
            this.owner.setCursorBoundsOffsetHeight(this.owner.getMenuBoundsY());
        } else {
            this.owner.setCursorBoundsOffsetX(0);
            this.owner.setCursorBoundsOffsetY(0);
            this.owner.setCursorBoundsOffsetWidth(0);
            this.owner.setCursorBoundsOffsetHeight(0);
        }
        if (this.overlaySetup != null) {
            this.overlaySetup.onPreRender(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void onTick() {
        TexturedSelectionList.TexturedEntry selected;
        this.overlaysList.onTick();
        if (this.overlaySetup != null) {
            this.overlaySetup.onTick();
        }
        if ((selected = (TexturedSelectionList.TexturedEntry)this.overlaysList.getList().method_25334()) == null) {
            return;
        }
        VROverlay selectedOverlay = ClientContext.overlayManager.getOverlay(selected.getId());
        if (selectedOverlay == null) {
            return;
        }
        this.overlaysList.getList().renameEntry(selected.getId(), selectedOverlay.getName());
    }

    public void setOptionsMenu(@Nullable OverlayOptionGroup menu) {
        VROverlayOptionsMenu optionsMenu = ClientContext.overlayManager.getOverlay("options_menu", VROverlayOptionsMenu.class);
        assert (optionsMenu != null);
        if (menu != null) {
            if (menu == optionsMenu.getOptionsGroup()) {
                optionsMenu.method_25426();
                return;
            }
            optionsMenu.openMenu(this.owner, menu);
            return;
        }
        optionsMenu.setEnabled(false);
    }

    public void removeOverlay(@NotNull VROverlay overlay) {
        if (overlay.isBuiltIn()) {
            throw new IllegalArgumentException("Not allowed to remove built-in overlays in settings");
        }
        ClientContext.overlayManager.getOverlaysRegistry().unregisterElement(overlay.getId());
        this.initWidgets();
        this.widgetsChanged();
    }

    private void createOverlaySetup(VROverlay overlay) {
        this.setOptionsMenu(null);
        this.overlaySetup = new SetupOverlayWidgetSet(this, overlay, this.onWidgetsChanged, this.owner.getMenuBoundsX() + 122, this.owner.getMenuBoundsY() + 35);
        this.overlaySetup.initWidgets();
        this.widgetsChanged();
    }

    public VROverlaySettings getOwner() {
        return this.owner;
    }

    public SearchableListWidgetSet getOverlaysList() {
        return this.overlaysList;
    }

    public SetupOverlayWidgetSet getOverlaySetup() {
        return this.overlaySetup;
    }

    public OverlayOptionGroup<?> getCopiedOptionGroup() {
        return this.copiedOptionGroup;
    }

    public void setCopiedOptionGroup(OverlayOptionGroup<?> copiedOptionGroup) {
        this.copiedOptionGroup = copiedOptionGroup;
    }
}

