/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.overlays.templates;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.data.PoseAnchor;
import me.phoenixra.visor.api.client.events.AllowClientFeatureVREvent;
import me.phoenixra.visor.api.client.gui.overlays.RegisterVROverlayTemplate;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.framework.template.VROverlayTemplateFrameBuffer;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsPose;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsScreenRegion;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.eventbus.listener.VREventHandler;
import me.phoenixra.visor.api.common.eventbus.listener.VREventListener;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import net.minecraft.class_276;
import org.jetbrains.annotations.NotNull;

@RegisterVROverlayTemplate(id="hud", name="visor.overlay.template.hud.name", description="visor.overlay.template.hud.description", isCreateDefault=true)
public class VROverlayHUD
extends VROverlayTemplateFrameBuffer
implements VREventListener {
    public static final String ID = "hud";
    public static final String NAME = "visor.overlay.template.hud.name";
    public static final String DESCRIPTION = "visor.overlay.template.hud.description";
    private OverlayOptionsScreenRegion optionsScreenRegion;
    private RegionRenderTarget regionTarget;

    public VROverlayHUD(@NotNull VisorAddon owner, @NotNull String id) {
        super(owner, id);
        this.setEnabled(true);
        VisorAPI.eventBus().registerListener(owner, this);
    }

    @VREventHandler
    public void enableHUD(AllowClientFeatureVREvent event) {
        if (event.getFeature() == ClientFeature.GUI_DISABLE_HUD && this.isVisible()) {
            event.setCanceled(true);
        }
    }

    @Override
    public void onRender(float partialTicks) {
        class_276 src = ClientContext.renderer.guiTarget.getTarget();
        this.updateRegionTargetFromSource(src);
    }

    @Override
    public void onPreTick() {
        class_276 src = ClientContext.renderer.guiTarget.getTarget();
        this.updateRegionTargetFromSource(src);
        super.onPreTick();
    }

    @Override
    public boolean updateVisibility() {
        return VisorClientImpl.MC.field_1755 == null && VisorClientImpl.MC.field_1724 != null;
    }

    @Override
    public boolean supportsVisibilityUpdateOnRender() {
        return true;
    }

    private void updateRegionTargetFromSource(class_276 src) {
        if (src == null) {
            this.renderTarget = null;
            return;
        }
        int guiW = src.field_1482;
        int guiH = src.field_1481;
        int rx = Math.max(0, Math.min(guiW, this.optionsScreenRegion.getRegionX()));
        int ryTopLeft = Math.max(0, Math.min(guiH, this.optionsScreenRegion.getRegionY()));
        int rw = Math.max(1, Math.min(guiW - rx, this.optionsScreenRegion.getRegionWidth()));
        int rh = Math.max(1, Math.min(guiH - ryTopLeft, this.optionsScreenRegion.getRegionHeight()));
        int srcY0 = guiH - (ryTopLeft + rh);
        int srcY1 = guiH - ryTopLeft;
        int srcX0 = rx;
        int srcX1 = rx + rw;
        if (srcY0 < 0) {
            srcY0 = 0;
        }
        if (srcY1 > guiH) {
            srcY1 = guiH;
        }
        if (srcX0 < 0) {
            srcX0 = 0;
        }
        if (srcX1 > guiW) {
            srcX1 = guiW;
        }
        if (this.regionTarget == null) {
            this.regionTarget = new RegionRenderTarget(false);
            this.regionTarget.method_1234(rw, rh, true);
        } else if (this.regionTarget.field_1482 != rw || this.regionTarget.field_1481 != rh) {
            this.regionTarget.method_1234(rw, rh, true);
        }
        GlStateManager._glBindFramebuffer((int)36008, (int)src.field_1476);
        GlStateManager._glBindFramebuffer((int)36009, (int)this.regionTarget.field_1476);
        GlStateManager._glBlitFrameBuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)0, (int)0, (int)rw, (int)rh, (int)16384, (int)9728);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
        this.renderTarget = this.regionTarget;
    }

    @Override
    @NotNull
    protected List<OverlayOptionGroup<?>> createTemplateOptions() {
        this.optionsScreenRegion = new OverlayOptionsScreenRegion(this, VisorAPI.client().getGuiManager().getGuiWidth(), VisorAPI.client().getGuiManager().getGuiHeight(), () -> ClientContext.renderer.guiTarget.getTarget(), it -> {
            it.setRegionX(0);
            it.setRegionY(0);
            it.setRegionWidth(it.getScreenWidth());
            it.setRegionHeight(it.getScreenHeight());
        });
        return List.of(new OverlayOptionsPose((VROverlay)this, it -> {
            it.setTickPose(true);
            it.setAimedRotation(false);
            it.setPositionAnchor(PoseAnchor.HMD);
            it.setPositionOffset(0.0f, -0.1f, -1.2f);
            it.setRotationAnchor(PoseAnchor.HMD);
            it.setRotationOffset(0.0f, 0.0f, 0.0f);
            it.setScale(1.0f);
        }), this.optionsScreenRegion);
    }

    private static final class RegionRenderTarget
    extends class_276 {
        public RegionRenderTarget(boolean useDepth) {
            super(useDepth);
        }
    }
}

