/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.registry;

import com.mojang.text2speech.Narrator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayTemplate;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.VisorRegistry;
import me.phoenixra.visor.core.client.ClientContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VROverlayRegistry
implements VisorRegistry<VROverlay> {
    private static final String REGISTRY_NAME = "VR Overlays";
    private static final String ELEMENT_NAME = "VROverlay";
    private final Map<String, VROverlay> elementsMap = new LinkedHashMap<String, VROverlay>();
    private final List<VROverlay> sortedElements = new ArrayList<VROverlay>();
    private final Collection<VROverlay> allElements = Collections.unmodifiableCollection(this.elementsMap.values());

    public List<VROverlay> getSortedElements() {
        return Collections.unmodifiableList(this.sortedElements);
    }

    public List<VROverlay> getSortedByName() {
        return this.elementsMap.values().stream().sorted(Comparator.comparing(it -> it.getName().getString(), String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
    }

    @Override
    public void registerAddonPath(@NotNull VisorAddon addon) {
    }

    @Override
    public void registerElement(@NotNull VROverlay element) {
        VROverlay previous = this.elementsMap.put(element.getId(), element);
        if (previous != null) {
            Narrator.LOGGER.info("Overriding existing {}: '{}' from addon '{}'", new Object[]{ELEMENT_NAME, previous.getId(), previous.getOwner().getAddonId()});
            this.sortedElements.remove(previous);
        } else {
            Narrator.LOGGER.info("Registered {}: '{}'", (Object)ELEMENT_NAME, (Object)element.getId());
        }
        this.sortedElements.add(element);
        Collections.sort(this.sortedElements);
    }

    @Override
    public VROverlay unregisterElement(@NotNull String id) {
        VROverlay removed = this.elementsMap.remove(id);
        if (removed != null) {
            this.sortedElements.remove(removed);
            Collections.sort(this.sortedElements);
            VROverlayTemplate template = removed.asTemplate();
            if (template != null) {
                template.getOptionsConfig().getFile().delete();
                ClientContext.settingsHandler.getOverlayConfigsAccessor().removeConfig(removed.getId());
            }
            Narrator.LOGGER.info("Unregistered {}: '{}'", (Object)ELEMENT_NAME, (Object)removed.getId());
        }
        return removed;
    }

    @Override
    @Nullable
    public VROverlay getElement(@NotNull String id) {
        return this.elementsMap.get(id);
    }

    @Override
    @NotNull
    public String getRegistryName() {
        return REGISTRY_NAME;
    }

    @Override
    public Collection<VROverlay> getAllElements() {
        return this.allElements;
    }
}

