/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.registry;

import com.mojang.text2speech.Narrator;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.client.gui.overlays.RegisterVROverlayTemplate;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayTemplate;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayTemplateRecord;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.VisorRegistry;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import me.phoenixra.visor.core.client.ClientContext;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VROverlayTemplateRegistry
implements VisorRegistry<VROverlayTemplateRecord> {
    private static final String REGISTRY_NAME = "VR Overlay Templates";
    private static final String ELEMENT_NAME = "VROverlayTemplate";
    private static final String ANNOTATION_NAME = "@RegisterVROverlayTemplate";
    private final Map<String, VROverlayTemplateRecord> elementsMap = new LinkedHashMap<String, VROverlayTemplateRecord>();

    @Override
    public void registerAddonPath(@NotNull VisorAddon addon) {
        String path = addon.getAddonPackagePath();
        if (path == null) {
            return;
        }
        List<Class<?>> annotated = ModLoader.get().getClassesAnnotated(RegisterVROverlayTemplate.class, addon.getModId(), path);
        Narrator.LOGGER.info("Found {} {} to register in addon: '{}'", new Object[]{annotated.size(), ELEMENT_NAME, addon.getAddonId()});
        for (Class<?> clazz : annotated) {
            if (!VROverlayTemplate.class.isAssignableFrom(clazz)) {
                Narrator.LOGGER.warn("{} is annotated with {} but does not implement {}", new Object[]{clazz.getName(), ANNOTATION_NAME, ELEMENT_NAME});
                continue;
            }
            try {
                RegisterVROverlayTemplate annotation = clazz.getAnnotation(RegisterVROverlayTemplate.class);
                String id = annotation.id();
                boolean createDefault = annotation.isCreateDefault();
                Class<?> elementClazz = clazz;
                Constructor<?> constructor = elementClazz.getConstructor(VisorAddon.class, String.class);
                VROverlayTemplateRecord element = new VROverlayTemplateRecord(addon, id, (class_2561)class_2561.method_43471((String)annotation.name()), (class_2561)class_2561.method_43471((String)annotation.description()), createDefault, elementClazz, constructor);
                this.registerElement(element);
            }
            catch (Exception e) {
                Narrator.LOGGER.error("Failed to register {} from class: {}", (Object)ELEMENT_NAME, (Object)clazz.getName());
                LoggerUtils.printError(e);
            }
        }
        ClientContext.overlayManager.getOverlayConfigAccessor().reload(addon);
    }

    @Override
    public void registerElement(@NotNull VROverlayTemplateRecord element) {
        VROverlayTemplateRecord previous = this.elementsMap.put(element.getId(), element);
        if (previous != null) {
            Narrator.LOGGER.info("Overriding existing {}: '{}' from addon '{}'", new Object[]{ELEMENT_NAME, previous.getId(), previous.getOwner().getAddonId()});
        } else {
            Narrator.LOGGER.info("Registered {}: '{}'", (Object)ELEMENT_NAME, (Object)element.getId());
        }
    }

    @Override
    public VROverlayTemplateRecord unregisterElement(@NotNull String id) {
        VROverlayTemplateRecord removed = this.elementsMap.remove(id);
        if (removed != null) {
            Narrator.LOGGER.info("Unregistered {}: '{}'", (Object)ELEMENT_NAME, (Object)removed.getId());
        }
        return removed;
    }

    @Override
    @Nullable
    public VROverlayTemplateRecord getElement(@NotNull String id) {
        return this.elementsMap.get(id);
    }

    @Override
    @NotNull
    public Collection<VROverlayTemplateRecord> getAllElements() {
        return this.elementsMap.values().stream().toList();
    }

    @Override
    @NotNull
    public String getRegistryName() {
        return REGISTRY_NAME;
    }
}

