/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.screens.settings;

import java.util.Objects;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.gui.screens.settings.OptionWidgetPosition;
import me.phoenixra.visor.core.client.settings.VROptionWidgetType;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionWidgetEntry {
    @Nullable
    private final VROptionWidgetType optionType;
    @Nullable
    private final Class<? extends class_437> opensScreen;
    @Nullable
    private final VROverlay opensOverlay;
    @Nullable
    private final Runnable actionOnClick;
    private final OptionWidgetPosition position;
    private final int row;
    private final String buttonText;

    public OptionWidgetEntry(@NotNull VROptionWidgetType option, @NotNull OptionWidgetPosition pos, int row, @Nullable String buttonText) {
        this.opensScreen = null;
        this.opensOverlay = null;
        this.actionOnClick = null;
        this.optionType = option;
        this.position = pos;
        this.row = row;
        this.buttonText = Objects.requireNonNullElse(buttonText, "");
    }

    public OptionWidgetEntry(@NotNull Class<? extends class_437> opensScreen, @NotNull OptionWidgetPosition pos, int row, @Nullable String buttonText) {
        this.optionType = null;
        this.opensOverlay = null;
        this.actionOnClick = null;
        this.opensScreen = opensScreen;
        this.position = pos;
        this.row = row;
        this.buttonText = Objects.requireNonNullElse(buttonText, "");
    }

    public OptionWidgetEntry(@NotNull VROverlay opensOverlay, @NotNull OptionWidgetPosition pos, int row, @Nullable String buttonText) {
        this.optionType = null;
        this.opensScreen = null;
        this.actionOnClick = null;
        this.opensOverlay = opensOverlay;
        this.position = pos;
        this.row = row;
        this.buttonText = Objects.requireNonNullElse(buttonText, "");
    }

    public OptionWidgetEntry(@NotNull Runnable actionOnClick, @NotNull OptionWidgetPosition pos, int row, @Nullable String buttonText) {
        this.optionType = null;
        this.opensScreen = null;
        this.opensOverlay = null;
        this.actionOnClick = actionOnClick;
        this.position = pos;
        this.row = row;
        this.buttonText = Objects.requireNonNullElse(buttonText, "");
    }

    public class_339 createWidget(class_437 forScreen) {
        if (this.optionType != null) {
            return this.optionType.getBehaviour().getWidget(this.getWidgetX(forScreen.field_22789), this.getWidgetY(forScreen.field_22790), this.getWidgetWidth(), this.getWidgetHeight());
        }
        class_4185.class_4241 onPress = button -> this.actionOnClick.run();
        if (this.opensScreen != null) {
            onPress = button -> {
                try {
                    ClientContext.settingsHandler.saveOptions();
                    class_310.method_1551().method_1507(this.opensScreen.getConstructor(class_437.class).newInstance(forScreen));
                }
                catch (ReflectiveOperationException exception) {
                    LoggerUtils.printError(exception);
                }
            };
        } else if (this.opensOverlay != null) {
            onPress = button -> {
                ClientContext.settingsHandler.saveOptions();
                this.opensOverlay.setEnabled(false);
                this.opensOverlay.setEnabled(true);
            };
        }
        return new class_4185.class_7840((class_2561)class_2561.method_43471((String)this.getButtonText()), onPress).method_46434(this.getWidgetX(forScreen.field_22789), this.getWidgetY(forScreen.field_22790), this.getWidgetWidth(), this.getWidgetHeight()).method_46431();
    }

    public int getWidgetX(int screenWidth) {
        if (this.position == OptionWidgetPosition.LEFT) {
            return screenWidth / 2 - this.getWidgetWidth() - 5;
        }
        if (this.position == OptionWidgetPosition.RIGHT) {
            return screenWidth / 2 + 5;
        }
        return screenWidth / 2 + 80 - this.getWidgetWidth() - 5;
    }

    public int getWidgetY(int screenHeight) {
        return (int)Math.ceil((float)(screenHeight / 6) + (float)((this.getWidgetHeight() + 1) * this.row) - 10.0f);
    }

    public int getWidgetWidth() {
        return 150;
    }

    public int getWidgetHeight() {
        return 20;
    }

    public String getButtonText() {
        return this.buttonText.isEmpty() && this.optionType != null ? ClientContext.settingsHandler.getOptionButtonName(this.optionType) : this.buttonText;
    }

    public int getOrdinal() {
        return this.optionType == null ? 0 : this.optionType.ordinal();
    }

    @Nullable
    public VROptionWidgetType getOptionType() {
        return this.optionType;
    }

    @Nullable
    public Class<? extends class_437> getOpensScreen() {
        return this.opensScreen;
    }

    @Nullable
    public VROverlay getOpensOverlay() {
        return this.opensOverlay;
    }

    @Nullable
    public Runnable getActionOnClick() {
        return this.actionOnClick;
    }
}

