/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.screens.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.gui.screens.settings.OptionWidgetEntry;
import me.phoenixra.visor.core.client.gui.screens.settings.OptionWidgetPosition;
import me.phoenixra.visor.core.client.settings.VROptionCategory;
import me.phoenixra.visor.core.client.settings.VROptionWidgetType;
import me.phoenixra.visor.core.client.utils.LangHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public abstract class VROptionsBaseScreen
extends class_437 {
    protected final VROptionCategory category;
    protected final class_437 previousScreen;
    private final Map<class_339, VROptionWidgetType> optionWidgets = new HashMap<class_339, VROptionWidgetType>();
    private int nextButtonIndex = 0;
    protected boolean initAgain;

    public VROptionsBaseScreen(VROptionCategory category, class_437 previousScreen) {
        super((class_2561)class_2561.method_43471((String)("visor.options." + category.getKey())));
        this.category = category;
        this.previousScreen = previousScreen;
    }

    protected abstract VROptionWidgetType[] getOptionTypes();

    protected abstract OptionWidgetEntry[] getOptionEntries();

    protected void method_25426() {
        VROptionWidgetType[] types;
        OptionWidgetEntry[] entries = this.getOptionEntries();
        if (entries != null && entries.length > 0) {
            this.initOptionEntries(entries, true);
        }
        if ((types = this.getOptionTypes()) == null || types.length < 1) {
            return;
        }
        this.initOptionTypes(types, entries == null || entries.length < 1);
    }

    protected void initOptionEntries(OptionWidgetEntry[] entries, boolean clear) {
        if (clear) {
            this.method_37067();
        }
        for (OptionWidgetEntry entry : entries) {
            class_339 widget = entry.createWidget(this);
            this.method_37063((class_364)widget);
            this.optionWidgets.put(widget, entry.getOptionType());
        }
        if (clear) {
            this.addDefaultButtons();
        }
    }

    protected void initOptionTypes(VROptionWidgetType[] options, boolean clear) {
        if (clear) {
            this.method_37067();
            this.nextButtonIndex = 0;
        }
        ArrayList<OptionWidgetEntry> result = new ArrayList<OptionWidgetEntry>();
        int i = this.nextButtonIndex;
        for (VROptionWidgetType option : options) {
            OptionWidgetPosition optionPos;
            OptionWidgetPosition optionWidgetPosition = optionPos = i % 2 == 0 ? OptionWidgetPosition.LEFT : OptionWidgetPosition.RIGHT;
            if (option != VROptionWidgetType.EMPTY) {
                result.add(new OptionWidgetEntry(option, optionPos, (int)Math.floor((float)i / 2.0f), null));
            }
            ++i;
        }
        this.nextButtonIndex = i;
        this.initOptionEntries(result.toArray(new OptionWidgetEntry[0]), false);
        if (clear) {
            this.addDefaultButtons();
        }
    }

    protected void method_37067() {
        super.method_37067();
        this.optionWidgets.clear();
    }

    public VROptionWidgetType getTypeFromWidget(class_339 widget) {
        return this.optionWidgets.get(widget);
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        this.method_25420(guiGraphics);
        if (this.initAgain) {
            this.initAgain = false;
            this.method_25426();
        }
        super.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        this.renderTooltip(guiGraphics, pMouseX, pMouseY);
    }

    private void renderTooltip(class_332 guiGraphics, int pMouseX, int pMouseY) {
        class_339 hovered = null;
        VROptionWidgetType hoveredOption = null;
        for (class_364 child : this.method_25396()) {
            class_339 widget;
            if (!(child instanceof class_339) || !this.isMouseOver(widget = (class_339)child, pMouseX, pMouseY)) continue;
            hovered = widget;
            hoveredOption = this.getTypeFromWidget(widget);
            break;
        }
        if (hoveredOption == null) {
            return;
        }
        String tooltipLang = "visor.options." + hoveredOption.getKey() + ".tooltip";
        if (!LangHelper.existsLangKey(tooltipLang)) {
            return;
        }
        Object tooltip = LangHelper.getText(tooltipLang, new Object[]{null});
        if (((String)tooltip).isEmpty()) {
            return;
        }
        tooltip = ((String)tooltip).replace("\n", "\u00a7r\n");
        List textToCheckSize = this.field_22793.method_27527().method_27498((String)tooltip, 310, class_2583.field_24360);
        tooltip = (String)tooltip + " ".repeat((310 - (textToCheckSize.isEmpty() ? 0 : this.field_22793.method_27525((class_5348)textToCheckSize.get(textToCheckSize.size() - 1)))) / this.field_22793.method_1727(" "));
        int n = hovered.method_46427() + hovered.method_25364();
        int n2 = textToCheckSize.size();
        Objects.requireNonNull(this.field_22793);
        if (n + n2 * (9 + 1) + 14 < this.field_22790) {
            guiGraphics.method_51447(this.field_22793, this.field_22793.method_1728((class_5348)class_2561.method_43470((String)tooltip), 308), this.field_22789 / 2 - 166, hovered.method_46427() + hovered.method_25364() + 14);
        } else {
            List list = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)tooltip), 308);
            int n3 = this.field_22789 / 2 - 166;
            int n4 = hovered.method_46427();
            int n5 = textToCheckSize.size();
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51447(this.field_22793, list, n3, n4 - n5 * (9 + 1) + 9);
        }
    }

    protected void addDefaultButtons() {
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.back"), button -> {
            ClientContext.settingsHandler.saveOptions();
            this.field_22787.method_1507(this.previousScreen);
        }).method_46433(this.field_22789 / 2 + 5, this.field_22790 - 30).method_46437(150, 20).method_46431());
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"visor.button.load_defaults"), button -> {
            this.loadDefaultSettings();
            ClientContext.settingsHandler.saveOptions();
            this.initAgain = true;
        }).method_46433(this.field_22789 / 2 - 155, this.field_22790 - 30).method_46437(150, 20).method_46431());
    }

    protected void loadDefaultSettings() {
        for (class_364 child : this.method_25396()) {
            class_339 widget;
            VROptionWidgetType optionType;
            if (!(child instanceof class_339) || (optionType = this.getTypeFromWidget(widget = (class_339)child)) == null) continue;
            ClientContext.settingsHandler.loadDefaultOptionValue(optionType.getKey());
        }
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            ClientContext.settingsHandler.saveOptions();
            this.field_22787.method_1507(this.previousScreen);
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    private boolean isMouseOver(class_339 widget, double x, double y) {
        return widget.field_22764 && x >= (double)widget.method_46426() && y >= (double)widget.method_46427() && x < (double)(widget.method_46426() + widget.method_25368()) && y < (double)(widget.method_46427() + widget.method_25364());
    }
}

