/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.input.actionset.actions;

import java.util.Map;
import me.phoenixra.atumvr.api.input.action.VRActionDataButton;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.input.InputHelper;
import me.phoenixra.visor.api.client.input.action.BindingPath;
import me.phoenixra.visor.api.client.input.action.VisorActionSet;
import me.phoenixra.visor.api.client.input.action.framework.VisorActionButton;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import org.jetbrains.annotations.NotNull;

public class ActionLeftMouse
extends VisorActionButton {
    public static final String ID = "mouse_left";
    private static final int BUTTON_TYPE = 0;
    private ControllerHand lastUsedHand = ControllerHand.MAIN;
    private VROverlay previousFocus;
    private boolean wasPressed;
    private boolean ignoreSingleClick;

    public ActionLeftMouse(VisorActionSet actionSet) {
        super(actionSet, ID);
    }

    @Override
    public void preTick() {
        VROverlay focusedOverlay = ClientContext.cursorHandler.getFocusedOverlay();
        if (focusedOverlay != null && this.previousFocus == null && InputHelper.isMousePressed(0)) {
            InputHelper.releaseMouse(0);
        } else if (focusedOverlay == null && this.previousFocus != null && this.wasPressed) {
            this.previousFocus.method_25406(this.previousFocus.getMouseX(), this.previousFocus.getMouseY(), 0);
            VROverlay vROverlay = this.previousFocus;
            if (vROverlay instanceof VROverlayScreen) {
                VROverlayScreen overlayScreen = (VROverlayScreen)vROverlay;
                overlayScreen.finishDragMouse();
            }
            this.wasPressed = false;
        } else if (focusedOverlay != null && this.previousFocus != null && focusedOverlay != this.previousFocus && this.wasPressed) {
            this.previousFocus.method_25406(this.previousFocus.getMouseX(), this.previousFocus.getMouseY(), 0);
            VROverlay vROverlay = this.previousFocus;
            if (vROverlay instanceof VROverlayScreen) {
                VROverlayScreen overlayScreen = (VROverlayScreen)vROverlay;
                overlayScreen.finishDragMouse();
            }
            this.wasPressed = false;
        }
        this.previousFocus = focusedOverlay;
        super.preTick();
    }

    @Override
    protected void onPress() {
        if (!ClientContext.visor.isFeatureEnabled(ClientFeature.INPUT_MOUSE)) {
            return;
        }
        ClientContext.inputManager.triggerHapticPulseClick(this.lastUsedHand);
        if (this.ignoreSingleClick) {
            return;
        }
        this.process(true);
    }

    @Override
    protected void onRelease() {
        if (this.ignoreSingleClick) {
            this.ignoreSingleClick = false;
            return;
        }
        this.process(false);
    }

    @Override
    protected void onClear() {
        InputHelper.releaseMouse(0);
        if (this.previousFocus != null && this.wasPressed) {
            this.previousFocus.method_25406(this.previousFocus.getMouseX(), this.previousFocus.getMouseY(), 0);
            VROverlay vROverlay = this.previousFocus;
            if (vROverlay instanceof VROverlayScreen) {
                VROverlayScreen overlayScreen = (VROverlayScreen)vROverlay;
                overlayScreen.finishDragMouse();
            }
        }
        this.previousFocus = null;
        this.wasPressed = false;
        this.ignoreSingleClick = false;
    }

    @Override
    public void updateState(@NotNull OpenXRProfileSet currentProfile, boolean leftHanded) {
        if (!ClientContext.cursorHandler.isAnyHandFocused()) {
            super.updateState(currentProfile, leftHanded);
            return;
        }
        BindingPath bindingPath = (BindingPath)this.bindings.get((Object)currentProfile.getType());
        if (bindingPath == null) {
            this.active = false;
            if (this.pressed) {
                this.releaseDelayed = true;
                this.pressDelayed = false;
            }
            return;
        }
        VRActionDataButton buttonDataOffhand = bindingPath.getButton(currentProfile, !leftHanded);
        VRActionDataButton buttonDataMain = bindingPath.getButton(currentProfile, leftHanded);
        if (buttonDataOffhand == null || buttonDataMain == null) {
            return;
        }
        this.processCursorUpdate(buttonDataOffhand, buttonDataMain);
        super.updateState(currentProfile, leftHanded);
    }

    private void processCursorUpdate(VRActionDataButton buttonDataOffhand, VRActionDataButton buttonDataMain) {
        boolean mainClicked;
        ControllerHand cursorHand = ClientContext.cursorHandler.getCursorHand();
        boolean offHandClicked = buttonDataOffhand.isPressed() && buttonDataOffhand.isButtonChanged();
        boolean bl = mainClicked = buttonDataMain.isPressed() && buttonDataMain.isButtonChanged();
        if (offHandClicked && mainClicked) {
            return;
        }
        if (cursorHand != ControllerHand.OFFHAND && offHandClicked && !buttonDataMain.isPressed() && !buttonDataMain.isButtonChanged()) {
            if (!ClientContext.cursorHandler.isHandFocused(ControllerHand.OFFHAND)) {
                return;
            }
            if (!ClientContext.cursorHandler.isTwoHandedCursor()) {
                this.ignoreSingleClick = true;
            }
            ClientContext.cursorHandler.setCursorHand(ControllerHand.OFFHAND);
            ClientContext.cursorHandler.process();
            return;
        }
        if (cursorHand != ControllerHand.MAIN && mainClicked && !buttonDataOffhand.isPressed() && !buttonDataOffhand.isButtonChanged()) {
            if (!ClientContext.cursorHandler.isHandFocused(ControllerHand.MAIN)) {
                return;
            }
            if (!ClientContext.cursorHandler.isTwoHandedCursor()) {
                this.ignoreSingleClick = true;
            }
            ClientContext.cursorHandler.setCursorHand(ControllerHand.MAIN);
            ClientContext.cursorHandler.process();
        }
    }

    private void process(boolean press) {
        VROverlay focusedOverlay = ClientContext.cursorHandler.getFocusedOverlay();
        if (focusedOverlay != null) {
            this.processOverlay(focusedOverlay, press);
            return;
        }
        if (VisorClientImpl.MC.field_1755 != null) {
            this.processScreen(press);
            return;
        }
        if (VisorClientImpl.MC.field_1724 != null) {
            this.processGame(press);
        }
    }

    private void processOverlay(VROverlay overlay, boolean press) {
        if (press) {
            overlay.method_25402(overlay.getMouseX(), overlay.getMouseY(), 0);
            if (overlay instanceof VROverlayScreen) {
                VROverlayScreen overlayScreen = (VROverlayScreen)overlay;
                overlayScreen.startDragMouse();
            }
            this.wasPressed = true;
        } else if (this.wasPressed) {
            overlay.method_25406(overlay.getMouseX(), overlay.getMouseY(), 0);
            if (overlay instanceof VROverlayScreen) {
                VROverlayScreen overlayScreen = (VROverlayScreen)overlay;
                overlayScreen.finishDragMouse();
            }
            this.wasPressed = false;
        }
    }

    private void processScreen(boolean press) {
        if (press && VisorClientImpl.MC.field_1687 != null) {
            InputHelper.pressKey(256);
            InputHelper.releaseKey(256);
        }
    }

    private void processGame(boolean press) {
        if (press) {
            InputHelper.pressMouse(0);
        } else {
            InputHelper.releaseMouse(0);
        }
    }

    @Override
    protected VRActionDataButton getButtonData(@NotNull BindingPath bindingPath, @NotNull OpenXRProfileSet currentProfile, boolean leftHanded) {
        ControllerHand cursorHand;
        boolean mainHand = !ClientContext.cursorHandler.isCursorHandFocused() && VisorClientImpl.MC.field_1755 == null && VisorClientImpl.MC.field_1724 != null ? ClientContext.player.getActiveHand() == ControllerHand.MAIN : (cursorHand = ClientContext.cursorHandler.getCursorHand()) == ControllerHand.MAIN;
        ControllerHand controllerHand = this.lastUsedHand = mainHand ? ControllerHand.MAIN : ControllerHand.OFFHAND;
        if (leftHanded) {
            return bindingPath.getButton(currentProfile, mainHand);
        }
        return bindingPath.getButton(currentProfile, !mainHand);
    }

    @Override
    protected Map<XRInteractionProfile, BindingPath> loadDefaults() {
        return Map.of(XRInteractionProfile.VALVE_INDEX, new BindingPath("button.trigger.right", "button.trigger.left"), XRInteractionProfile.OCULUS_TOUCH, new BindingPath("button.trigger.right", "button.trigger.left"));
    }
}

