/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.input.actionset.actions;

import java.util.Map;
import me.phoenixra.atumvr.api.input.action.VRActionDataButton;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.input.InputHelper;
import me.phoenixra.visor.api.client.input.action.BindingPath;
import me.phoenixra.visor.api.client.input.action.VisorActionSet;
import me.phoenixra.visor.api.client.input.action.framework.VisorActionButton;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import org.jetbrains.annotations.NotNull;

public class ActionMiddleMouse
extends VisorActionButton {
    public static final String ID = "mouse_middle";
    private static final int BUTTON_TYPE = 2;
    private ControllerHand lastUsedHand = ControllerHand.MAIN;
    private VROverlay previousFocus;
    private boolean wasPressed;

    public ActionMiddleMouse(VisorActionSet actionSet) {
        super(actionSet, ID);
    }

    @Override
    public void preTick() {
        VROverlay focusedOverlay = ClientContext.cursorHandler.getFocusedOverlay();
        if (focusedOverlay != null && this.previousFocus == null && InputHelper.isMousePressed(2)) {
            InputHelper.releaseMouse(2);
        } else if (focusedOverlay == null && this.previousFocus != null && this.wasPressed) {
            this.previousFocus.method_25406(this.previousFocus.getMouseX(), this.previousFocus.getMouseY(), 2);
            VROverlay vROverlay = this.previousFocus;
            if (vROverlay instanceof VROverlayScreen) {
                VROverlayScreen overlayScreen = (VROverlayScreen)vROverlay;
                overlayScreen.finishDragMouse();
            }
            this.wasPressed = false;
        } else if (focusedOverlay != null && this.previousFocus != null && focusedOverlay != this.previousFocus && this.wasPressed) {
            this.previousFocus.method_25406(this.previousFocus.getMouseX(), this.previousFocus.getMouseY(), 2);
            VROverlay vROverlay = this.previousFocus;
            if (vROverlay instanceof VROverlayScreen) {
                VROverlayScreen overlayScreen = (VROverlayScreen)vROverlay;
                overlayScreen.finishDragMouse();
            }
            this.wasPressed = false;
        }
        this.previousFocus = focusedOverlay;
        super.preTick();
    }

    @Override
    protected void onPress() {
        if (!ClientContext.visor.isFeatureEnabled(ClientFeature.INPUT_MOUSE)) {
            return;
        }
        ClientContext.inputManager.triggerHapticPulseClick(this.lastUsedHand);
        this.process(true);
    }

    @Override
    protected void onRelease() {
        this.process(false);
    }

    @Override
    protected void onClear() {
        InputHelper.releaseMouse(2);
        if (this.previousFocus != null && this.wasPressed) {
            this.previousFocus.method_25406(this.previousFocus.getMouseX(), this.previousFocus.getMouseY(), 2);
        }
        this.previousFocus = null;
        this.wasPressed = false;
    }

    private void process(boolean press) {
        VROverlay focusedOverlay = ClientContext.cursorHandler.getFocusedOverlay();
        if (focusedOverlay != null) {
            this.processOverlay(focusedOverlay, press);
            return;
        }
        if (VisorClientImpl.MC.field_1755 != null) {
            return;
        }
        if (VisorClientImpl.MC.field_1724 != null) {
            this.processGame(press);
        }
    }

    private void processOverlay(VROverlay overlay, boolean press) {
        if (press) {
            overlay.method_25402(overlay.getMouseX(), overlay.getMouseY(), 2);
            this.wasPressed = true;
        } else if (this.wasPressed) {
            overlay.method_25406(overlay.getMouseX(), overlay.getMouseY(), 2);
            this.wasPressed = false;
        }
    }

    private void processGame(boolean press) {
        if (press) {
            InputHelper.pressMouse(2);
        } else {
            InputHelper.releaseMouse(2);
        }
    }

    @Override
    protected VRActionDataButton getButtonData(@NotNull BindingPath bindingPath, @NotNull OpenXRProfileSet currentProfile, boolean leftHanded) {
        ControllerHand cursorHand;
        boolean mainHand = !ClientContext.cursorHandler.isCursorHandFocused() && VisorClientImpl.MC.field_1755 == null && VisorClientImpl.MC.field_1724 != null ? ClientContext.player.getActiveHand() == ControllerHand.MAIN : (cursorHand = ClientContext.cursorHandler.getCursorHand()) == ControllerHand.MAIN;
        ControllerHand controllerHand = this.lastUsedHand = mainHand ? ControllerHand.MAIN : ControllerHand.OFFHAND;
        if (leftHanded) {
            return bindingPath.getButton(currentProfile, mainHand);
        }
        return bindingPath.getButton(currentProfile, !mainHand);
    }

    @Override
    protected Map<XRInteractionProfile, BindingPath> loadDefaults() {
        return Map.of(XRInteractionProfile.VALVE_INDEX, new BindingPath("button.grip.force.right", "button.grip.force.left"), XRInteractionProfile.OCULUS_TOUCH, new BindingPath("null", "null"));
    }
}

