/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.input.actionset.game;

import java.util.Map;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.visor.api.client.input.action.BindingPath;
import me.phoenixra.visor.api.client.input.action.VisorActionSet;
import me.phoenixra.visor.api.client.input.action.framework.VisorActionVec2;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.tasks.movement.TaskInputRotation;
import org.joml.Vector2f;

public class GameActionRotate
extends VisorActionVec2 {
    public static final String ID = "rotate";
    private static final float ROTATION_THRESHOLD = 0.5f;
    private boolean alreadyRotated;

    public GameActionRotate(VisorActionSet actionSet) {
        super(actionSet, ID);
    }

    @Override
    protected void onStateChanged(Vector2f newState) {
        if (this.alreadyRotated) {
            if (Math.abs(newState.x) < 0.5f) {
                this.alreadyRotated = false;
            }
            return;
        }
        float inputPosX = newState.x;
        if (Math.abs(inputPosX) > 0.5f) {
            float rotationIncrementer = (float)Math.toRadians(VRClientSettings.getWorldRotationIncrement());
            float currentRotation = ClientContext.player.getRotationY();
            float newRotation = currentRotation - rotationIncrementer * Math.signum(inputPosX);
            TaskInputRotation.getInstance().setInputRotation(newRotation);
            this.alreadyRotated = true;
        }
    }

    @Override
    protected Map<XRInteractionProfile, BindingPath> loadDefaults() {
        return Map.of(XRInteractionProfile.VALVE_INDEX, new BindingPath("vec2.thumbstick.right", "vec2.thumbstick.left"), XRInteractionProfile.OCULUS_TOUCH, new BindingPath("vec2.thumbstick.right", "vec2.thumbstick.left"));
    }
}

