/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.network.players;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import me.phoenixra.visor.api.common.network.buffer.PlayerPoseBuffer;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.network.players.VRRemotePlayerData;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VRRemotePlayers {
    private final Map<UUID, VRRemotePlayerData> vrPlayers = new HashMap<UUID, VRRemotePlayerData>();
    private final Map<UUID, VRRemotePlayerData> vrPlayersLastTick = new HashMap<UUID, VRRemotePlayerData>();
    private final Map<UUID, VRRemotePlayerData> vrPlayersReceived = Collections.synchronizedMap(new HashMap());
    private static VRRemotePlayers instance;

    public void tick() {
        this.vrPlayersLastTick.putAll(this.vrPlayers);
        this.vrPlayers.putAll(this.vrPlayersReceived);
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        Iterator<UUID> iterator = this.vrPlayers.keySet().iterator();
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            if (level.method_18470(uuid) != null) {
                return;
            }
            iterator.remove();
            this.vrPlayersLastTick.remove(uuid);
            this.vrPlayersReceived.remove(uuid);
        }
    }

    public VRRemotePlayerData getPlayer(UUID uuid) {
        VRRemotePlayerData playerData1 = this.vrPlayers.get(uuid);
        if (playerData1 != null && this.vrPlayersLastTick.containsKey(uuid)) {
            VRRemotePlayerData playerDataPrev = this.vrPlayersLastTick.get(uuid);
            float frameTime = class_310.method_1551().method_1488();
            return new VRRemotePlayerData(playerData1.offhandRotation(), (Vector3fc)VRMathUtils.lerpVector(playerDataPrev.offhandDirection(), (Vector3fc)playerData1.offhandRotation().transform(VRMathUtils.BACK_VECTOR, new Vector3f()), frameTime), (Vector3fc)VRMathUtils.lerpVector(playerDataPrev.offhandPosition(), playerData1.offhandPosition(), frameTime), playerData1.mainHandRotation(), (Vector3fc)VRMathUtils.lerpVector(playerDataPrev.mainHandDirection(), (Vector3fc)playerData1.mainHandRotation().transform(VRMathUtils.BACK_VECTOR, new Vector3f()), frameTime), (Vector3fc)VRMathUtils.lerpVector(playerDataPrev.mainHandPosition(), playerData1.mainHandPosition(), frameTime), playerData1.hmdRotation(), (Vector3fc)VRMathUtils.lerpVector(playerDataPrev.hmdDirection(), (Vector3fc)playerData1.hmdRotation().transform(VRMathUtils.BACK_VECTOR, new Vector3f()), frameTime), (Vector3fc)VRMathUtils.lerpVector(playerDataPrev.hmdPosition(), playerData1.hmdPosition(), frameTime), playerData1.worldScale(), playerData1.heightScale(), playerData1.headsetModel(), playerData1.leftHanded());
        }
        return playerData1;
    }

    public void applyPlayer(UUID uuid, PlayerPoseBuffer poseBuffer, float worldScale, float heightScale, boolean localPlayer) {
        if (!localPlayer && VisorClientImpl.MC.field_1724.method_5667().equals(uuid)) {
            return;
        }
        Vector3f hmdDir = poseBuffer.hmd().orientation().transform(VRMathUtils.BACK_VECTOR, new Vector3f());
        Vector3f mainHandDir = poseBuffer.mainHand().orientation().transform(VRMathUtils.BACK_VECTOR, new Vector3f());
        Vector3f offhandDir = poseBuffer.offhand().orientation().transform(VRMathUtils.BACK_VECTOR, new Vector3f());
        heightScale = Math.max(0.5f, Math.min(1.5f, heightScale));
        VRRemotePlayerData playerData = new VRRemotePlayerData(poseBuffer.offhand().orientation(), (Vector3fc)new Vector3f(offhandDir.x(), offhandDir.y(), offhandDir.z()), poseBuffer.offhand().position(), poseBuffer.mainHand().orientation(), (Vector3fc)new Vector3f(mainHandDir.x(), mainHandDir.y(), mainHandDir.z()), poseBuffer.mainHand().position(), poseBuffer.hmd().orientation(), (Vector3fc)new Vector3f(hmdDir.x(), hmdDir.y(), hmdDir.z()), poseBuffer.hmd().position(), worldScale, heightScale, 0, poseBuffer.leftHanded());
        this.vrPlayersReceived.put(uuid, playerData);
    }

    public void applyPlayer(UUID uuid, PlayerPoseBuffer poseBuffer, float worldScale, float heightScale) {
        this.applyPlayer(uuid, poseBuffer, worldScale, heightScale, false);
    }

    public void removePlayer(UUID player) {
        this.vrPlayers.remove(player);
        this.vrPlayersLastTick.remove(player);
        this.vrPlayersReceived.remove(player);
    }

    public boolean isTracked(UUID uuid) {
        return this.vrPlayers.containsKey(uuid);
    }

    public static void clear() {
        if (instance != null) {
            VRRemotePlayers.instance.vrPlayers.clear();
            VRRemotePlayers.instance.vrPlayersLastTick.clear();
            VRRemotePlayers.instance.vrPlayersReceived.clear();
        }
    }

    public static VRRemotePlayers getInstance() {
        if (instance == null) {
            instance = new VRRemotePlayers();
        }
        return instance;
    }
}

