/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.provider;

import com.mojang.blaze3d.systems.RenderSystem;
import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.api.rendering.IRenderContext;
import me.phoenixra.atumvr.api.rendering.VRRenderer;
import me.phoenixra.atumvr.api.rendering.VRScene;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.render.VRShaders;
import me.phoenixra.visor.core.client.render.context.RenderContext;
import me.phoenixra.visor.core.client.render.helpers.MirrorHelper;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.utils.ClientUtils;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import org.jetbrains.annotations.NotNull;

public class VisorScene
implements VRScene {
    private VRRenderer vrRenderer;

    public VisorScene(VRRenderer vrRenderer) {
        this.vrRenderer = vrRenderer;
    }

    @Override
    public void init() {
    }

    @Override
    public void render(@NotNull IRenderContext context) {
        RenderContext renderContext = (RenderContext)context;
        class_3695 profiler = renderContext.profiler();
        RenderSystem.getModelViewStack().method_22909();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.applyModelViewMatrix();
        profiler.method_15396("prepare VROverlays and cursor");
        ClientContext.overlayManager.prepareOverlaysAndCursor(context.partialTicks());
        profiler.method_15407();
        profiler.method_15396("VROverlay texturing");
        class_332 guiGraphics = new class_332(VisorClientImpl.MC, VisorClientImpl.MC.method_22940().method_23000());
        ClientContext.overlayManager.renderOverlayTextures(VisorClientImpl.MC.method_16011(), guiGraphics, renderContext.partialTicks());
        profiler.method_15407();
        GLUtils.checkGLError("post VR Overlays texturing");
        for (VRDisplay display : VRRenderState.getVRWorldDisplays()) {
            profiler.method_15396("VR world display: " + display.name());
            this.renderVRDisplay(display, renderContext);
            GLUtils.checkGLError("post VR world display render: " + display.name());
            if (ClientContext.renderer.isAskedForScreenShot()) {
                this.takeScreenshot(display);
            }
            profiler.method_15407();
        }
        profiler.method_15396("VR mirror");
        VRRenderState.startVRMirrorPhase();
        VisorClientImpl.MC.field_1689.method_1235(true);
        MirrorHelper.drawMirror();
        profiler.method_15407();
        GLUtils.checkGLError("post mirror");
    }

    private void takeScreenshot(VRDisplay currentStage) {
        boolean flag;
        if (currentStage == VRDisplay.FIRST_PERSON) {
            flag = true;
        } else {
            boolean bl = VRClientSettings.getMirrorEye() == EyeType.LEFT ? currentStage == VRDisplay.EYE_LEFT : (flag = currentStage == VRDisplay.EYE_RIGHT);
        }
        if (flag) {
            class_276 rendertarget = VisorClientImpl.MC.field_1689;
            VisorClientImpl.MC.field_1689.method_1240();
            ClientUtils.takeScreenshot(rendertarget);
            VisorClientImpl.MC.method_22683().method_15998();
            ClientContext.renderer.setAskedForScreenShot(false);
        }
    }

    @Override
    public void destroy() {
    }

    private void renderVRDisplay(VRDisplay display, RenderContext context) {
        VRRenderState.startVRWorldPhase(display);
        VisorClientImpl.MC.field_1689.method_1235(true);
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.clear((int)16384, (boolean)class_310.field_1703);
        RenderSystem.enableDepthTest();
        VisorClientImpl.MC.field_1773.method_3192(context.partialTicks(), context.nanoTime(), context.renderLevel());
        if (display.isEye()) {
            if (display == VRDisplay.EYE_LEFT) {
                ClientContext.renderer.getTextureLeftEye().getRenderTarget().method_1235(true);
            } else {
                ClientContext.renderer.getTextureRightEye().getRenderTarget().method_1235(true);
            }
            VRShaders.getPostProcess().finishEye(display == VRDisplay.EYE_LEFT ? EyeType.LEFT : EyeType.RIGHT, VisorClientImpl.MC.field_1689, context.partialTicks());
        }
    }

    @Override
    public VRRenderer getVrRenderer() {
        return this.vrRenderer;
    }
}

