/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.provider.openxr;

import java.util.List;
import me.phoenixra.atumvr.api.enums.ControllerType;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.input.OpenXRInputHandler;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.profileset.ProfileSetHolder;
import me.phoenixra.atumvr.core.input.device.OpenXRDevice;
import me.phoenixra.atumvr.core.input.device.OpenXRDeviceController;
import me.phoenixra.atumvr.core.input.device.OpenXRDeviceHMD;
import org.lwjgl.system.MemoryStack;

public class XrInputHandler
extends OpenXRInputHandler {
    private ProfileSetHolder profileSetHolder;

    public XrInputHandler(OpenXRProvider provider) {
        super(provider);
    }

    @Override
    protected List<? extends OpenXRActionSet> generateActionSets(MemoryStack stack) {
        this.profileSetHolder = new ProfileSetHolder(this.getVrProvider());
        return this.profileSetHolder.getAllSets();
    }

    @Override
    protected List<? extends OpenXRDevice> generateDevices(MemoryStack stack) {
        return List.of(new OpenXRDeviceHMD(this.getVrProvider()), new OpenXRDeviceController(this.getVrProvider(), ControllerType.LEFT, this.profileSetHolder.getSharedSet().getHandPoseAim(), this.profileSetHolder.getSharedSet().getHandPoseGrip(), this.profileSetHolder.getSharedSet().getHapticPulse()), new OpenXRDeviceController(this.getVrProvider(), ControllerType.RIGHT, this.profileSetHolder.getSharedSet().getHandPoseAim(), this.profileSetHolder.getSharedSet().getHandPoseGrip(), this.profileSetHolder.getSharedSet().getHapticPulse()));
    }

    public ProfileSetHolder getProfileSetHolder() {
        return this.profileSetHolder;
    }
}

