/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.provider.openxr.render;

import java.nio.IntBuffer;
import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.api.rendering.IRenderContext;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.atumvr.core.input.device.OpenXRDeviceHMD;
import me.phoenixra.visor.core.client.provider.VisorScene;
import me.phoenixra.visor.core.client.provider.openxr.XrProvider;
import me.phoenixra.visor.core.client.provider.openxr.render.XrEyeTexture;
import me.phoenixra.visor.core.client.render.VRRendererBase;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.KHRVisibilityMask;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrCompositionLayerProjection;
import org.lwjgl.openxr.XrCompositionLayerProjectionView;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.openxr.XrFrameBeginInfo;
import org.lwjgl.openxr.XrFrameEndInfo;
import org.lwjgl.openxr.XrFrameState;
import org.lwjgl.openxr.XrFrameWaitInfo;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSwapchain;
import org.lwjgl.openxr.XrSwapchainImageAcquireInfo;
import org.lwjgl.openxr.XrSwapchainImageBaseHeader;
import org.lwjgl.openxr.XrSwapchainImageOpenGLKHR;
import org.lwjgl.openxr.XrSwapchainImageReleaseInfo;
import org.lwjgl.openxr.XrSwapchainImageWaitInfo;
import org.lwjgl.openxr.XrSwapchainSubImage;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.openxr.XrView;
import org.lwjgl.openxr.XrViewLocateInfo;
import org.lwjgl.openxr.XrViewState;
import org.lwjgl.openxr.XrVisibilityMaskKHR;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Pointer;

public class XrRenderer
extends VRRendererBase {
    private final XrProvider vrProvider;
    protected int swapIndex;
    protected XrEyeTexture[] leftFramebuffers;
    protected XrEyeTexture[] rightFramebuffers;
    protected XrCompositionLayerProjectionView.Buffer projectionLayerViews;
    boolean frameStarted;
    private final VisorScene currentScene;

    public XrRenderer(XrProvider provider) {
        this.vrProvider = provider;
        this.currentScene = new VisorScene(this);
    }

    @Override
    public void preRender(@NotNull IRenderContext context) {
        if (this.frameStarted) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrFrameState frameState = XrFrameState.calloc((MemoryStack)stack).type(44);
            this.vrProvider.checkXRError(XR10.xrWaitFrame((XrSession)this.vrProvider.getState().getVrSession().getHandle(), (XrFrameWaitInfo)XrFrameWaitInfo.calloc((MemoryStack)stack).type(33), (XrFrameState)frameState), "xrWaitFrame", "");
            this.vrProvider.setXrDisplayTime(frameState.predictedDisplayTime());
            this.vrProvider.checkXRError(XR10.xrBeginFrame((XrSession)this.vrProvider.getState().getVrSession().getHandle(), (XrFrameBeginInfo)XrFrameBeginInfo.calloc((MemoryStack)stack).type(46)), "xrBeginFrame", "");
            XrViewState viewState = XrViewState.calloc((MemoryStack)stack).type(11);
            IntBuffer intBuf = stack.callocInt(1);
            XrViewLocateInfo viewLocateInfo = XrViewLocateInfo.calloc((MemoryStack)stack);
            viewLocateInfo.set(6, 0L, 2, frameState.predictedDisplayTime(), this.vrProvider.getState().getVrSession().getXrAppSpace());
            this.vrProvider.checkXRError(XR10.xrLocateViews((XrSession)this.vrProvider.getState().getVrSession().getHandle(), (XrViewLocateInfo)viewLocateInfo, (XrViewState)viewState, (IntBuffer)intBuf, (XrView.Buffer)this.vrProvider.getState().getVrSwapChain().getXrViewBuffer()), "xrLocateViews", "");
        }
        this.frameStarted = true;
    }

    @Override
    public void renderFrame(@NotNull IRenderContext context) {
        if (!this.frameStarted) {
            return;
        }
        try {
            this.prepareSwapChains();
            this.getCurrentScene().render(context);
        }
        finally {
            this.frameStarted = false;
            this.finishFrame();
        }
    }

    private void prepareSwapChains() {
        XrSwapchain xrSwapchain = this.vrProvider.getState().getVrSwapChain().getHandle();
        this.projectionLayerViews = XrCompositionLayerProjectionView.calloc((int)2);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer intBuf2 = stack.callocInt(1);
            this.vrProvider.checkXRError(XR10.xrAcquireSwapchainImage((XrSwapchain)xrSwapchain, (XrSwapchainImageAcquireInfo)XrSwapchainImageAcquireInfo.calloc((MemoryStack)stack).type(55), (IntBuffer)intBuf2), "xrAcquireSwapchainImage", "");
            this.vrProvider.checkXRError(XR10.xrWaitSwapchainImage((XrSwapchain)xrSwapchain, (XrSwapchainImageWaitInfo)XrSwapchainImageWaitInfo.calloc((MemoryStack)stack).type(56).timeout(Long.MAX_VALUE)), "xrWaitSwapchainImage", "");
            this.swapIndex = intBuf2.get(0);
            for (EyeType eyeType : EyeType.values()) {
                int index = eyeType.getIndex();
                XrView xrView = this.vrProvider.getInputHandler().getDevice("hmd", OpenXRDeviceHMD.class).getXrView(eyeType);
                XrSwapchainSubImage subImage = ((XrCompositionLayerProjectionView)this.projectionLayerViews.get(index)).type(48).pose(xrView.pose()).fov(xrView.fov()).subImage();
                subImage.swapchain(xrSwapchain);
                subImage.imageRect().offset().set(0, 0);
                subImage.imageRect().extent().set(this.resolutionWidth, this.resolutionHeight);
                subImage.imageArrayIndex(index);
            }
        }
    }

    public void finishFrame() {
        XrSwapchain xrSwapchain = this.vrProvider.getState().getVrSwapChain().getHandle();
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer layers = stack.callocPointer(1);
            int error = XR10.xrReleaseSwapchainImage((XrSwapchain)xrSwapchain, (XrSwapchainImageReleaseInfo)XrSwapchainImageReleaseInfo.calloc((MemoryStack)stack).type(57));
            this.vrProvider.checkXRError(error, "xrReleaseSwapchainImage", "");
            XrCompositionLayerProjection compositionLayerProjection = XrCompositionLayerProjection.calloc((MemoryStack)stack).type(35).space(this.vrProvider.getState().getVrSession().getXrAppSpace()).views(this.projectionLayerViews);
            layers.put((Pointer)compositionLayerProjection);
            layers.flip();
            error = XR10.xrEndFrame((XrSession)this.vrProvider.getState().getVrSession().getHandle(), (XrFrameEndInfo)XrFrameEndInfo.calloc((MemoryStack)stack).type(12).displayTime(this.vrProvider.getXrDisplayTime()).environmentBlendMode(1).layers(layers));
            this.vrProvider.checkXRError(error, "xrEndFrame", "");
            this.projectionLayerViews.close();
        }
    }

    @Override
    public Matrix4f getProjectionMatrix(EyeType eyeType, float nearClip, float farClip) {
        XrFovf fov = this.vrProvider.getInputHandler().getDevice("hmd", OpenXRDeviceHMD.class).getXrView(eyeType).fov();
        return new Matrix4f().setPerspectiveOffCenterFov(fov.angleLeft(), fov.angleRight(), fov.angleDown(), fov.angleUp(), nearClip, farClip);
    }

    @Override
    protected void setupResolution(MemoryStack stack) {
        this.resolutionWidth = this.vrProvider.getState().getEyeTexWidth();
        this.resolutionHeight = this.vrProvider.getState().getEyeTexHeight();
    }

    @Override
    protected void setupEyes() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer intBuffer = stack.ints(0);
            int error = XR10.xrEnumerateSwapchainImages((XrSwapchain)this.vrProvider.getState().getVrSwapChain().getHandle(), (IntBuffer)intBuffer, null);
            this.vrProvider.checkXRError(error, "xrEnumerateSwapchainImages", "get count");
            int imageCount = intBuffer.get(0);
            XrSwapchainImageOpenGLKHR.Buffer swapchainImageBuffer = this.vrProvider.getState().getVrSwapChain().createImageBuffers(imageCount, stack);
            error = XR10.xrEnumerateSwapchainImages((XrSwapchain)this.vrProvider.getState().getVrSwapChain().getHandle(), (IntBuffer)intBuffer, (XrSwapchainImageBaseHeader.Buffer)XrSwapchainImageBaseHeader.create((long)swapchainImageBuffer.address(), (int)swapchainImageBuffer.capacity()));
            this.vrProvider.checkXRError(error, "xrEnumerateSwapchainImages", "get images");
            this.leftFramebuffers = new XrEyeTexture[imageCount];
            this.rightFramebuffers = new XrEyeTexture[imageCount];
            for (int i = 0; i < imageCount; ++i) {
                XrSwapchainImageOpenGLKHR openxrImage = (XrSwapchainImageOpenGLKHR)swapchainImageBuffer.get(i);
                this.leftFramebuffers[i] = new XrEyeTexture(this.resolutionWidth, this.resolutionHeight, openxrImage.image(), 0).init();
                GLUtils.checkGLError("Left Eye " + i + " framebuffer setup");
                this.rightFramebuffers[i] = new XrEyeTexture(this.resolutionWidth, this.resolutionHeight, openxrImage.image(), 1).init();
                GLUtils.checkGLError("Right Eye " + i + " framebuffer setup");
            }
        }
    }

    @Override
    protected void setupHiddenArea(MemoryStack stack) {
        XrSession xrSession = this.getVrProvider().getState().getVrSession().getHandle();
        for (int eye = 0; eye < 2; ++eye) {
            XrVisibilityMaskKHR mask = XrVisibilityMaskKHR.calloc((MemoryStack)stack).type(1000031000).next(0L);
            this.getVrProvider().checkXRError(KHRVisibilityMask.xrGetVisibilityMaskKHR((XrSession)xrSession, (int)2, (int)eye, (int)1, (XrVisibilityMaskKHR)mask), "xrGetVisibilityMaskKHR", "query counts");
            int vertCount = mask.vertexCountOutput();
            int indexCount = mask.indexCountOutput();
            if (indexCount <= 0) {
                this.getVrProvider().getLogger().logInfo("No hidden-area mesh found for eye " + eye);
                continue;
            }
            XrVector2f.Buffer verts = XrVector2f.calloc((int)vertCount, (MemoryStack)stack);
            IntBuffer idxBuf = stack.mallocInt(indexCount);
            mask.vertexCapacityInput(vertCount).indexCapacityInput(indexCount).vertices(verts).indices(idxBuf);
            this.getVrProvider().checkXRError(KHRVisibilityMask.xrGetVisibilityMaskKHR((XrSession)xrSession, (int)2, (int)eye, (int)1, (XrVisibilityMaskKHR)mask), "xrGetVisibilityMaskKHR", "retrieve mesh");
            float[] area = new float[indexCount * 2];
            for (int i = 0; i < indexCount; ++i) {
                XrVector2f v = (XrVector2f)verts.get(idxBuf.get(i));
                float ux = v.x() * 0.5f + 0.5f;
                float uy = v.y() * 0.5f + 0.5f;
                area[i * 2] = ux * (float)this.getResolutionWidth();
                area[i * 2 + 1] = uy * (float)this.getResolutionHeight();
            }
            this.hiddenArea.put(EyeType.asIndex(eye), area);
            System.out.println("Hidden-area mesh loaded for eye " + eye);
        }
    }

    @Override
    public XrEyeTexture getTextureLeftEye() {
        if (this.leftFramebuffers == null) {
            return null;
        }
        return this.leftFramebuffers[this.swapIndex];
    }

    @Override
    public XrEyeTexture getTextureRightEye() {
        if (this.rightFramebuffers == null) {
            return null;
        }
        return this.rightFramebuffers[this.swapIndex];
    }

    @Override
    public XrProvider getVrProvider() {
        return this.vrProvider;
    }

    @Override
    public VisorScene getCurrentScene() {
        return this.currentScene;
    }
}

