/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration.effects.hand;

import com.mojang.blaze3d.systems.RenderSystem;
import me.phoenixra.atumvr.api.misc.color.AtumColorImmutable;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.gui.helpers.TexturesHelper;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.client.render.decoration.VRDecorator;
import me.phoenixra.visor.api.client.render.decoration.annotations.RegisterVRHandEffect;
import me.phoenixra.visor.api.client.render.decoration.effects.VRHandEffect;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.compatibility.ShadersHelper;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.gui.VRCursorHandlerImpl;
import me.phoenixra.visor.core.client.render.helpers.RenderHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@RegisterVRHandEffect
public class GlobalHandEffectCursor
extends VRHandEffect {
    public static final String ID = "cursor";
    private static final AtumColorImmutable DEFAULT_COLOR = new AtumColorImmutable(228, 228, 228, 255);
    private static final float BOX_HALF_SIZE = 0.0016f;

    public GlobalHandEffectCursor(@NotNull VisorAddon owner) {
        super(owner);
    }

    @Override
    public void render(@NotNull ControllerHand hand, @NotNull VRDisplay renderDisplay, @NotNull class_4587 poseStack, boolean simpleHand, float partialTicks) {
        AtumColorImmutable color;
        VRCursorHandlerImpl cursorHandler = ClientContext.cursorHandler;
        float cursorLength = (float)cursorHandler.getCursorLineLength(hand);
        if (cursorLength <= 0.0f) {
            return;
        }
        Vector3f start = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f end = new Vector3f(0.0f, 0.0f, -cursorLength);
        if (VisorClientImpl.MC.field_1687 != null) {
            float rawLight = VisorClientImpl.MC.field_1687.method_22339(class_2338.method_49638((class_2374)new class_243((Vector3f)ClientContext.player.getPoseData(PoseDataType.RENDER).getHmd().getPosition())));
            float light = Math.max(rawLight, (float)ShadersHelper.shaderLight());
            float lightPercent = light / (float)VisorClientImpl.MC.field_1687.method_8315();
            color = new AtumColorImmutable(class_3532.method_15375((float)((float)DEFAULT_COLOR.getRedInt() * lightPercent)), class_3532.method_15375((float)((float)DEFAULT_COLOR.getGreenInt() * lightPercent)), class_3532.method_15375((float)((float)DEFAULT_COLOR.getBlueInt() * lightPercent)), 255);
        } else {
            color = DEFAULT_COLOR;
        }
        class_287 builder = class_289.method_1348().method_1349();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        RenderSystem.setShader(class_757::method_34540);
        if (VisorClientImpl.MC.method_18506() == null) {
            class_2960 whiteTex = TexturesHelper.getWhiteTexture();
            VisorClientImpl.MC.method_1531().method_22813(whiteTex);
            RenderSystem.setShaderTexture((int)0, (class_2960)whiteTex);
        }
        RenderHelper.renderCuboid(builder, poseStack.method_23760().method_23761(), (Vector3fc)start, (Vector3fc)end, -0.0016f, 0.0016f, -0.0016f, 0.0016f, color);
        RenderSystem.depthFunc((int)515);
    }

    @Override
    public boolean isVisible(@NotNull VRDecorator currentDecorator, @NotNull ControllerHand hand, boolean simpleHand) {
        VRCursorHandlerImpl cursorHandler = ClientContext.cursorHandler;
        if (!ClientContext.visor.isFeatureEnabled(ClientFeature.GUI_CURSOR)) {
            return false;
        }
        if (cursorHandler.isTwoHandedCursor()) {
            return true;
        }
        if (!cursorHandler.isCursorHandFocused()) {
            return false;
        }
        return cursorHandler.getCursorHand() == hand;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public VRHandEffect.RenderStage renderAtStage() {
        return VRHandEffect.RenderStage.BEFORE_HANDS;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }
}

