/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration.hand;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import me.phoenixra.atumvr.api.misc.color.AtumColorImmutable;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.gui.helpers.TexturesHelper;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.client.render.decoration.VRDecorator;
import me.phoenixra.visor.api.client.render.decoration.effects.VRHandEffect;
import me.phoenixra.visor.api.client.render.decoration.hand.VRHandItemPose;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.compatibility.ShadersHelper;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.gui.VRCursorHandlerImpl;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.render.decoration.registry.VRHandEffectRegistry;
import me.phoenixra.visor.core.client.render.decoration.registry.VRHandItemPoseRegistry;
import me.phoenixra.visor.core.client.render.helpers.RenderHelper;
import me.phoenixra.visor.core.client.render.helpers.RenderPoseHelper;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.settings.options.enums.MirrorMode;
import me.phoenixra.visor.modified.client.render.GameRendererModified;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VRHandRenderer {
    private static final AtumColorImmutable GUI_HANDS_COLOR = new AtumColorImmutable(64, 64, 64, 255);
    private final VRHandItemPoseRegistry itemPosesRegistry = new VRHandItemPoseRegistry();
    private final VRHandEffectRegistry effectsRegistry = new VRHandEffectRegistry();

    public void applyItemHandPose(@NotNull class_742 player, @NotNull ControllerHand hand, @NotNull class_1799 itemStack, @NotNull class_4587 poseStack, float equippedProgress, float partialTicks) {
        for (VRHandItemPose entry : this.itemPosesRegistry.getSortedElements()) {
            if (!entry.isEnabledAndCanApplyPose(player, hand, itemStack)) continue;
            entry.applyPose(poseStack, player, hand, itemStack, equippedProgress, partialTicks);
            return;
        }
    }

    public void renderWorldHands(@NotNull VRDecorator decorator, @NotNull class_4587 poseStack, float partialTicks, boolean renderMain, boolean renderOffhand) {
        this.renderHands(decorator, poseStack, partialTicks, renderMain, renderOffhand, false);
    }

    public void renderGuiHands(@NotNull VRDecorator decorator, @NotNull class_4587 poseStack, float partialTicks, boolean renderMain, boolean renderOffhand) {
        this.renderHands(decorator, poseStack, partialTicks, renderMain, renderOffhand, true);
    }

    public void renderHands(@NotNull VRDecorator decorator, @NotNull class_4587 poseStack, float partialTicks, boolean renderMain, boolean renderOffhand, boolean isGui) {
        boolean isGuiHand;
        boolean isCursorHand;
        if (!ClientContext.visor.isFeatureEnabled(ClientFeature.VR_HANDS)) {
            return;
        }
        if (VRRenderState.getCurrentVRDisplay() == VRDisplay.THIRD_PERSON && VRClientSettings.getMirrorMode() != MirrorMode.MIXED_REALITY) {
            return;
        }
        VRCursorHandlerImpl cursorHandler = ClientContext.cursorHandler;
        RenderSystem.backupProjectionMatrix();
        ((GameRendererModified)VisorClientImpl.MC.field_1773).visor$resetProjectionMatrix(partialTicks);
        VRDisplay display = VRRenderState.getCurrentVRDisplay();
        Collection<VRHandEffect> effects = this.effectsRegistry.getElementsMap().values();
        if (renderMain && this.isControllerTracking(ControllerHand.MAIN)) {
            isCursorHand = cursorHandler.isHandFocused(ControllerHand.MAIN) && (cursorHandler.getCursorHand() == ControllerHand.MAIN || cursorHandler.isTwoHandedCursor());
            isGuiHand = isGui || isCursorHand || ClientContext.visor.isFeatureDisabled(ClientFeature.VR_WORLD_HANDS) || ClientContext.visor.isFeatureDisabled(ClientFeature.VR_WORLD_HAND_MAIN);
            this.renderHand(ControllerHand.MAIN, poseStack, partialTicks, isGuiHand, display, effects, decorator);
        }
        if (renderOffhand && this.isControllerTracking(ControllerHand.OFFHAND)) {
            isCursorHand = cursorHandler.isHandFocused(ControllerHand.OFFHAND) && (cursorHandler.getCursorHand() == ControllerHand.OFFHAND || cursorHandler.isTwoHandedCursor());
            isGuiHand = isGui || isCursorHand || ClientContext.visor.isFeatureDisabled(ClientFeature.VR_WORLD_HANDS) || ClientContext.visor.isFeatureDisabled(ClientFeature.VR_WORLD_HAND_OFFHAND);
            this.renderHand(ControllerHand.OFFHAND, poseStack, partialTicks, isGuiHand, display, effects, decorator);
        }
        RenderSystem.restoreProjectionMatrix();
    }

    private void renderHand(ControllerHand hand, @NotNull class_4587 poseStack, float partialTicks, boolean isGui, VRDisplay display, Collection<VRHandEffect> effects, VRDecorator decorator) {
        poseStack.method_22903();
        poseStack.method_34426();
        RenderPoseHelper.applyDisplayOrientation(display, poseStack);
        RenderPoseHelper.applyControllerPose(hand, poseStack);
        Map<VRHandEffect.RenderStage, Collection<VRHandEffect>> stageEffects = this.groupEffectsByStage(effects, decorator, hand, isGui);
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        this.renderHandEffects(stageEffects.get((Object)VRHandEffect.RenderStage.BEFORE_HANDS), hand, display, poseStack, isGui, partialTicks);
        if (isGui) {
            this.renderGuiHand(poseStack);
        } else {
            this.renderWorldHand(poseStack, hand, partialTicks);
        }
        this.renderHandEffects(stageEffects.get((Object)VRHandEffect.RenderStage.AFTER_HANDS), hand, display, poseStack, isGui, partialTicks);
        poseStack.method_22909();
    }

    private void renderGuiHand(class_4587 poseStack) {
        AtumColorImmutable color;
        VisorClientImpl.MC.method_1531().method_22813(TexturesHelper.getWhiteTexture());
        RenderSystem.setShaderTexture((int)0, (class_2960)TexturesHelper.getWhiteTexture());
        RenderSystem.depthFunc((int)519);
        Vector3fc dir = VRMathUtils.BACK_VECTOR;
        Vector3f start = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f end = new Vector3f(start.x - dir.x() * 0.18f, start.y - dir.y() * 0.18f, start.z - dir.z() * 0.18f);
        if (VisorClientImpl.MC.field_1687 != null) {
            float light = VisorClientImpl.MC.field_1687.method_22339(class_2338.method_49638((class_2374)new class_243((Vector3f)ClientContext.player.getPoseData(PoseDataType.RENDER).getHmd().getPosition())));
            light = Math.max(light, (float)ShadersHelper.shaderLight());
            float lightPercent = light / (float)VisorClientImpl.MC.field_1687.method_8315();
            color = new AtumColorImmutable(class_3532.method_15375((float)((float)GUI_HANDS_COLOR.getRedInt() * lightPercent)), class_3532.method_15375((float)((float)GUI_HANDS_COLOR.getGreenInt() * lightPercent)), class_3532.method_15375((float)((float)GUI_HANDS_COLOR.getBlueInt() * lightPercent)), 255);
        } else {
            color = GUI_HANDS_COLOR;
        }
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        RenderHelper.renderCuboid(tesselator.method_1349(), poseStack.method_23760().method_23761(), (Vector3fc)start, (Vector3fc)end, -0.02f, 0.02f, -0.0125f, 0.0125f, color);
        RenderSystem.depthFunc((int)515);
    }

    private void renderWorldHand(class_4587 poseStack, ControllerHand hand, float partialTicks) {
        if (VisorClientImpl.MC.field_1724 == null) {
            return;
        }
        class_1268 interactionHand = hand.asInteractionHand();
        class_1799 item = VisorClientImpl.MC.field_1724.method_5998(interactionHand);
        if (VisorClientImpl.MC.field_1755 != null) {
            item = class_1799.field_8037;
        }
        poseStack.method_22903();
        VisorClientImpl.MC.field_1773.method_22974().method_3316();
        class_4597.class_4598 bufferSource = VisorClientImpl.MC.method_22940().method_23000();
        VisorClientImpl.MC.field_1773.field_4012.method_3228((class_742)VisorClientImpl.MC.field_1724, partialTicks, 0.0f, interactionHand, VisorClientImpl.MC.field_1724.method_6055(partialTicks), item, 0.0f, poseStack, (class_4597)bufferSource, VisorClientImpl.MC.method_1561().method_23839((class_1297)VisorClientImpl.MC.field_1724, partialTicks));
        bufferSource.method_22993();
        VisorClientImpl.MC.field_1773.method_22974().method_3315();
        poseStack.method_22909();
    }

    private void renderHandEffects(Collection<VRHandEffect> effects, ControllerHand hand, VRDisplay display, class_4587 poseStack, boolean isSimple, float partialTicks) {
        if (effects == null || effects.isEmpty()) {
            return;
        }
        effects.forEach(it -> it.render(hand, display, poseStack, isSimple, partialTicks));
    }

    private Map<VRHandEffect.RenderStage, Collection<VRHandEffect>> groupEffectsByStage(Collection<VRHandEffect> effects, VRDecorator decorator, ControllerHand hand, boolean isSimple) {
        EnumMap<VRHandEffect.RenderStage, Collection<VRHandEffect>> map = new EnumMap<VRHandEffect.RenderStage, Collection<VRHandEffect>>(VRHandEffect.RenderStage.class);
        for (VRHandEffect effect : effects) {
            if (!effect.isGlobal() && !decorator.handEffects().contains(effect.getId()) || !effect.isEnabledAndVisible(decorator, hand, isSimple)) continue;
            map.computeIfAbsent(effect.renderAtStage(), k -> new ArrayList()).add(effect);
        }
        return map;
    }

    private boolean isControllerTracking(ControllerHand hand) {
        return ClientContext.rawPoseHandler.getControllerData(hand).isTracking();
    }

    public VRHandItemPoseRegistry getItemPosesRegistry() {
        return this.itemPosesRegistry;
    }

    public VRHandEffectRegistry getEffectsRegistry() {
        return this.effectsRegistry;
    }
}

