/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration.hand;

import me.phoenixra.visor.api.client.render.decoration.annotations.RegisterVRItemPose;
import me.phoenixra.visor.api.client.render.decoration.hand.VRHandItemPose;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visor.compatibility.ItemClassifier;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1743;
import net.minecraft.class_1744;
import net.minecraft.class_1747;
import net.minecraft.class_1753;
import net.minecraft.class_1758;
import net.minecraft.class_1759;
import net.minecraft.class_1763;
import net.minecraft.class_1764;
import net.minecraft.class_1766;
import net.minecraft.class_1786;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1810;
import net.minecraft.class_1820;
import net.minecraft.class_1821;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2527;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_8162;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@RegisterVRItemPose
public class VRItemPoseDefault
extends VRHandItemPose {
    private static final String ID = "default";

    public VRItemPoseDefault(@NotNull VisorAddon owner) {
        super(owner);
    }

    @Override
    public void applyPose(@NotNull class_4587 stack, @NotNull class_742 player, @NotNull ControllerHand hand, @NotNull class_1799 item, float equipProgress, float partialTicks) {
        class_1268 mcHand = hand == ControllerHand.MAIN ? class_1268.field_5808 : class_1268.field_5810;
        int handDir = hand == ControllerHand.MAIN ? 1 : -1;
        PoseParams params = this.computeParams(item, player, mcHand, handDir, equipProgress, partialTicks);
        stack.method_22907(params.preRotation);
        stack.method_46416(params.offsetX, params.offsetY, params.offsetZ);
        stack.method_22907(params.rotation);
        stack.method_22905(params.scale, params.scale, params.scale);
    }

    private PoseParams computeParams(class_1799 item, class_742 player, class_1268 mcHand, int handDir, float equipProgress, float partialTicks) {
        float gunAngle = ClientContext.rawPoseHandler.getGunAngle();
        ControllerHand controllerHand = ControllerHand.fromMcHand(mcHand);
        float scale = 0.7f;
        float translateX = -0.05f;
        float translateY = 0.005f;
        float translateZ = 0.0f;
        Quaternionf preRotation = class_7833.field_40716.rotationDegrees(0.0f);
        Quaternionf rotation = class_7833.field_40714.rotationDegrees(-110.0f + gunAngle);
        TransformType transformType = VRItemPoseDefault.getTransformType(item, player, VisorClientImpl.MC.method_1480());
        switch (transformType.ordinal()) {
            case 0: 
            case 3: {
                if (item.method_7909() instanceof class_1744) {
                    preRotation = class_7833.field_40718.rotationDegrees(-180.0f);
                    rotation = class_7833.field_40714.rotationDegrees(-gunAngle);
                    break;
                }
                rotation = class_7833.field_40718.rotationDegrees(180.0f);
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-135.0f));
                scale = 0.4f;
                translateX += 0.08f;
                translateZ -= 0.08f;
                break;
            }
            case 1: {
                scale = 0.3f;
                translateX += 0.05f;
                translateZ -= 0.1f;
                break;
            }
            case 2: {
                translateY += -0.105f + 0.06f * gunAngle / 40.0f;
                translateZ -= 0.1f;
                rotation = class_7833.field_40714.rotationDegrees(-45.0f);
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(gunAngle));
                break;
            }
            case 12: {
                long ticks = player.method_6014();
                rotation = class_7833.field_40718.rotationDegrees(180.0f);
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-135.0f));
                translateZ += 0.006f * class_3532.method_15374((float)ticks) + 0.02f;
                translateX += 0.08f;
                scale = 0.4f;
                break;
            }
            case 11: {
                preRotation = class_7833.field_40716.rotationDegrees(0.0f);
                rotation = class_7833.field_40714.rotationDegrees(-45.0f);
                translateX = 0.0f;
                translateY = 0.16f;
                translateZ = -0.075f;
                scale = 0.75f;
                break;
            }
            case 15: {
                rotation = class_7833.field_40716.rotationDegrees(90.0f);
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(25.0f));
                scale = 0.4f;
                break;
            }
            case 16: {
                rotation = class_7833.field_40714.rotationDegrees(-45.0f + gunAngle);
                translateY += -0.105f + 0.06f * gunAngle / 40.0f;
                translateZ -= 0.1f;
                scale = 0.3f;
                break;
            }
            case 7: {
                translateX += 0.05f;
                translateY += -0.02f + gunAngle / 40.0f * 0.1f;
                translateZ -= 0.15f;
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(40.0f));
                scale = 0.8f;
                break;
            }
            case 13: {
                rotation = class_7833.field_40716.rotationDegrees(10.0f);
                translateX += 0.01f;
                translateZ -= 0.02f;
                translateY -= 0.02f;
                scale = 0.5f;
                break;
            }
            case 8: {
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f - gunAngle));
                translateY += -0.1f;
                translateZ += 0.1f;
                break;
            }
            case 4: {
                if (VRClientSettings.isLeftHanded()) {
                    handDir *= -1;
                }
                scale = 0.4f;
                translateY += 0.18f;
                translateZ += 0.1f;
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees((float)(handDir == 1 ? 105 : 115) - gunAngle));
                translateX += handDir == 1 ? 0.11f : -0.015f;
                if (player.method_6115() && player.method_6058() == mcHand) {
                    rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees((float)(handDir * 5)));
                    rotation.mul((Quaternionfc)class_7833.field_40718.rotationDegrees(-5.0f));
                    translateY -= 0.12f;
                    translateZ -= handDir == 1 ? 0.1f : 0.11f;
                    translateX += handDir == 1 ? 0.04f : 0.19f;
                    rotation.mul((Quaternionfc)class_7833.field_40716.rotationDegrees((float)handDir * (player.method_6039() ? 90.0f : (1.0f - equipProgress) * 90.0f)));
                }
                rotation.mul((Quaternionfc)class_7833.field_40716.rotationDegrees((float)handDir * -90.0f));
                break;
            }
            case 10: {
                rotation.identity();
                translateX -= 0.135f;
                translateZ += 0.575f;
                scale = 0.6f;
                float progress = 0.0f;
                boolean charging = false;
                int riptideLevel = 0;
                if (player.method_6115() && player.method_6014() > 0 && player.method_6058() == mcHand) {
                    charging = true;
                    riptideLevel = class_1890.method_8202((class_1799)item);
                    if ((riptideLevel <= 0 || player.method_5721()) && (progress = (float)item.method_7935() - ((float)player.method_6014() - partialTicks + 1.0f)) > 10.0f) {
                        float rotationProgress = progress - 10.0f;
                        progress = 10.0f;
                        if (riptideLevel > 0 && player.method_5721()) {
                            preRotation = class_7833.field_40718.rotationDegrees(-rotationProgress * 10.0f * (float)riptideLevel);
                        }
                        if (VisorState.TICK_COUNT % 2 == 0) {
                            ClientContext.inputManager.triggerHapticPulseMicroSec(controllerHand, 200);
                        }
                        translateX += 0.003f * (float)Math.sin(class_156.method_658());
                    }
                }
                if (player.method_6123()) {
                    riptideLevel = 5;
                    translateZ -= 0.15f;
                    preRotation = class_7833.field_40718.rotationDegrees((float)(-VisorState.TICK_COUNT * 10 * riptideLevel % 360) - partialTicks * 10.0f * (float)riptideLevel);
                    charging = true;
                }
                if (!charging) {
                    translateY += 0.2f * gunAngle / 40.0f;
                    rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(gunAngle));
                }
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-65.0f));
                translateZ += -0.75f + progress / 10.0f * 0.25f;
            }
        }
        return new PoseParams(preRotation, rotation, translateX, translateY, translateZ, scale);
    }

    public static TransformType getTransformType(class_1799 itemStack, class_742 player, class_918 itemRenderer) {
        TransformType transformType = TransformType.DEFAULT;
        class_1792 item = itemStack.method_7909();
        if (itemStack.method_7976() == class_1839.field_8950 || itemStack.method_7976() == class_1839.field_8946) {
            return TransformType.CONSUMABLE;
        }
        if (item instanceof class_1747) {
            class_1087 model;
            class_2248 block = ((class_1747)item).method_7711();
            transformType = block instanceof class_2527 ? TransformType.BLOCK_STICK : ((model = itemRenderer.method_4019(itemStack, (class_1937)VisorClientImpl.MC.field_1687, (class_1309)VisorClientImpl.MC.field_1724, 0)).method_4712() ? TransformType.BLOCK_3D : TransformType.BLOCK_ITEM);
        } else if (item instanceof class_1806) {
            transformType = TransformType.MAP;
        } else if (item instanceof class_1753) {
            transformType = TransformType.BOW;
        } else if (itemStack.method_7976() == class_1839.field_39058) {
            transformType = TransformType.HORN;
        } else if (ItemClassifier.SWORD.is(item)) {
            transformType = TransformType.SWORD;
        } else if (ItemClassifier.SHIELD.is(item)) {
            transformType = TransformType.SHIELD;
        } else if (ItemClassifier.SPEAR.is(item)) {
            transformType = TransformType.SPEAR;
        } else if (item instanceof class_1764) {
            transformType = TransformType.CROSSBOW;
        } else if (item instanceof class_1759 || item == class_1802.field_8557) {
            transformType = TransformType.COMPASS;
        } else if (VRItemPoseDefault.isTool(item)) {
            transformType = TransformType.TOOL;
            if (item instanceof class_1758 || item instanceof class_1787) {
                transformType = TransformType.FISHING_ROD;
            }
        }
        return transformType;
    }

    public static boolean isTool(class_1792 item) {
        return item instanceof class_1766 || item instanceof class_1744 || item instanceof class_1787 || item instanceof class_1758 || item instanceof class_1820 || item == class_1802.field_8606 || item == class_1802.field_8894 || item == class_1802.field_8648 || item == class_1802.field_8810 || item == class_1802.field_8530 || item == class_1802.field_8600 || item instanceof class_1763 || item instanceof class_1786 || item instanceof class_8162 || item instanceof class_1794 || item instanceof class_1743 || item instanceof class_1810 || item instanceof class_1821;
    }

    @Override
    public boolean canApplyPose(@NotNull class_742 player, @NotNull ControllerHand hand, @NotNull class_1799 itemStack) {
        return true;
    }

    @Override
    @NotNull
    public ElementPriority getPriority() {
        return ElementPriority.LOWEST;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    private record PoseParams(Quaternionf preRotation, Quaternionf rotation, float offsetX, float offsetY, float offsetZ, float scale) {
    }

    public static enum TransformType {
        DEFAULT,
        BLOCK_3D,
        BLOCK_STICK,
        BLOCK_ITEM,
        SHIELD,
        SWORD,
        TOOL,
        FISHING_ROD,
        BOW,
        BOW_DRAWING,
        SPEAR,
        MAP,
        CONSUMABLE,
        CROSSBOW,
        TELESCOPE,
        COMPASS,
        HORN;

    }
}

