/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration.registry;

import com.mojang.text2speech.Narrator;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.client.render.decoration.VRDecorator;
import me.phoenixra.visor.api.client.render.decoration.annotations.RegisterVRDecorator;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.VisorRegistry;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecoratorRegistry
implements VisorRegistry<VRDecorator> {
    private static final String REGISTRY_NAME = "VR Decorators";
    private static final String ELEMENT_NAME = "VRDecorator";
    private static final String ANNOTATION_NAME = "@RegisterVRDecorator";
    private final Map<String, VRDecorator> elementsMap = new LinkedHashMap<String, VRDecorator>();
    private final List<VRDecorator> sortedElements = new ArrayList<VRDecorator>();
    private final Collection<VRDecorator> allElements = Collections.unmodifiableCollection(this.elementsMap.values());

    public List<VRDecorator> getSortedElements() {
        return Collections.unmodifiableList(this.sortedElements);
    }

    @Override
    public void registerAddonPath(@NotNull VisorAddon addon) {
        String path = addon.getAddonPackagePath();
        if (path == null) {
            return;
        }
        List<Class<?>> annotated = ModLoader.get().getClassesAnnotated(RegisterVRDecorator.class, addon.getModId(), path);
        Narrator.LOGGER.info("Found {} {} to register in addon: '{}'", new Object[]{annotated.size(), ELEMENT_NAME, addon.getAddonId()});
        for (Class<?> clazz : annotated) {
            if (!VRDecorator.class.isAssignableFrom(clazz)) {
                Narrator.LOGGER.warn("{} is annotated with {} but does not implement {}", new Object[]{clazz.getName(), ANNOTATION_NAME, ELEMENT_NAME});
                continue;
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(VisorAddon.class);
                VRDecorator element = (VRDecorator)constructor.newInstance(addon);
                this.registerElement(element);
            }
            catch (Exception e) {
                Narrator.LOGGER.error("Failed to register {} from class: {}", (Object)ELEMENT_NAME, (Object)clazz.getName());
                LoggerUtils.printError(e);
            }
        }
    }

    @Override
    public void registerElement(@NotNull VRDecorator element) {
        VRDecorator previous = this.elementsMap.put(element.getId(), element);
        if (previous != null) {
            Narrator.LOGGER.info("Overriding existing {}: '{}' from addon '{}'", new Object[]{ELEMENT_NAME, previous.getId(), previous.getOwner().getAddonId()});
            this.sortedElements.remove(previous);
        } else {
            Narrator.LOGGER.info("Registered {}: '{}'", (Object)ELEMENT_NAME, (Object)element.getId());
        }
        this.sortedElements.add(element);
        Collections.sort(this.sortedElements);
    }

    @Override
    @Nullable
    public VRDecorator unregisterElement(@NotNull String id) {
        VRDecorator removed = this.elementsMap.remove(id);
        if (removed != null) {
            this.sortedElements.remove(removed);
            Collections.sort(this.sortedElements);
            Narrator.LOGGER.info("Unregistered {}: '{}'", (Object)ELEMENT_NAME, (Object)removed.getId());
        }
        return removed;
    }

    @Override
    @Nullable
    public VRDecorator getElement(@NotNull String id) {
        return this.elementsMap.get(id);
    }

    @Override
    @NotNull
    public String getRegistryName() {
        return REGISTRY_NAME;
    }

    @Override
    public Collection<VRDecorator> getAllElements() {
        return this.allElements;
    }
}

