/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration.registry;

import com.mojang.text2speech.Narrator;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.client.render.decoration.annotations.RegisterVRHandEffect;
import me.phoenixra.visor.api.client.render.decoration.effects.VRHandEffect;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.VisorRegistry;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VRHandEffectRegistry
implements VisorRegistry<VRHandEffect> {
    private static final String REGISTRY_NAME = "VR Hand Effects";
    private static final String ELEMENT_NAME = "VRHandEffect";
    private static final String ANNOTATION_NAME = "@RegisterVRHandEffect";
    private final HashMap<String, VRHandEffect> elementsMap = new HashMap();
    private final HashMap<String, VRHandEffect> globalElementsMap = new HashMap();
    private final Collection<VRHandEffect> allElements = Collections.unmodifiableCollection(this.elementsMap.values());
    private final Collection<VRHandEffect> globalElements = Collections.unmodifiableCollection(this.globalElementsMap.values());

    @Override
    public void registerAddonPath(@NotNull VisorAddon addon) {
        String path = addon.getAddonPackagePath();
        if (path == null) {
            return;
        }
        List<Class<?>> annotated = ModLoader.get().getClassesAnnotated(RegisterVRHandEffect.class, addon.getModId(), path);
        Narrator.LOGGER.info("Found {} {} to register in addon: '{}'", new Object[]{annotated.size(), ELEMENT_NAME, addon.getAddonId()});
        for (Class<?> clazz : annotated) {
            if (!VRHandEffect.class.isAssignableFrom(clazz)) {
                Narrator.LOGGER.warn("{} is annotated with {} but does not implement {}", new Object[]{clazz.getName(), ANNOTATION_NAME, ELEMENT_NAME});
                continue;
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(VisorAddon.class);
                VRHandEffect element = (VRHandEffect)constructor.newInstance(addon);
                this.registerElement(element);
            }
            catch (Exception e) {
                Narrator.LOGGER.error("Failed to register {} from class: {}", (Object)ELEMENT_NAME, (Object)clazz.getName());
                LoggerUtils.printError(e);
            }
        }
    }

    @Override
    public void registerElement(@NotNull VRHandEffect element) {
        VRHandEffect previous = this.elementsMap.put(element.getId(), element);
        if (previous != null) {
            Narrator.LOGGER.info("Overriding existing {}: '{}' from addon '{}'", new Object[]{ELEMENT_NAME, previous.getId(), previous.getOwner().getAddonId()});
        } else {
            Narrator.LOGGER.info("Registered {}: '{}'", (Object)ELEMENT_NAME, (Object)element.getId());
        }
        if (element.isGlobal()) {
            this.globalElementsMap.put(element.getId(), element);
        }
    }

    @Override
    public VRHandEffect unregisterElement(@NotNull String id) {
        VRHandEffect removed = this.elementsMap.remove(id);
        this.globalElementsMap.remove(id);
        if (removed != null) {
            Narrator.LOGGER.info("Unregistered {}: '{}'", (Object)ELEMENT_NAME, (Object)removed.getId());
        }
        return removed;
    }

    @Override
    @Nullable
    public VRHandEffect getElement(@NotNull String id) {
        return this.elementsMap.get(id);
    }

    @Override
    @NotNull
    public String getRegistryName() {
        return REGISTRY_NAME;
    }

    public HashMap<String, VRHandEffect> getElementsMap() {
        return this.elementsMap;
    }

    public HashMap<String, VRHandEffect> getGlobalElementsMap() {
        return this.globalElementsMap;
    }

    @Override
    public Collection<VRHandEffect> getAllElements() {
        return this.allElements;
    }

    public Collection<VRHandEffect> getGlobalElements() {
        return this.globalElements;
    }
}

