/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.helpers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.render.VRShaders;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.utils.ClientUtils;
import me.phoenixra.visor.modified.client.WindowModified;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_8251;
import org.joml.Matrix4f;

public class MirrorHelper {
    private MirrorHelper() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static void drawMirror() {
        switch (VRClientSettings.getMirrorMode()) {
            case OFF: {
                MirrorHelper.drawTextMirror("Mirror is OFF", true);
                break;
            }
            case GUI: {
                MirrorHelper.drawGuiMirror();
                break;
            }
            case CROPPED: {
                MirrorHelper.drawCroppedMirror();
                break;
            }
            case SINGLE: {
                MirrorHelper.drawSingleMirror();
                break;
            }
            case DUAL: {
                MirrorHelper.drawDualMirror();
                break;
            }
            case FIRST_PERSON: {
                MirrorHelper.drawFirstPersonMirror();
                break;
            }
            case THIRD_PERSON: {
                MirrorHelper.drawThirdPersonMirror();
                break;
            }
            case MIXED_REALITY: {
                VRShaders.getMixedReality().drawMirror();
            }
        }
    }

    private static void drawGuiMirror() {
        class_276 source = ClientContext.renderer.guiTarget.getTarget();
        int screenWidth = ((WindowModified)VisorClientImpl.MC.method_22683()).visor$getActualScreenWidth();
        int screenHeight = ((WindowModified)VisorClientImpl.MC.method_22683()).visor$getActualScreenHeight();
        MirrorHelper.blit(source, 0, 0, screenWidth, screenHeight);
    }

    private static void drawCroppedMirror() {
        class_276 source = VRClientSettings.getMirrorEye() == EyeType.LEFT ? ClientContext.renderer.getTextureLeftEye().getRenderTarget() : ClientContext.renderer.getTextureRightEye().getRenderTarget();
        float xCrop = VRClientSettings.getMirrorCrop();
        float yCrop = VRClientSettings.getMirrorCrop();
        int screenWidth = ((WindowModified)VisorClientImpl.MC.method_22683()).visor$getActualScreenWidth();
        int screenHeight = ((WindowModified)VisorClientImpl.MC.method_22683()).visor$getActualScreenHeight();
        MirrorHelper.blitCropped(source, 0, 0, screenWidth, screenHeight, xCrop, yCrop, true);
    }

    private static void drawSingleMirror() {
        class_276 source = VRClientSettings.getMirrorEye() == EyeType.LEFT ? ClientContext.renderer.getTextureLeftEye().getRenderTarget() : ClientContext.renderer.getTextureRightEye().getRenderTarget();
        int screenWidth = ((WindowModified)VisorClientImpl.MC.method_22683()).visor$getActualScreenWidth();
        int screenHeight = ((WindowModified)VisorClientImpl.MC.method_22683()).visor$getActualScreenHeight();
        MirrorHelper.blit(source, 0, 0, screenWidth, screenHeight);
    }

    private static void drawFirstPersonMirror() {
        class_276 source = ClientContext.renderer.firstPersonTarget.getTarget();
        int screenWidth = ((WindowModified)VisorClientImpl.MC.method_22683()).visor$getActualScreenWidth();
        int screenHeight = ((WindowModified)VisorClientImpl.MC.method_22683()).visor$getActualScreenHeight();
        MirrorHelper.blit(source, 0, 0, screenWidth, screenHeight);
    }

    private static void drawThirdPersonMirror() {
        class_276 source = ClientContext.renderer.thirdPersonTarget.getTarget();
        int screenWidth = ((WindowModified)VisorClientImpl.MC.method_22683()).visor$getActualScreenWidth();
        int screenHeight = ((WindowModified)VisorClientImpl.MC.method_22683()).visor$getActualScreenHeight();
        MirrorHelper.blit(source, 0, 0, screenWidth, screenHeight);
    }

    private static void drawDualMirror() {
        class_276 leftEye = ClientContext.renderer.getTextureLeftEye().getRenderTarget();
        class_276 rightEye = ClientContext.renderer.getTextureRightEye().getRenderTarget();
        int screenWidth = ((WindowModified)VisorClientImpl.MC.method_22683()).visor$getActualScreenWidth() / 2;
        int screenHeight = ((WindowModified)VisorClientImpl.MC.method_22683()).visor$getActualScreenHeight();
        MirrorHelper.blit(leftEye, 0, 0, screenWidth, screenHeight);
        MirrorHelper.blit(rightEye, screenWidth, 0, VisorClientImpl.MC.field_1689.field_1482, screenHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drawTextMirror(String text, boolean clearBackground) {
        int CLEAR_DEPTH_FLAG = 256;
        int CLEAR_COLOR_FLAG = 16384;
        int TEXT_COLOR = 0xFFFFFF;
        int CHAR_WIDTH = 22;
        int LINE_HEIGHT = 5;
        boolean TEXT_X_OFFSET = true;
        float NEAR_PLANE = 1000.0f;
        float FAR_PLANE = 3000.0f;
        float CAMERA_Z = 2000.0f;
        float TEXT_SCALE = 2.0f;
        WindowModified window = (WindowModified)VisorClientImpl.MC.method_22683();
        int vrWidth = window.visor$getActualScreenWidth();
        int vrHeight = window.visor$getActualScreenHeight();
        RenderSystem.viewport((int)0, (int)0, (int)vrWidth, (int)vrHeight);
        Matrix4f proj = new Matrix4f().setOrtho(0.0f, (float)vrWidth, (float)vrHeight, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)proj, (class_8251)class_8251.field_43361);
        class_4587 mv = RenderSystem.getModelViewStack();
        mv.method_22903();
        try {
            mv.method_34426();
            mv.method_46416(0.0f, 0.0f, -2000.0f);
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
            int flags = 0x100 | (clearBackground ? 16384 : 0);
            RenderSystem.clear((int)flags, (boolean)class_310.field_1703);
            if (clearBackground) {
                RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            }
            class_332 gui = new class_332(VisorClientImpl.MC, VisorClientImpl.MC.method_22940().method_23000());
            gui.method_51448().method_22905(2.0f, 2.0f, 2.0f);
            int wrapWidth = vrWidth / 22;
            List<String> lines = text == null ? List.of() : ClientUtils.wrapText(text, wrapWidth);
            int y = 5;
            for (String line : lines) {
                gui.method_25303(VisorClientImpl.MC.field_1772, line, 1, y, 0xFFFFFF);
                y += 5;
            }
            gui.method_51452();
        }
        finally {
            mv.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void blit(class_276 source, int left, int top, int right, int bottom) {
        GlStateManager._glBindFramebuffer((int)36008, (int)source.field_1476);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)source.field_1482, (int)source.field_1481, (int)left, (int)top, (int)right, (int)bottom, (int)16384, (int)9729);
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
    }

    public static void blitCropped(class_276 source, int left, int top, int right, int bottom, float xCropFactor, float yCropFactor, boolean keepAspect) {
        if (keepAspect) {
            float targetAspect = (float)VisorClientImpl.MC.field_1689.field_1482 / (float)VisorClientImpl.MC.field_1689.field_1481;
            float sourceAspect = (float)source.field_1480 / (float)source.field_1477;
            if (targetAspect > sourceAspect) {
                yCropFactor = 0.5f - sourceAspect / targetAspect * (0.5f - yCropFactor);
            } else {
                xCropFactor = 0.5f - targetAspect / sourceAspect * (0.5f - xCropFactor);
            }
        }
        int xMin = (int)(xCropFactor * (float)source.field_1482);
        int yMin = (int)(yCropFactor * (float)source.field_1481);
        int xMax = source.field_1482 - xMin;
        int yMax = source.field_1481 - yMin;
        GlStateManager._glBindFramebuffer((int)36008, (int)source.field_1476);
        GlStateManager._glBlitFrameBuffer((int)xMin, (int)yMin, (int)xMax, (int)yMax, (int)left, (int)top, (int)right, (int)bottom, (int)16384, (int)9729);
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
    }
}

