/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Supplier;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.render.helpers.VREffectsHelper;
import me.phoenixra.visor.mixin.client.accessors.RenderSystemAccessor;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4608;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderHelper {
    private RenderHelper() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static boolean isInSolidBlock(Vector3fc in) {
        if (VisorClientImpl.MC.field_1687 == null) {
            return false;
        }
        class_2338 blockpos = class_2338.method_49638((class_2374)new class_243((Vector3f)in));
        return VisorClientImpl.MC.field_1687.method_8320(blockpos).method_26216((class_1922)VisorClientImpl.MC.field_1687, blockpos);
    }

    public static void renderCuboid(class_287 bufferBuilder, Matrix4f poseMatrix, Vector3fc start, Vector3fc end, float innerWidth, float outerWidth, float innerHeight, float outerHeight, AtumColor color) {
        Vector3f forward = end.sub(start, new Vector3f()).normalize();
        Vector3f right = forward.cross(VRMathUtils.UP_VECTOR, new Vector3f()).normalize();
        Vector3f up = right.cross((Vector3fc)forward, new Vector3f()).normalize();
        Vector3f r0 = right.mul(innerWidth, new Vector3f());
        Vector3f r1 = right.mul(outerWidth, new Vector3f());
        Vector3f u0 = up.mul(innerHeight, new Vector3f());
        Vector3f u1 = up.mul(outerHeight, new Vector3f());
        Vector3fc[][] corners = new Vector3fc[][]{{start, r0, u0}, {start, r1, u0}, {start, r1, u1}, {start, r0, u1}, {end, r0, u0}, {end, r1, u0}, {end, r1, u1}, {end, r0, u1}};
        int[][] faceIndices = new int[][]{{0, 3, 2, 1}, {4, 5, 6, 7}, {1, 2, 6, 5}, {0, 4, 7, 3}, {3, 7, 6, 2}, {0, 1, 5, 4}};
        Vector3f[] faceNormals = new Vector3f[]{forward, forward.mul(-1.0f, new Vector3f()).normalize(), right, right.mul(-1.0f, new Vector3f()).normalize(), up, up.mul(-1.0f, new Vector3f()).normalize()};
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_29337);
        for (int f = 0; f < faceIndices.length; ++f) {
            Vector3f normal = faceNormals[f];
            for (int idx : faceIndices[f]) {
                Vector3fc base = corners[idx][0];
                Vector3fc xOff = corners[idx][1];
                Vector3fc yOff = corners[idx][2];
                Vector3f pos = base.add(xOff, new Vector3f()).add(yOff);
                RenderHelper.addVertex(bufferBuilder, poseMatrix, (Vector3fc)pos, color, (Vector3fc)normal);
            }
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static void renderFlatQuad(class_287 bufferBuilder, Matrix4f poseMatrix, Vector3fc pos, float width, float height, float yaw, AtumColor color) {
        float halfW = width * 0.5f;
        float halfH = height * 0.5f;
        Vector3f off = new Vector3f(halfW, 0.0f, halfH).rotateY((float)Math.toRadians(-yaw));
        Vector3fc normal = VRMathUtils.UP_VECTOR;
        float xOff = off.x;
        float zOff = off.z;
        float r = color.getRed();
        float g = color.getGreen();
        float b = color.getBlue();
        float a = color.getAlpha();
        float[][] vertices = new float[][]{{pos.x() + xOff, pos.y(), pos.z() + zOff}, {pos.x() + xOff, pos.y(), pos.z() - zOff}, {pos.x() - xOff, pos.y(), pos.z() - zOff}, {pos.x() - xOff, pos.y(), pos.z() + zOff}};
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_29337);
        for (float[] vertex : vertices) {
            bufferBuilder.method_22918(poseMatrix, vertex[0], vertex[1], vertex[2]).method_22915(r, g, b, a).method_22914(normal.x(), normal.y(), normal.z()).method_1344();
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static void renderDisplayQuad(Matrix4f poseMatrix, AtumColor color, float displayWidth, float displayHeight, float size) {
        float aspect = displayHeight / displayWidth;
        float halfSize = size * 0.5f;
        float halfHeight = halfSize * aspect;
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        float r = color.getRed();
        float g = color.getGreen();
        float b = color.getBlue();
        float a = color.getAlpha();
        float[][] vertices = new float[][]{{-halfSize, -halfHeight, 0.0f, u0, v0}, {halfSize, -halfHeight, 0.0f, u1, v0}, {halfSize, halfHeight, 0.0f, u1, v1}, {-halfSize, halfHeight, 0.0f, u0, v1}};
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        class_287 buf = class_289.method_1348().method_1349();
        buf.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        for (float[] vertex : vertices) {
            buf.method_22918(poseMatrix, vertex[0], vertex[1], vertex[2]).method_22913(vertex[3], vertex[4]).method_1344();
        }
        class_286.method_43433((class_287.class_7433)buf.method_1326());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderDisplayQuadWithLight(Matrix4f poseMatrix, AtumColor color, float displayWidth, float displayHeight, float size, int light, boolean flipY) {
        RenderHelper.renderDisplayQuadWithLight(poseMatrix, color, class_757::method_34504, displayWidth, displayHeight, size, light, flipY);
    }

    public static void renderDisplayQuadWithLight(Matrix4f poseMatrix, AtumColor color, Supplier<class_5944> shader, float displayWidth, float displayHeight, float size, int light, boolean flipY) {
        float red = color.getRed();
        float green = color.getGreen();
        float blue = color.getBlue();
        float alpha = color.getAlpha();
        float aspect = displayHeight / displayWidth;
        float halfSize = size * 0.5f;
        float halfHeight = halfSize * aspect;
        float uMin = 0.0f;
        float uMax = 1.0f;
        float vMin = flipY ? 1.0f : 0.0f;
        float vMax = flipY ? 0.0f : 1.0f;
        float[][] pos = new float[][]{{-halfSize, -halfHeight}, {halfSize, -halfHeight}, {halfSize, halfHeight}, {-halfSize, halfHeight}};
        float[][] uv = new float[][]{{uMin, vMin}, {uMax, vMin}, {uMax, vMax}, {uMin, vMax}};
        RenderSystem.setShader(shader);
        VisorClientImpl.MC.field_1773.method_22974().method_3316();
        VisorClientImpl.MC.field_1773.method_22975().method_23209();
        Vector3f[] oldLights = RenderSystemAccessor.getShaderLightDirections();
        Vector3f old0 = oldLights[0];
        Vector3f old1 = oldLights[1];
        Vector3f forward = (Vector3f)VRMathUtils.FORWARD_VECTOR;
        RenderSystem.setShaderLights((Vector3f)forward, (Vector3f)forward);
        RenderSystem.setupShaderLights((class_5944)RenderSystem.getShader());
        class_287 buf = class_289.method_1348().method_1349();
        buf.method_1328(class_293.class_5596.field_27382, class_290.field_1580);
        for (int i = 0; i < 4; ++i) {
            float x = pos[i][0];
            float y = pos[i][1];
            float u = uv[i][0];
            float v = uv[i][1];
            buf.method_22918(poseMatrix, x, y, 0.0f).method_22915(red, green, blue, alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        }
        class_286.method_43433((class_287.class_7433)buf.method_1326());
        VisorClientImpl.MC.field_1773.method_22974().method_3315();
        if (old0 != null && old1 != null) {
            RenderSystem.setShaderLights((Vector3f)old0, (Vector3f)old1);
            RenderSystem.setupShaderLights((class_5944)RenderSystem.getShader());
        }
    }

    public static Optional<VREffectsHelper.NearestOpaqueBlock> findNearestSolidBlock(class_243 origin, double radius) {
        class_638 level = VisorClientImpl.MC.field_1687;
        if (level == null) {
            return Optional.empty();
        }
        class_238 box = new class_238(origin.method_1023(radius, radius, radius), origin.method_1031(radius, radius, radius));
        return class_2338.method_29715((class_238)box).filter(pos -> level.method_8320(pos).method_26216((class_1922)level, pos)).map(pos -> {
            float dist = (float)class_243.method_24953((class_2382)pos).method_1022(origin);
            return new VREffectsHelper.NearestOpaqueBlock(dist, level.method_8320(pos), (class_2338)pos);
        }).min(Comparator.comparingDouble(VREffectsHelper.NearestOpaqueBlock::distance));
    }

    private static void addVertex(class_287 buff, Matrix4f mat, Vector3fc pos, AtumColor color, Vector3fc normal) {
        buff.method_22918(mat, pos.x(), pos.y(), pos.z()).method_1336(color.getRedInt(), color.getGreenInt(), color.getBlueInt(), (int)((byte)color.getAlphaInt())).method_22914(normal.x(), normal.y(), normal.z()).method_1344();
    }
}

