/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.helpers;

import me.phoenixra.visor.api.client.data.PoseData;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import net.minecraft.class_4587;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderPoseHelper {
    private RenderPoseHelper() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static void applyDisplayPose(VRDisplay vrDisplay, class_4587 poseStack) {
        RenderPoseHelper.applyDisplayOrientation(vrDisplay, poseStack);
        RenderPoseHelper.applyDisplayTranslation(vrDisplay, poseStack);
    }

    public static void applyDisplayOrientation(VRDisplay vrDisplay, class_4587 poseStack) {
        float mirrorSmooth = VRClientSettings.getMirrorSmooth();
        PoseDataImpl renderPose = ClientContext.player.getPoseData(PoseDataType.RENDER);
        boolean smooth = vrDisplay == VRDisplay.FIRST_PERSON && mirrorSmooth > 0.0f;
        Matrix4f rotationMatrix = smooth ? new Matrix4f().rotation((Quaternionfc)ClientContext.rawPoseHandler.getHmdData().getRotationHistory().averageRotation(mirrorSmooth)) : renderPose.getElementForDisplay(vrDisplay).getRotation().transpose(new Matrix4f());
        poseStack.method_23760().method_23761().mul((Matrix4fc)rotationMatrix);
        poseStack.method_23760().method_23762().mul((Matrix3fc)new Matrix3f((Matrix4fc)rotationMatrix));
    }

    public static void applyDisplayTranslation(VRDisplay vrDisplay, class_4587 poseStack) {
        if (!vrDisplay.isEye()) {
            return;
        }
        PoseDataImpl renderPose = ClientContext.player.getPoseData(PoseDataType.RENDER);
        Vector3fc eyePos = renderPose.getElementForDisplay(vrDisplay).getPosition();
        Vector3fc hmdOrigin = renderPose.getHmd().getPosition();
        Vector3f offset = eyePos.sub(hmdOrigin, new Vector3f());
        poseStack.method_46416(-offset.x, -offset.y, -offset.z);
    }

    public static void applyControllerPose(ControllerHand hand, class_4587 poseStack) {
        PoseDataImpl renderPose = ClientContext.player.getPoseData(PoseDataType.RENDER);
        Vector3fc controllerPos = RenderPoseHelper.getControllerPosition(hand);
        Vector3fc cameraPos = RenderPoseHelper.getCameraPosition(VRRenderState.getCurrentVRDisplay(), renderPose);
        Vector3f relative = controllerPos.sub(cameraPos, new Vector3f());
        poseStack.method_46416(relative.x, relative.y, relative.z);
        Matrix4f invRot = renderPose.getController(hand).getRotation().invert(new Matrix4f()).transpose(new Matrix4f());
        poseStack.method_23760().method_23761().mul((Matrix4fc)invRot);
        float s = renderPose.getWorldScale();
        poseStack.method_22905(s, s, s);
    }

    public static Vector3fc getCameraPosition(VRDisplay vrDisplay, PoseData vrPose) {
        boolean smooth;
        float mirrorSmooth = VRClientSettings.getMirrorSmooth();
        boolean bl = smooth = vrDisplay == VRDisplay.FIRST_PERSON && mirrorSmooth > 0.0f;
        if (smooth) {
            Vector3f avg = ClientContext.rawPoseHandler.getHmdData().getPositionHistory().averagePosition(mirrorSmooth);
            return avg.mul(vrPose.getWorldScale()).rotateY(vrPose.getRotationY()).add(vrPose.getOrigin());
        }
        return vrPose.getElementForDisplay(vrDisplay).getPosition();
    }

    public static Vector3fc getControllerPosition(ControllerHand hand) {
        return ClientContext.player.getPoseData(PoseDataType.RENDER).getController(hand).getPosition();
    }
}

