/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.shaders;

import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.render.helpers.RenderShaderHelper;
import me.phoenixra.visor.core.client.render.shaders.VRShader;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_276;
import net.minecraft.class_278;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5912;
import net.minecraft.class_5944;

public class VRShaderPostProcessEye
implements VRShader {
    private static final AtumColor PUMPKIN_VIGNETTE_COLOR = AtumColor.ORANGE.blend(AtumColor.BLACK, 0.5f);
    private class_5944 handle;
    private class_278 uniformEye;
    private class_278 uVignetteRadius;
    private class_278 uVignetteOffset;
    private class_278 uVignetteBorder;
    private class_278 uVignetteColor;
    private class_278 uTintRed;
    private class_278 uTintBlue;
    private class_278 uTintBlack;

    @Override
    public void init() throws Exception {
        this.handle = new class_5944((class_5912)class_310.method_1551().method_1478(), "vr_post_process_eye", class_290.field_1585);
        this.uniformEye = this.handle.method_35785("uEye");
        this.uTintRed = this.handle.method_35785("uTintRed");
        this.uTintBlue = this.handle.method_35785("uTintBlue");
        this.uTintBlack = this.handle.method_35785("uTintBlack");
        this.uVignetteRadius = this.handle.method_35785("uVignetteRadius");
        this.uVignetteOffset = this.handle.method_35785("uVignetteOffset");
        this.uVignetteBorder = this.handle.method_35785("uVignetteBorder");
        this.uVignetteColor = this.handle.method_35785("uVignetteColor");
    }

    public void finishEye(EyeType eye, class_276 source, float partialTicks) {
        if (eye == EyeType.LEFT) {
            this.updateUniforms(partialTicks);
        }
        this.uniformEye.method_35649(eye == EyeType.LEFT ? 1 : -1);
        RenderShaderHelper.renderFullscreenQuad(this.handle, source);
        GLUtils.checkGLError("post process eye: " + eye.name());
    }

    private void updateUniforms(float partialTicks) {
        boolean canApplyEffects = VisorClientImpl.MC.field_1687 != null && VisorClientImpl.MC.field_1724 != null && !VisorClientImpl.MC.field_1724.method_7325();
        float time = (float)class_156.method_658() / 1000.0f;
        float redTint = 0.0f;
        float blueTint = 0.0f;
        float blackTint = 0.0f;
        float vignetteRadius = 1.0f;
        float vignetteBorder = 0.06f;
        AtumColor vignetteColor = AtumColor.BLACK;
        if (canApplyEffects) {
            if (VisorClientImpl.MC.field_1724.method_7337()) {
                redTint = 0.0f;
            } else {
                float hurtTimer = (float)VisorClientImpl.MC.field_1724.field_6235 - partialTicks;
                float healthPercent = 1.0f - VisorClientImpl.MC.field_1724.method_6032() / VisorClientImpl.MC.field_1724.method_6063();
                healthPercent = (healthPercent - 0.5f) * 0.75f;
                if (VRClientSettings.isHitIndicatorEnabled() && hurtTimer > 0.0f) {
                    hurtTimer /= (float)VisorClientImpl.MC.field_1724.field_6254;
                    redTint = hurtTimer = healthPercent + class_3532.method_15374((float)(hurtTimer * hurtTimer * hurtTimer * hurtTimer * (float)Math.PI)) * 0.5f;
                } else if (VRClientSettings.isLowHealthIndicatorEnabled()) {
                    redTint = healthPercent * class_3532.method_15379((float)class_3532.method_15374((float)(2.5f * time / (1.0f - healthPercent + 0.1f))));
                }
            }
            if (VRClientSettings.isFreezeEffectEnabled()) {
                boolean hasFreezeEffect;
                float freeze = VisorClientImpl.MC.field_1724.method_32313();
                boolean bl = hasFreezeEffect = freeze > 0.0f;
                if (hasFreezeEffect) {
                    blueTint = redTint;
                    blueTint = Math.max(freeze / 2.0f, blueTint);
                    redTint = 0.0f;
                }
            }
            if (VisorClientImpl.MC.field_1724.method_6113()) {
                blackTint = 0.5f + 0.3f * (float)VisorClientImpl.MC.field_1724.method_7297() * 0.01f;
            }
            class_1799 headItem = VisorClientImpl.MC.field_1724.method_31548().method_7372(3);
            if (VRClientSettings.isPumpkinEffectEnabled()) {
                boolean hasPumpkin;
                boolean bl = hasPumpkin = headItem.method_7909() == class_2246.field_10147.method_8389() && (!headItem.method_7985() || headItem.method_7969().method_10550("CustomModelData") == 0);
                if (hasPumpkin) {
                    vignetteColor = PUMPKIN_VIGNETTE_COLOR;
                    vignetteRadius = 0.3f;
                    vignetteBorder = 0.0f;
                }
            }
        }
        this.uTintRed.method_1251(redTint);
        this.uTintBlue.method_1251(blueTint);
        this.uTintBlack.method_1251(blackTint);
        this.uVignetteRadius.method_1251(vignetteRadius);
        this.uVignetteBorder.method_1251(vignetteBorder);
        this.uVignetteOffset.method_1251(0.1f);
        this.uVignetteColor.method_1254(vignetteColor.getRed(), vignetteColor.getGreen(), vignetteColor.getBlue(), vignetteColor.getAlpha());
    }

    @Override
    public class_5944 getHandle() {
        return this.handle;
    }
}

