/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.target.types;

import java.util.HashMap;
import java.util.Map;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.render.target.RenderTargetHolder;
import me.phoenixra.visor.core.client.render.target.VRRenderTarget;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class RenderTargetGUI
implements RenderTargetHolder {
    private class_276 target = null;
    private final HashMap<VROverlayScreen, VRRenderTarget> overlayTargets = new HashMap();
    private int savedWidth;
    private int savedHeight;
    private boolean init;

    @Override
    public void init(int width, int height) throws Exception {
        this.target = new VRRenderTarget("GUI", width, height, true, () -> -1, true, false);
        GLUtils.checkGLError("GUI target setup");
        VisorClientImpl.LOGGER.info(this.target.toString());
        this.overlayTargets.clear();
        for (VROverlay overlay : ClientContext.overlayManager.getOverlaysRegistry().getSortedElements()) {
            if (!(overlay instanceof VROverlayScreen)) continue;
            VROverlayScreen overlayScreen = (VROverlayScreen)overlay;
            if (!overlay.isVisible() || !overlay.isEnabled()) {
                this.overlayTargets.put(overlayScreen, null);
                overlayScreen.setRenderTarget(null);
                continue;
            }
            VRRenderTarget renderTarget = new VRRenderTarget("Overlay " + overlayScreen.getId(), overlayScreen.getRequestedWidth(), overlayScreen.getRequestedHeight(), true, () -> -1, true, false);
            GLUtils.checkGLError("Overlay " + overlayScreen.getId() + " framebuffer setup");
            this.overlayTargets.put(overlayScreen, renderTarget);
            overlayScreen.setRenderTarget(renderTarget);
        }
        this.savedWidth = width;
        this.savedHeight = height;
        this.init = true;
    }

    @Override
    public void resize(int width, int height) throws Exception {
        this.target.method_1234(width, height, class_310.field_1703);
        for (Map.Entry<VROverlayScreen, VRRenderTarget> entry : this.overlayTargets.entrySet()) {
            if (this.target == null) continue;
            VROverlayScreen overlay = entry.getKey();
            entry.getValue().method_1234(overlay.getRequestedWidth(), overlay.getRequestedHeight(), class_310.field_1703);
            overlay.updateSize();
        }
        if (VisorClientImpl.MC.field_1755 != null) {
            int screenWidth = VisorClientImpl.MC.method_22683().method_4486();
            int screenHeight = VisorClientImpl.MC.method_22683().method_4502();
            VisorClientImpl.MC.field_1755.method_25423(VisorClientImpl.MC, screenWidth, screenHeight);
        }
        this.savedWidth = width;
        this.savedHeight = height;
    }

    @Override
    public void destroy() {
        if (this.target != null) {
            this.target.method_1238();
            this.target = null;
        }
        for (VRRenderTarget target : this.overlayTargets.values()) {
            if (target == null) continue;
            target.method_1238();
        }
        this.overlayTargets.clear();
        this.init = false;
    }

    public void updateOverlayTarget(@NotNull VROverlayScreen overlayScreen) {
        VRRenderTarget renderTarget = this.overlayTargets.get(overlayScreen);
        boolean visible = overlayScreen.isVisible();
        if (renderTarget == null && visible) {
            renderTarget = new VRRenderTarget("Overlay " + overlayScreen.getId(), overlayScreen.getRequestedWidth(), overlayScreen.getRequestedHeight(), true, () -> -1, true, false);
            GLUtils.checkGLError("Overlay " + overlayScreen.getId() + " framebuffer setup");
            this.overlayTargets.put(overlayScreen, renderTarget);
        } else if (renderTarget != null && !visible) {
            renderTarget.method_1238();
            this.overlayTargets.put(overlayScreen, null);
        } else if (renderTarget != null) {
            int neededWidth = overlayScreen.getRequestedWidth();
            int neededHeight = overlayScreen.getRequestedHeight();
            if (neededWidth != renderTarget.field_1482 || neededHeight != renderTarget.field_1481) {
                renderTarget.method_1238();
                renderTarget.method_1234(neededWidth, neededHeight, class_310.field_1703);
                overlayScreen.updateSize();
            }
        }
        overlayScreen.setRenderTarget(this.overlayTargets.get(overlayScreen));
    }

    public class_276 getTarget() {
        return this.target;
    }

    public HashMap<VROverlayScreen, VRRenderTarget> getOverlayTargets() {
        return this.overlayTargets;
    }

    public int getSavedWidth() {
        return this.savedWidth;
    }

    public int getSavedHeight() {
        return this.savedHeight;
    }

    public boolean isInit() {
        return this.init;
    }
}

