/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.settings;

import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.visor.api.client.VRPlayMode;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.settings.VROptionCategory;
import me.phoenixra.visor.core.client.settings.VROptionWidgetType;
import me.phoenixra.visor.core.client.settings.options.VROptionField;
import me.phoenixra.visor.core.client.settings.options.enums.MirrorMode;
import me.phoenixra.visor.core.client.settings.options.enums.RotationMode;
import me.phoenixra.visor.core.client.settings.options.enums.ShaderGUIRenderMode;
import me.phoenixra.visor.core.client.utils.LangHelper;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class VRClientSettings {
    @VROptionField
    protected static VRPlayMode vrPlayMode = VRPlayMode.ENABLED;
    @VROptionField(widgetType=VROptionWidgetType.LEFT_HANDED, key="left_handed")
    protected static boolean leftHanded = false;
    @VROptionField(key="keyboard.keys")
    protected static String keyboardKeys = "`1234567890-=qwertyuiop[]\\asdfghjkl;':\"zxcvbnm,./?<>";
    @VROptionField(key="keyboard.keysShift")
    protected static String keyboardKeysShift = "~!@#$%^&*()_+QWERTYUIOP{}|ASDFGHJKL;':\"ZXCVBNM,./?<>";
    @VROptionField(key="world_scale", category=VROptionCategory.RENDERING)
    protected static float worldScale = 1.0f;
    @VROptionField(widgetType=VROptionWidgetType.WORLD_ROTATION_INCREMENT, key="world_rotation_increment")
    protected static float worldRotationIncrement = 45.0f;
    @VROptionField(key="player.walkMultiplier")
    protected static float walkMultiplier = 1.0f;
    @VROptionField(widgetType=VROptionWidgetType.MIRROR_MODE, key="mirror_mode")
    protected static MirrorMode mirrorMode = MirrorMode.CROPPED;
    @VROptionField(widgetType=VROptionWidgetType.MIRROR_EYE, key="mirror_eye")
    protected static EyeType mirrorEye = EyeType.LEFT;
    protected static float eyesFovScale = 1.0f;
    private static float eyeFovScaleCurrent = 1.0f;
    private static boolean eyeFovChanged = false;
    protected static final float renderScaleFactor = 1.0f;
    protected static final float mirrorSmooth = 0.0f;
    protected static final float mirrorCrop = 0.15f;
    @VROptionField(widgetType=VROptionWidgetType.LOW_HEALTH_INDICATOR, key="low_health_indicator")
    protected static boolean lowHealthIndicatorEnabled = true;
    @VROptionField(widgetType=VROptionWidgetType.HIT_INDICATOR, key="hit_indicator")
    protected static boolean hitIndicatorEnabled = true;
    @VROptionField(widgetType=VROptionWidgetType.FREEZE_EFFECT, key="freeze")
    protected static boolean freezeEffectEnabled = true;
    @VROptionField(widgetType=VROptionWidgetType.PUMPKIN_EFFECT, key="pumpkin")
    protected static boolean pumpkinEffectEnabled = true;
    @VROptionField(key="main_menu.panorama.front")
    protected static String panoramaFront = "visor:textures/mainmenu/panorama_front.png";
    @VROptionField(key="main_menu.panorama.back")
    protected static String panoramaBack = "visor:textures/mainmenu/panorama_back.png";
    @VROptionField(key="main_menu.panorama.right")
    protected static String panoramaRight = "visor:textures/mainmenu/panorama_right.png";
    @VROptionField(key="main_menu.panorama.left")
    protected static String panoramaLeft = "visor:textures/mainmenu/panorama_left.png";
    @VROptionField(key="main_menu.panorama.up")
    protected static String panoramaUp = "visor:textures/mainmenu/panorama_up.png";
    @VROptionField(key="main_menu.panorama.below")
    protected static String panoramaBelow = "visor:textures/mainmenu/panorama_below.png";
    @VROptionField(key="main_menu.floor")
    protected static String mainMenuFloor = "minecraft:textures/block/moss_block.png";
    @VROptionField(widgetType=VROptionWidgetType.SHADER_GUI_RENDER, key="shader_gui_render")
    protected static ShaderGUIRenderMode shaderGUIRender = ShaderGUIRenderMode.AFTER_SHADER;
    @VROptionField(key="gui.scale")
    protected static float guiScale = 0.0f;
    @VROptionField(widgetType=VROptionWidgetType.HUD_DISABLED_HOTBAR, key="hud_disabled_hotbar")
    protected static boolean hudDisableHotBar = true;
    @VROptionField(widgetType=VROptionWidgetType.THIRD_PERSON_FOV, key="fov")
    protected static float thirdPersonFov = 40.0f;
    @VROptionField(key="camera.pos.x", category=VROptionCategory.RENDERING_THIRD_PERSON)
    protected static float thirdPersonCameraPosX = -1.0f;
    @VROptionField(key="camera.pos.y", category=VROptionCategory.RENDERING_THIRD_PERSON)
    protected static float thirdPersonCameraPosY = 2.4f;
    @VROptionField(key="camera.pos.z", category=VROptionCategory.RENDERING_THIRD_PERSON)
    protected static float thirdPersonCameraPosZ = 2.75f;
    @VROptionField(key="camera.rotation", category=VROptionCategory.RENDERING_THIRD_PERSON)
    protected static Quaternionfc thirdPersonCameraRotation = new Quaternionf(0.2246, 0.1873, 0.044, -0.9552);
    @VROptionField(widgetType=VROptionWidgetType.MIXED_REALITY_RENDER_HANDS, key="render_hands")
    protected static boolean mixedRealityRenderHands = false;
    @VROptionField(widgetType=VROptionWidgetType.MIXED_REALITY_AS_GRID_2_X_2, key="as_grid_2_x_2")
    protected static boolean mixedRealityAsGrid2x2 = true;
    @VROptionField(widgetType=VROptionWidgetType.MIXED_REALITY_WITH_FIRST_PERSON, key="with_first_person")
    protected static boolean mixedRealityWithFirstPerson = true;
    @VROptionField(widgetType=VROptionWidgetType.MIXED_REALITY_ALPHA_MASK, key="alpha_mask")
    protected static boolean mixedRealityAlphaMask = false;
    @VROptionField(widgetType=VROptionWidgetType.MIXED_REALITY_FOV, key="fov")
    protected static float mixedRealityFov = 40.0f;
    @VROptionField(key="keyColor", category=VROptionCategory.RENDERING_MIXED_REALITY)
    protected static AtumColor mixedRealityKeyColor = AtumColor.immutable(0, 0, 0, 255);
    @VROptionField(key="aspectRatio", category=VROptionCategory.RENDERING_MIXED_REALITY)
    protected static float mixedRealityAspectRatio = 1.7777778f;
    protected static final float sprintThreshold = 0.9f;
    protected static final float jumpThreshold = 0.05f;
    protected static final float sneakThreshold = 0.4f;
    protected static final float crawlThreshold = 0.82f;
    protected static final boolean walkUpEnabled = true;
    @VROptionField(widgetType=VROptionWidgetType.ROTATION_MODE, key="rotation_mode")
    protected static RotationMode rotationMode = RotationMode.HMD;
    private static final float defaultHeight = 1.52f;
    @VROptionField(key="player.height")
    protected static float playerHeight = 1.52f;

    public static void setVrPlayMode(VRPlayMode vrPlayMode) {
        VRClientSettings.vrPlayMode = vrPlayMode;
        VisorClientImpl.LOGGER.info("Changed VR Play Mode to: {}", (Object)VRClientSettings.getVrPlayMode());
    }

    public static void updateThirdPersonCamera(@NotNull Vector3fc position, @NotNull Quaternionfc rotation, boolean save) {
        thirdPersonCameraPosX = position.x();
        thirdPersonCameraPosY = position.y();
        thirdPersonCameraPosZ = position.z();
        thirdPersonCameraRotation = new Quaternionf(rotation);
        if (save) {
            ClientContext.settingsHandler.saveOptions();
        }
    }

    public static void setEyeFovScaleCurrent(float value) {
        eyeFovScaleCurrent = value;
        eyeFovChanged = true;
    }

    public static boolean isWalkUpEnabled() {
        return VisorClientImpl.MC.field_1724 != null && !VisorClientImpl.MC.field_1724.method_7325();
    }

    public static float getPlayerHeight() {
        if (playerHeight < 0.0f) {
            return 1.52f;
        }
        return playerHeight;
    }

    public static void calibrateHeight() {
        VRClientSettings.setPlayerHeight(ClientContext.rawPoseHandler.getHmdData().getPivotHistory().averagePosition((float)0.5f).y);
        int i = (int)Math.round(100.0 * (double)VRClientSettings.getPlayerHeight() / (double)1.52f);
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)LangHelper.getText("visor.messages.height_set", i)));
        ClientContext.settingsHandler.saveOptions();
    }

    public static VRPlayMode getVrPlayMode() {
        return vrPlayMode;
    }

    public static boolean isLeftHanded() {
        return leftHanded;
    }

    public static String getKeyboardKeys() {
        return keyboardKeys;
    }

    public static String getKeyboardKeysShift() {
        return keyboardKeysShift;
    }

    public static float getWorldScale() {
        return worldScale;
    }

    public static float getWorldRotationIncrement() {
        return worldRotationIncrement;
    }

    public static float getWalkMultiplier() {
        return walkMultiplier;
    }

    public static MirrorMode getMirrorMode() {
        return mirrorMode;
    }

    public static EyeType getMirrorEye() {
        return mirrorEye;
    }

    public static float getEyesFovScale() {
        return eyesFovScale;
    }

    public static float getEyeFovScaleCurrent() {
        return eyeFovScaleCurrent;
    }

    public static boolean isEyeFovChanged() {
        return eyeFovChanged;
    }

    public static void setEyeFovChanged(boolean eyeFovChanged) {
        VRClientSettings.eyeFovChanged = eyeFovChanged;
    }

    public static float getRenderScaleFactor() {
        return 1.0f;
    }

    public static float getMirrorSmooth() {
        return 0.0f;
    }

    public static float getMirrorCrop() {
        return 0.15f;
    }

    public static boolean isLowHealthIndicatorEnabled() {
        return lowHealthIndicatorEnabled;
    }

    public static boolean isHitIndicatorEnabled() {
        return hitIndicatorEnabled;
    }

    public static boolean isFreezeEffectEnabled() {
        return freezeEffectEnabled;
    }

    public static boolean isPumpkinEffectEnabled() {
        return pumpkinEffectEnabled;
    }

    public static String getPanoramaFront() {
        return panoramaFront;
    }

    public static String getPanoramaBack() {
        return panoramaBack;
    }

    public static String getPanoramaRight() {
        return panoramaRight;
    }

    public static String getPanoramaLeft() {
        return panoramaLeft;
    }

    public static String getPanoramaUp() {
        return panoramaUp;
    }

    public static String getPanoramaBelow() {
        return panoramaBelow;
    }

    public static String getMainMenuFloor() {
        return mainMenuFloor;
    }

    public static ShaderGUIRenderMode getShaderGUIRender() {
        return shaderGUIRender;
    }

    public static float getGuiScale() {
        return guiScale;
    }

    public static boolean isHudDisableHotBar() {
        return hudDisableHotBar;
    }

    public static float getThirdPersonFov() {
        return thirdPersonFov;
    }

    public static float getThirdPersonCameraPosX() {
        return thirdPersonCameraPosX;
    }

    public static float getThirdPersonCameraPosY() {
        return thirdPersonCameraPosY;
    }

    public static float getThirdPersonCameraPosZ() {
        return thirdPersonCameraPosZ;
    }

    public static Quaternionfc getThirdPersonCameraRotation() {
        return thirdPersonCameraRotation;
    }

    public static boolean isMixedRealityRenderHands() {
        return mixedRealityRenderHands;
    }

    public static boolean isMixedRealityAsGrid2x2() {
        return mixedRealityAsGrid2x2;
    }

    public static boolean isMixedRealityWithFirstPerson() {
        return mixedRealityWithFirstPerson;
    }

    public static boolean isMixedRealityAlphaMask() {
        return mixedRealityAlphaMask;
    }

    public static float getMixedRealityFov() {
        return mixedRealityFov;
    }

    public static AtumColor getMixedRealityKeyColor() {
        return mixedRealityKeyColor;
    }

    public static float getMixedRealityAspectRatio() {
        return mixedRealityAspectRatio;
    }

    public static float getSprintThreshold() {
        return 0.9f;
    }

    public static float getJumpThreshold() {
        return 0.05f;
    }

    public static float getSneakThreshold() {
        return 0.4f;
    }

    public static float getCrawlThreshold() {
        return 0.82f;
    }

    public static RotationMode getRotationMode() {
        return rotationMode;
    }

    public static void setPlayerHeight(float playerHeight) {
        VRClientSettings.playerHeight = playerHeight;
    }
}

