/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import me.phoenixra.visor.compatibility.ShadersHelper;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.settings.VROptionCategory;
import me.phoenixra.visor.core.client.settings.options.OptionBehaviour;
import me.phoenixra.visor.core.client.settings.options.OptionBehaviourFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum VROptionWidgetType {
    EMPTY(VROptionCategory.EMPTY, it -> null),
    LEFT_HANDED(VROptionCategory.CONTROLS, it -> null),
    THIRD_PERSON_FOV(VROptionCategory.RENDERING_THIRD_PERSON, it -> {
        ArrayList<Float> entries = new ArrayList<Float>();
        for (int i = 0; i <= 150; ++i) {
            entries.add(Float.valueOf(i));
        }
        return OptionBehaviourFactory.discreteSlider(it, entries, () -> {
            int initialIndex = entries.indexOf(Float.valueOf(VRClientSettings.getThirdPersonFov()));
            return initialIndex != -1 ? initialIndex : entries.size() / 2;
        }).setOnUpdateName(pair -> (String)pair.first() + String.format("%.0f\u00b0", Float.valueOf(((Float)pair.second()).floatValue()))).build();
    }),
    MIXED_REALITY_FOV(VROptionCategory.RENDERING_MIXED_REALITY, it -> {
        ArrayList<Integer> entries = new ArrayList<Integer>();
        for (int i = 0; i <= 150; ++i) {
            entries.add(i);
        }
        return OptionBehaviourFactory.discreteSlider(it, entries, () -> {
            int initialIndex = entries.indexOf((int)VRClientSettings.getMixedRealityFov());
            return initialIndex != -1 ? initialIndex : entries.size() / 2;
        }).setOnUpdateName(pair -> (String)pair.first() + String.format("%.0f\u00b0", Float.valueOf(((Float)pair.second()).floatValue()))).build();
    }),
    MIXED_REALITY_ALPHA_MASK(VROptionCategory.RENDERING_MIXED_REALITY, it -> null),
    MIXED_REALITY_WITH_FIRST_PERSON(VROptionCategory.RENDERING_MIXED_REALITY, it -> null),
    MIXED_REALITY_AS_GRID_2_X_2(VROptionCategory.RENDERING_MIXED_REALITY, it -> null),
    MIXED_REALITY_RENDER_HANDS(VROptionCategory.RENDERING_MIXED_REALITY, it -> null),
    HUD_DISABLED_HOTBAR(VROptionCategory.GUI, it -> null),
    SHADER_GUI_RENDER(VROptionCategory.GUI, it -> null),
    LOW_HEALTH_INDICATOR(VROptionCategory.RENDERING_EYE_EFFECTS, it -> null),
    HIT_INDICATOR(VROptionCategory.RENDERING_EYE_EFFECTS, it -> null),
    FREEZE_EFFECT(VROptionCategory.RENDERING_EYE_EFFECTS, it -> null),
    PUMPKIN_EFFECT(VROptionCategory.RENDERING_EYE_EFFECTS, it -> null),
    MIRROR_MODE(VROptionCategory.RENDERING, it -> OptionBehaviourFactory.simple(it).setOnChanged(() -> {
        if (VisorState.getState().isActive() && !ShadersHelper.isShaderActive()) {
            ClientContext.renderer.prepareReinit("Mirror Setting Changed");
        }
    }).build()),
    MIRROR_EYE(VROptionCategory.RENDERING, it -> null),
    WORLD_ROTATION_INCREMENT(VROptionCategory.MOVEMENT, it -> {
        List<Float> entries = List.of(Float.valueOf(10.0f), Float.valueOf(30.0f), Float.valueOf(45.0f), Float.valueOf(90.0f));
        return OptionBehaviourFactory.discreteSlider(it, entries, () -> {
            int initialIndex = entries.indexOf(Float.valueOf(VRClientSettings.getWorldRotationIncrement()));
            return initialIndex != -1 ? initialIndex : entries.size() / 2;
        }).setOnUpdateName(pair -> (String)pair.first() + String.format("%.0f\u00b0", Float.valueOf(((Float)pair.second()).floatValue()))).setOnChanged(() -> ClientContext.player.setRotationY(0.0f)).build();
    }),
    ROTATION_MODE(VROptionCategory.MOVEMENT, it -> null);

    private String key;
    private final VROptionCategory category;
    private final OptionBehaviour behaviour;

    private VROptionWidgetType(VROptionCategory category, Function<VROptionWidgetType, OptionBehaviour> behaviourProvider) {
        this.category = category;
        this.behaviour = Objects.requireNonNullElse(behaviourProvider.apply(this), OptionBehaviourFactory.simple(this).build());
    }

    @Nullable
    public <T extends OptionBehaviour> T getBehaviourAs(@NotNull Class<T> type) {
        if (type.isInstance(this.behaviour)) {
            return (T)((OptionBehaviour)type.cast(this.behaviour));
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public VROptionCategory getCategory() {
        return this.category;
    }

    public OptionBehaviour getBehaviour() {
        return this.behaviour;
    }
}

