/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.settings.overlays;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.atumconfig.api.config.ConfigType;
import me.phoenixra.atumconfig.api.config.catalog.ConfigCatalog;
import me.phoenixra.atumconfig.core.config.AtumConfigFile;
import me.phoenixra.visor.api.client.gui.OverlayConfigAccessor;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.settings.overlays.OverlayCatalogListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlayConfigsManager
implements OverlayConfigAccessor {
    protected final Map<String, ConfigFile> configs = new HashMap<String, ConfigFile>();
    protected final Map<ConfigFile, ConfigCatalog> configCatalogMap = new HashMap<ConfigFile, ConfigCatalog>();
    protected final Map<VisorAddon, ConfigCatalog> catalogsBuiltIn = new HashMap<VisorAddon, ConfigCatalog>();
    protected final Map<VisorAddon, ConfigCatalog> catalogsCustom = new HashMap<VisorAddon, ConfigCatalog>();

    @Override
    public void reload(@NotNull VisorAddon addon) {
        ConfigCatalog catalog = this.getCatalogOrCreate(addon, true);
        catalog.reload();
        catalog = this.getCatalogOrCreate(addon, false);
        catalog.reload();
    }

    @Override
    @NotNull
    public ConfigFile getConfigOrCreate(@NotNull VROverlay overlay) throws IOException {
        String id = overlay.getId();
        VisorAddon addon = overlay.getOwner();
        boolean builtIn = overlay.isBuiltIn();
        return this.configs.computeIfAbsent(id, key -> {
            AtumConfigFile config;
            ConfigCatalog catalog = this.getCatalogOrCreate(addon, builtIn);
            try {
                config = new AtumConfigFile(catalog.getConfigManager(), ConfigType.YAML, id, catalog.getDirectory().resolve(id + ".yml"), false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.configCatalogMap.put(config, catalog);
            return config;
        });
    }

    @Override
    @Nullable
    public ConfigFile getConfig(@NotNull String id) {
        return this.configs.get(id);
    }

    public void addConfig(@NotNull VisorAddon addon, @NotNull ConfigFile config, boolean builtIn) {
        ConfigCatalog catalog = this.getCatalogOrCreate(addon, builtIn);
        ConfigFile oldConfig = this.configs.put(config.getId(), config);
        if (oldConfig != null) {
            this.configCatalogMap.remove(oldConfig);
        }
        this.configCatalogMap.put(config, catalog);
    }

    public void removeConfig(@NotNull String id) {
        ConfigCatalog catalog;
        ConfigFile config = this.configs.remove(id);
        if (config != null && (catalog = this.configCatalogMap.remove(config)) != null) {
            catalog.getConfigFilesMap().remove(id);
        }
    }

    public void onCatalogCleared(@NotNull ConfigCatalog catalog) {
        List<ConfigFile> list = this.configCatalogMap.entrySet().stream().filter(entry -> entry.getValue() == catalog).map(Map.Entry::getKey).toList();
        for (ConfigFile config : list) {
            this.configCatalogMap.remove(config);
            this.configs.remove(config.getId());
        }
    }

    public List<ConfigFile> getAddonConfigs(@NotNull VisorAddon addon, boolean builtIn) {
        ConfigCatalog catalog = this.getCatalogOrCreate(addon, builtIn);
        return this.configCatalogMap.entrySet().stream().filter(entry -> entry.getValue() == catalog).map(Map.Entry::getKey).toList();
    }

    private ConfigCatalog getCatalogOrCreate(@NotNull VisorAddon addon, boolean builtIn) {
        Map<VisorAddon, ConfigCatalog> catalogs = builtIn ? this.catalogsBuiltIn : this.catalogsCustom;
        String pathPrefix = builtIn ? "overlays/built_in/" : "overlays/custom/";
        String path = pathPrefix + addon.getAddonId();
        return catalogs.computeIfAbsent(addon, key -> {
            OverlayCatalogListener listener = new OverlayCatalogListener(this, builtIn);
            ConfigCatalog catalog = ClientContext.visor.getConfigManager().createCatalog(ConfigType.YAML, path, Path.of(path, new String[0]), true, listener);
            listener.setCatalog(catalog);
            listener.setAddon((VisorAddon)key);
            return catalog;
        });
    }
}

