/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.tasks;

import java.util.EnumMap;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.tasks.RegisterVisorTask;
import me.phoenixra.visor.api.client.tasks.TaskType;
import me.phoenixra.visor.api.client.tasks.VisorTask;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.input.actionset.actions.ActionRightMouse;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@RegisterVisorTask
public class TaskRoomConsume
extends VisorTask {
    private static final String ID = "room_consume";
    private static TaskRoomConsume instance;
    private static final int DURATION = 2100;
    private static final float MOUTH_DISTANCE = 0.25f;
    private static final float HAPTIC_PULSE_DURATION = 0.007f;
    private static final int HAPTIC_DELAY_EAT_DRINK = 2;
    private static final int HAPTIC_DELAY_TOOT_HORN = 1;
    private final EnumMap<ControllerHand, Boolean> consuming = new EnumMap(ControllerHand.class);
    private final EnumMap<ControllerHand, Long> eatStartMap = new EnumMap(ControllerHand.class);
    private boolean eatingPressed;

    public TaskRoomConsume(@NotNull VisorAddon owner) {
        super(owner);
        instance = this;
    }

    @Override
    protected void onRun(class_746 player) {
        boolean isEating;
        PoseDataImpl roomPose = ClientContext.player.getPoseData(PoseDataType.ROOM);
        Vector3fc hmdPos = roomPose.getHmd().getPosition();
        Vector3f mouthPos = roomPose.getController(ControllerHand.MAIN).getCustomVector((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f)).add(hmdPos);
        for (ControllerHand hand : ControllerHand.values()) {
            long ticksLeft;
            boolean usedItem;
            int hapticDelay;
            class_1799 foodItem;
            Vector3fc handPos = this.calculateHandPosition(roomPose, hand);
            if (mouthPos.distance(handPos) >= 0.25f) {
                this.consuming.put(hand, false);
                continue;
            }
            class_1268 interactHand = hand == ControllerHand.MAIN ? class_1268.field_5808 : class_1268.field_5810;
            class_1799 class_17992 = foodItem = hand == ControllerHand.MAIN ? player.method_6047() : player.method_6079();
            if (!this.isConsumable(foodItem)) continue;
            switch (foodItem.method_7976()) {
                case field_8950: 
                case field_8946: {
                    int n = 2;
                    break;
                }
                case field_39058: {
                    int n = 1;
                    break;
                }
                default: {
                    int n = hapticDelay = -1;
                }
            }
            if (hapticDelay == -1) continue;
            if (!this.consuming.getOrDefault((Object)hand, false).booleanValue() && (usedItem = VisorClientImpl.MC.field_1761.method_2919((class_1657)player, interactHand).method_23665())) {
                VisorClientImpl.MC.field_1773.field_4012.method_3215(interactHand);
                this.consuming.put(hand, true);
                this.eatStartMap.put(hand, class_156.method_658());
            }
            if (this.consuming.getOrDefault((Object)hand, false).booleanValue() && (ticksLeft = (long)player.method_6014()) > 0L && ticksLeft % 5L <= (long)hapticDelay) {
                ClientContext.inputManager.triggerHapticPulse(hand, 0.007f);
            }
            if (class_156.method_658() - this.eatStartMap.getOrDefault((Object)hand, 0L) <= 2100L) continue;
            this.consuming.put(hand, false);
        }
        boolean bl = isEating = this.consuming.getOrDefault((Object)ControllerHand.MAIN, false) != false || this.consuming.getOrDefault((Object)ControllerHand.OFFHAND, false) != false;
        if (isEating) {
            ActionRightMouse actionRightMouse = (ActionRightMouse)ClientContext.inputManager.getActiveSet().getAction("mouse_right");
            actionRightMouse.forcePress();
            this.eatingPressed = true;
        } else if (this.eatingPressed) {
            ActionRightMouse actionRightMouse = (ActionRightMouse)ClientContext.inputManager.getActiveSet().getAction("mouse_right");
            actionRightMouse.forceRelease();
            this.eatingPressed = false;
        }
    }

    @Override
    protected void onClear(class_746 player) {
        this.consuming.clear();
        this.eatStartMap.clear();
    }

    @Override
    public boolean isActive(@Nullable class_746 player) {
        if (VisorClientImpl.MC.field_1761 == null || player == null || !player.method_5805() || player.method_6113() || player.method_7325()) {
            return false;
        }
        return this.isConsumable(player.method_6047()) || this.isConsumable(player.method_6079());
    }

    @Override
    @NotNull
    public TaskType getType() {
        return TaskType.VR_PLAYER_TICK;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    private Vector3fc calculateHandPosition(PoseDataImpl roomPose, ControllerHand hand) {
        Vector3f basePos = ClientContext.rawPoseHandler.getControllerData(hand).getPositionHistory().averagePosition(0.333f);
        Vector3f customOffset = roomPose.getController(hand).getCustomVector((Vector3fc)new Vector3f(0.0f, 0.0f, -0.1f));
        Vector3f directionOffset = roomPose.getController(hand).getDirection().mul(0.1f, new Vector3f());
        return basePos.add((Vector3fc)customOffset, new Vector3f()).add((Vector3fc)directionOffset);
    }

    private boolean isConsumable(class_1799 item) {
        if (item == class_1799.field_8037) {
            return false;
        }
        class_1839 useAnim = item.method_7976();
        return useAnim == class_1839.field_8950 || useAnim == class_1839.field_8946 || useAnim == class_1839.field_39058;
    }

    public static TaskRoomConsume getInstance() {
        return instance;
    }
}

