/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.tasks.movement;

import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.data.PoseElement;
import me.phoenixra.visor.api.client.tasks.RegisterVisorTask;
import me.phoenixra.visor.api.client.tasks.TaskType;
import me.phoenixra.visor.api.client.tasks.VisorTask;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.data.PoseElementImpl;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@RegisterVisorTask
public class TaskRoomSwim
extends VisorTask {
    private static final String ID = "room_swim";
    private static TaskRoomSwim instance;
    private static final float SWIM_SPEED = 1.3f;
    private static final float FRICTION = 0.9f;
    private static final float SWIM_MOTION_SCALE = 0.1f;
    private static final float MIN_SWIM_THRESHOLD = 0.3f;
    private static final float SPRINTING_THRESHOLD = 1.0f;
    private static final float HEAD_PIVOT_Y_OFFSET = 0.3f;
    private Vector3fc motion = new Vector3f();
    private float lastDist;

    public TaskRoomSwim(@NotNull VisorAddon owner) {
        super(owner);
        instance = this;
    }

    @Override
    protected void onRun(class_746 player) {
        PoseDataImpl preTickPose = ClientContext.player.getPoseData(PoseDataType.PRE_TICK);
        PoseElement mainHand = preTickPose.getController(ControllerHand.MAIN);
        PoseElement offhand = preTickPose.getController(ControllerHand.OFFHAND);
        PoseElementImpl hmd = preTickPose.getHmd();
        Vector3fc mainHandPos = mainHand.getPosition();
        Vector3fc offhandPos = offhand.getPosition();
        Vector3f betweenHandsPos = offhandPos.sub(mainHandPos, new Vector3f()).mul(0.5f).add(mainHandPos);
        Vector3f headPivotPos = preTickPose.getHeadPivot().sub(0.0f, 0.3f, 0.0f, new Vector3f());
        Vector3f betweenHandsDir = betweenHandsPos.sub((Vector3fc)headPivotPos, new Vector3f()).normalize().add(hmd.getDirection()).mul(0.5f);
        Vector3f mainHandAim = mainHand.getCustomVector((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f)).add((Vector3fc)mainHand.getCustomVector((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f))).mul(0.5f);
        float swimPower = mainHandAim.add((Vector3fc)betweenHandsDir).length() / 2.0f;
        float handDistance = headPivotPos.distance((Vector3fc)betweenHandsPos);
        float distanceDelta = this.lastDist - handDistance;
        if ((double)distanceDelta > 0.0) {
            Vector3f swimMotion = betweenHandsDir.mul(distanceDelta * 1.3f * swimPower, new Vector3f());
            this.motion = this.motion.add((Vector3fc)swimMotion.mul(0.1f), new Vector3f());
        }
        this.lastDist = handDistance;
        double motionLength = this.motion.length();
        player.method_5796(motionLength > (double)0.3f);
        player.method_5728(motionLength > 1.0);
        player.method_5762((double)this.motion.x(), (double)this.motion.y(), (double)this.motion.z());
        this.motion = this.motion.mul(0.9f, new Vector3f());
    }

    @Override
    protected void onClear(@Nullable class_746 player) {
    }

    @Override
    public boolean isActive(class_746 p) {
        if (!ClientContext.visor.isFeatureEnabled(ClientFeature.MOVEMENT_MODIFIERS)) {
            return false;
        }
        if (VisorClientImpl.MC.field_1755 != null) {
            return false;
        }
        if (VisorClientImpl.MC.field_1761 == null) {
            return false;
        }
        if (p == null || !p.method_5805()) {
            return false;
        }
        if (!p.method_5799() && !p.method_5771()) {
            return false;
        }
        if (p.field_6250 > 0.0f) {
            return false;
        }
        return !(p.field_6212 > 0.0f);
    }

    @Override
    @NotNull
    public TaskType getType() {
        return TaskType.VR_PLAYER_TICK;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    public static TaskRoomSwim getInstance() {
        return instance;
    }
}

