/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.tasks.movement.vehicle;

import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.data.PoseElement;
import me.phoenixra.visor.api.client.tasks.RegisterVisorTask;
import me.phoenixra.visor.api.client.tasks.TaskType;
import me.phoenixra.visor.api.client.tasks.VisorTask;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.compatibility.ItemClassifier;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.data.VRClientPlayerImpl;
import me.phoenixra.visor.core.client.tasks.movement.TaskRoomSneak;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1496;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@RegisterVisorTask
public class TaskRoomVehicle
extends VisorTask {
    private static final String ID = "room_vehicle";
    private static TaskRoomVehicle instance;
    public class_243 premountPosRoom = new class_243(0.0, 0.0, 0.0);
    public float vehicleRotation = 0.0f;
    public int rotationCooldown = 0;
    private int minecartTimer;
    public int dismountDelay = 0;

    public TaskRoomVehicle(@NotNull VisorAddon owner) {
        super(owner);
        instance = this;
    }

    @Override
    protected void onRun(class_746 player) {
        class_746 mcPlayer;
        if (this.canAutoDismount(player)) {
            Vector3f mountPos = player.method_5854().method_19538().method_46409();
            Vector3fc headPivot = ClientContext.player.getPoseData(PoseDataType.PRE_TICK).getHeadPivot();
            double distance = Math.sqrt((headPivot.x() - mountPos.x()) * (headPivot.x() - mountPos.x()) + (headPivot.z() - mountPos.z()) * (headPivot.z() - mountPos.z()));
            if (distance > 0.7 && TaskRoomSneak.getInstance().getSneakTimer() == 0) {
                TaskRoomSneak.getInstance().setSneakTimer(5);
            }
        }
        if (this.dismountDelay > 0) {
            --this.dismountDelay;
        }
        if (this.rotationCooldown > 0) {
            --this.rotationCooldown;
        }
        if (!(mcPlayer = VisorClientImpl.MC.field_1724).method_5765() || this.rotationCooldown != 0) {
            this.minecartTimer = 3;
            if (mcPlayer.method_5765()) {
                this.vehicleRotation = mcPlayer.method_5854().method_36454();
            }
            return;
        }
        class_1297 vehicle = mcPlayer.method_5854();
        if (!(vehicle instanceof class_1695)) {
            return;
        }
        class_1695 minecart = (class_1695)vehicle;
        if (this.shouldMinecartTurnView(minecart)) {
            if (this.minecartTimer > 0) {
                --this.minecartTimer;
            }
        } else {
            this.minecartTimer = 3;
        }
        double rotationTarget = this.getMinecartRenderYaw(minecart);
        if (this.minecartTimer > 0) {
            this.vehicleRotation = (float)rotationTarget;
        }
        class_243 deltaMovement = vehicle.method_18798();
        double horizontalSpeed = new class_243(deltaMovement.field_1352, 0.0, deltaMovement.field_1350).method_1033();
        float smoothed = 200.0f * (float)(horizontalSpeed * horizontalSpeed);
        smoothed = Math.max(smoothed, 10.0f);
        VRClientPlayerImpl vrClientPlayer = ClientContext.player;
        float rotateTo = this.rotationDelta((float)rotationTarget, this.vehicleRotation);
        smoothed = (float)Math.toRadians(smoothed);
        rotateTo = Math.min(smoothed, Math.max(rotateTo, -smoothed));
        vrClientPlayer.setRotationY(vrClientPlayer.getRotationY() + rotateTo);
        this.vehicleRotation = (this.vehicleRotation - rotateTo) % 360.0f;
    }

    @Override
    protected void onClear(class_746 player) {
        this.minecartTimer = 2;
    }

    @Override
    public boolean isActive(class_746 p) {
        if (VisorClientImpl.MC.method_1493()) {
            return false;
        }
        if (p == null || VisorClientImpl.MC.field_1761 == null) {
            return false;
        }
        return p.method_5805();
    }

    public void onStartRiding(class_1297 vehicle) {
        VRClientPlayerImpl vrClientPlayer = ClientContext.player;
        PoseDataImpl preTickPose = vrClientPlayer.getPoseData(PoseDataType.PRE_TICK);
        Vector3fc headPivot = vrClientPlayer.getPoseData(PoseDataType.ROOM).getHeadPivot();
        this.premountPosRoom = new class_243((double)headPivot.x(), 0.0, (double)headPivot.z());
        this.dismountDelay = 5;
        float hmdYaw = preTickPose.getHmd().getYaw();
        float vehicleYRotation = vehicle.method_36454() % 360.0f;
        this.vehicleRotation = vrClientPlayer.getRotationY();
        this.rotationCooldown = 2;
        if (vehicle instanceof class_1695) {
            return;
        }
        float rotationDelta = this.rotationDelta(vehicleYRotation, hmdYaw);
        vrClientPlayer.setRotationY(preTickPose.getRotationY() + rotationDelta);
    }

    public void onStopRiding() {
        TaskRoomSneak.getInstance().setSneakTimer(0);
    }

    private float getMinecartRenderYaw(class_1695 minecart) {
        class_243 delta = new class_243(minecart.method_23317() - minecart.field_6038, minecart.method_23318() - minecart.field_5971, minecart.method_23321() - minecart.field_5989);
        float yaw = (float)Math.toDegrees(class_3532.method_15349((double)(-delta.field_1352), (double)delta.field_1350));
        return this.shouldMinecartTurnView(minecart) ? -180.0f + yaw : this.vehicleRotation;
    }

    private boolean shouldMinecartTurnView(class_1695 minecart) {
        class_243 delta = new class_243(minecart.method_23317() - minecart.field_6038, minecart.method_23318() - minecart.field_5971, minecart.method_23321() - minecart.field_5989);
        return delta.method_1033() > 0.001;
    }

    public boolean canAutoDismount(class_746 player) {
        return player.field_6250 == 0.0f && player.field_6212 == 0.0f && player.method_5765() && this.dismountDelay == 0;
    }

    public static Vector3fc getVehicleLookDirection(class_746 player) {
        class_1308 mob;
        class_1297 entity = player.method_5854();
        if (entity instanceof class_1496 || entity instanceof class_1690) {
            if (player.field_6250 <= 0.0f) {
                return null;
            }
            return ClientContext.player.getRotationElement(PoseDataType.PRE_TICK).getDirection();
        }
        if (entity instanceof class_1308 && (mob = (class_1308)entity).method_5787()) {
            ControllerHand handWithFood = ItemClassifier.FOOD_STICK.is(player.method_6047().method_7909()) ? ControllerHand.MAIN : ControllerHand.OFFHAND;
            PoseElement handPose = ClientContext.player.getPoseData(PoseDataType.PRE_TICK).getController(handWithFood);
            return handPose.getDirection().normalize(new Vector3f());
        }
        return null;
    }

    private float rotationDelta(float start, float end) {
        float radiansEnd = (float)Math.toRadians(end);
        float radiansStart = (float)Math.toRadians(start);
        return (float)class_3532.method_15349((double)class_3532.method_15374((float)(radiansEnd - radiansStart)), (double)class_3532.method_15362((float)(radiansEnd - radiansStart)));
    }

    @Override
    @NotNull
    public TaskType getType() {
        return TaskType.VR_PLAYER_TICK;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    public static TaskRoomVehicle getInstance() {
        return instance;
    }
}

