/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.tasks.registry;

import com.mojang.text2speech.Narrator;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.client.tasks.RegisterVisorTask;
import me.phoenixra.visor.api.client.tasks.TaskType;
import me.phoenixra.visor.api.client.tasks.VisorTask;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.VisorRegistry;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisorTaskRegistry
implements VisorRegistry<VisorTask> {
    private static final String REGISTRY_NAME = "Visor Tasks";
    private static final String ELEMENT_NAME = "VisorTask";
    private static final String ANNOTATION_NAME = "@RegisterVisorTask";
    private final Map<String, VisorTask> elementsMap = new LinkedHashMap<String, VisorTask>();
    private final EnumMap<TaskType, List<VisorTask>> elementsByType = new EnumMap(TaskType.class);
    private final Collection<VisorTask> allElements = Collections.unmodifiableCollection(this.elementsMap.values());
    private final List<VisorTask> preTick;
    private final List<VisorTask> playerTick;
    private final List<VisorTask> preRender;

    public VisorTaskRegistry() {
        for (TaskType type : TaskType.values()) {
            this.elementsByType.put(type, new ArrayList());
        }
        this.preTick = Collections.unmodifiableList(this.elementsByType.get((Object)TaskType.VR_PRE_TICK));
        this.playerTick = Collections.unmodifiableList(this.elementsByType.get((Object)TaskType.VR_PLAYER_TICK));
        this.preRender = Collections.unmodifiableList(this.elementsByType.get((Object)TaskType.VR_PRE_RENDER));
    }

    @Override
    public void registerAddonPath(@NotNull VisorAddon addon) {
        String path = addon.getAddonPackagePath();
        if (path == null) {
            return;
        }
        List<Class<?>> annotated = ModLoader.get().getClassesAnnotated(RegisterVisorTask.class, addon.getModId(), path);
        Narrator.LOGGER.info("Found {} {} to register in addon: '{}'", new Object[]{annotated.size(), ELEMENT_NAME, addon.getAddonId()});
        for (Class<?> clazz : annotated) {
            if (!VisorTask.class.isAssignableFrom(clazz)) {
                Narrator.LOGGER.warn("{} is annotated with {} but does not implement {}", new Object[]{clazz.getName(), ANNOTATION_NAME, ELEMENT_NAME});
                continue;
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(VisorAddon.class);
                VisorTask element = (VisorTask)constructor.newInstance(addon);
                this.registerElement(element);
            }
            catch (Exception e) {
                Narrator.LOGGER.error("Failed to register {} from class: {}", (Object)ELEMENT_NAME, (Object)clazz.getName());
                LoggerUtils.printError(e);
            }
        }
    }

    @Override
    public void registerElement(@NotNull VisorTask element) {
        VisorTask previous = this.elementsMap.put(element.getId(), element);
        if (previous != null) {
            Narrator.LOGGER.info("Overriding existing {}: '{}' from addon '{}'", new Object[]{ELEMENT_NAME, previous.getId(), previous.getOwner().getAddonId()});
            List<VisorTask> oldList = this.elementsByType.get((Object)previous.getType());
            oldList.remove(previous);
            Collections.sort(oldList);
        }
        List<VisorTask> newList = this.elementsByType.get((Object)element.getType());
        newList.add(element);
        Collections.sort(newList);
        if (previous == null) {
            Narrator.LOGGER.info("Registered {}: '{}'", (Object)ELEMENT_NAME, (Object)element.getId());
        }
    }

    @Override
    @Nullable
    public VisorTask unregisterElement(@NotNull String id) {
        VisorTask removed = this.elementsMap.remove(id);
        if (removed != null) {
            List<VisorTask> list = this.elementsByType.get((Object)removed.getType());
            list.remove(removed);
            Collections.sort(list);
            Narrator.LOGGER.info("Unregistered {}: '{}'", (Object)ELEMENT_NAME, (Object)removed.getId());
        }
        return removed;
    }

    @Override
    @Nullable
    public VisorTask getElement(@NotNull String id) {
        return this.elementsMap.get(id);
    }

    @Override
    @NotNull
    public String getRegistryName() {
        return REGISTRY_NAME;
    }

    @Override
    public Collection<VisorTask> getAllElements() {
        return this.allElements;
    }

    public List<VisorTask> getPreTick() {
        return this.preTick;
    }

    public List<VisorTask> getPlayerTick() {
        return this.playerTick;
    }

    public List<VisorTask> getPreRender() {
        return this.preRender;
    }
}

