/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.common.eventbus;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.eventbus.VREventBus;
import me.phoenixra.visor.api.common.eventbus.event.VREvent;
import me.phoenixra.visor.api.common.eventbus.event.VREventPriority;
import me.phoenixra.visor.api.common.eventbus.listener.VREventHandler;
import me.phoenixra.visor.api.common.eventbus.listener.VREventListener;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import me.phoenixra.visor.core.common.eventbus.HandlerData;
import org.jetbrains.annotations.NotNull;

public class VREventBusImpl
implements VREventBus {
    private final List<HandlerData> handlers = Collections.synchronizedList(new ArrayList());
    private final Map<Class<? extends VREvent>, Map<VREventPriority, List<HandlerData>>> cache = new ConcurrentHashMap<Class<? extends VREvent>, Map<VREventPriority, List<HandlerData>>>();

    @Override
    public void callEvent(@NotNull VREvent event) {
        Map<VREventPriority, List<HandlerData>> handlersByPhase = this.getHandlers(event);
        while (event.nextPhase()) {
            List<HandlerData> handlersForPhase = handlersByPhase.get((Object)event.getPhase());
            if (handlersForPhase == null) continue;
            for (HandlerData handler : handlersForPhase) {
                if (event.isCanceled() && !handler.ignoreCancelled()) continue;
                try {
                    handler.method().invoke((Object)handler.listener(), event);
                }
                catch (Throwable e) {
                    LoggerUtils.printError(e);
                }
            }
        }
    }

    @Override
    public void registerListener(@NotNull VisorAddon owner, @NotNull VREventListener listener) {
        for (Method method : listener.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(VREventHandler.class)) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalStateException("Method " + String.valueOf(method) + " in listener " + String.valueOf(listener) + " is not accessible. It must be declared public.");
            }
            HandlerData data = VREventBusImpl.createHandlerData(owner, listener, method);
            this.handlers.add(data);
        }
        this.invalidateCache();
    }

    @Override
    public void unregisterListener(@NotNull VREventListener listener) {
        this.handlers.removeIf(h -> h.listener().equals(listener));
        this.invalidateCache();
    }

    @Override
    public void unregisterListeners(@NotNull VisorAddon owner) {
        this.handlers.removeIf(h -> h.owner().equals(owner));
        this.invalidateCache();
    }

    @Override
    public void unregisterAllListeners() {
        this.handlers.clear();
        this.invalidateCache();
    }

    @Override
    @NotNull
    public Set<VREventListener> getRegisteredListeners() {
        return this.handlers.stream().map(HandlerData::listener).collect(Collectors.toSet());
    }

    private void invalidateCache() {
        this.cache.clear();
    }

    private Map<VREventPriority, List<HandlerData>> getHandlers(@NotNull VREvent event) {
        return this.cache.computeIfAbsent(event.getClass(), key -> {
            EnumMap<VREventPriority, List> map = new EnumMap<VREventPriority, List>(VREventPriority.class);
            for (HandlerData h : this.handlers) {
                if (!h.eventType().isAssignableFrom((Class<?>)key)) continue;
                map.computeIfAbsent(h.priority(), k -> new ArrayList()).add(h);
            }
            return map;
        });
    }

    @NotNull
    private static HandlerData createHandlerData(VisorAddon owner, VREventListener listener, Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 1 || !VREvent.class.isAssignableFrom(params[0])) {
            throw new IllegalStateException("Method " + String.valueOf(method) + " in listener " + String.valueOf(listener) + " has an invalid signature for event handling. It must have exactly one parameter extending VREvent.");
        }
        VREventHandler annotation = method.getAnnotation(VREventHandler.class);
        return new HandlerData(owner, listener, method, params[0], annotation.priority(), annotation.ignoreCancelled());
    }
}

