/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.phoenixra.atumconfig.api.ConfigManager;
import me.phoenixra.atumconfig.core.AtumConfigManager;
import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.VisorServer;
import me.phoenixra.visor.api.common.MCVRLogger;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import me.phoenixra.visor.api.server.player.VRServerPlayer;
import me.phoenixra.visor.core.common.addon.AddonManagerImpl;
import me.phoenixra.visor.core.common.addon.CoreAddonServer;
import me.phoenixra.visor.core.server.ServerConfig;
import me.phoenixra.visor.core.server.VRServerPlayerImpl;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VisorServerImpl
implements VisorServer {
    public static VisorServerImpl INSTANCE;
    public static final Logger LOGGER;
    private final Map<UUID, VRServerPlayer> playersWithVR = new HashMap<UUID, VRServerPlayer>();
    private ConfigManager configManager;
    private AddonManagerImpl addonManager;

    private VisorServerImpl() {
    }

    public static void create() {
        INSTANCE = new VisorServerImpl();
        INSTANCE.init();
        LOGGER.info("VR Server Core initialized");
    }

    private void init() {
        VisorAPI.Instance.setServer(this);
        this.configManager = new AtumConfigManager("visor_server", VisorAPI.CONFIG_PATH, new MCVRLogger(LOGGER), true);
        ServerConfig serverConfig = new ServerConfig();
        try {
            serverConfig.init();
        }
        catch (Throwable e) {
            LoggerUtils.printError(e);
        }
        if (ModLoader.get().isDedicatedServer()) {
            this.addonManager = new AddonManagerImpl(LOGGER);
            this.addonManager.initialize(new CoreAddonServer(), List.of());
        }
    }

    public void tickVR() {
    }

    public void onServerStop() {
        this.playersWithVR.clear();
        VisorAPI.Instance.setServer(null);
        INSTANCE = null;
        LOGGER.info("VR Server Core cleared");
    }

    @Override
    public VRServerPlayerImpl getVrPlayer(@NotNull class_3222 player) {
        VRServerPlayerImpl out = (VRServerPlayerImpl)this.playersWithVR.get(player.method_5667());
        if (out != null && out.getMcPlayer() != player) {
            out.mcPlayer = player;
        }
        return out;
    }

    @Override
    @NotNull
    public Collection<VRServerPlayer> getVrPlayers() {
        return this.playersWithVR.values();
    }

    @Override
    public boolean isVRPlayer(@NotNull class_3222 player) {
        VRServerPlayerImpl vrPlayer = this.getVrPlayer(player);
        if (vrPlayer == null) {
            return false;
        }
        return vrPlayer.isVr();
    }

    public void putVrPlayer(VRServerPlayerImpl player) {
        this.playersWithVR.put(player.mcPlayer.method_5667(), player);
    }

    public void updateVrPlayer(class_3222 player) {
        VRServerPlayerImpl vrServerPlayer = (VRServerPlayerImpl)this.playersWithVR.get(player.method_5667());
        if (vrServerPlayer != null) {
            vrServerPlayer.mcPlayer = player;
        }
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return LOGGER;
    }

    public Map<UUID, VRServerPlayer> getPlayersWithVR() {
        return this.playersWithVR;
    }

    @Override
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    static {
        LOGGER = LogManager.getLogger((String)"Visor-Server");
    }
}

