/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.server.network;

import java.util.function.Consumer;
import me.phoenixra.visor.api.common.network.VisorPayloadID;
import me.phoenixra.visor.api.common.network.toclient.HandshakePayloadToClient;
import me.phoenixra.visor.api.common.network.toclient.SettingsPayloadToClient;
import me.phoenixra.visor.api.common.network.toclient.VisorPayloadToClient;
import me.phoenixra.visor.api.common.network.toclient.vrstate.VRActivePayloadToClient;
import me.phoenixra.visor.api.common.network.toserver.HandshakePayloadToServer;
import me.phoenixra.visor.api.common.network.toserver.UnknownPayloadToServer;
import me.phoenixra.visor.api.common.network.toserver.VisorPayloadToServer;
import me.phoenixra.visor.api.common.network.toserver.vrstate.HeightPayloadToServer;
import me.phoenixra.visor.api.common.network.toserver.vrstate.VRActivePayloadToServer;
import me.phoenixra.visor.api.common.network.toserver.vrstate.VRPosePayloadToServer;
import me.phoenixra.visor.api.common.network.toserver.vrstate.WorldScalePayloadToServer;
import me.phoenixra.visor.api.server.VRServerSettings;
import me.phoenixra.visor.core.server.ServerConfig;
import me.phoenixra.visor.core.server.VRServerPlayerImpl;
import me.phoenixra.visor.core.server.VisorServerImpl;
import me.phoenixra.visor.core.server.network.ServerNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.apache.logging.log4j.Logger;

public class ServerPacketHandler {
    public static void handlePacket(VisorPayloadToServer payloadToServer, class_3222 player, Consumer<VisorPayloadToClient> packetConsumer) {
        if (payloadToServer instanceof UnknownPayloadToServer) {
            return;
        }
        VRServerPlayerImpl vrPlayer = VisorServerImpl.INSTANCE.getVrPlayer(player);
        if (vrPlayer == null) {
            if (payloadToServer.payloadId() != VisorPayloadID.HANDSHAKE) {
                return;
            }
            vrPlayer = new VRServerPlayerImpl(player);
        }
        VisorServerImpl.INSTANCE.updateVrPlayer(player);
        switch (payloadToServer.payloadId()) {
            case HANDSHAKE: {
                HandshakePayloadToServer payload = (HandshakePayloadToServer)payloadToServer;
                ServerPacketHandler.handleHandshake(player, vrPlayer, packetConsumer, payload.version(), payload.vrActive(), payload.maxVersion(), payload.minVersion());
                break;
            }
            case PLAYER_VR_ACTIVE: {
                VRActivePayloadToServer payload = (VRActivePayloadToServer)payloadToServer;
                if (vrPlayer.isVr() == payload.hasVr()) {
                    return;
                }
                boolean hasVR = !vrPlayer.isVr();
                vrPlayer.setVr(hasVR);
                if (hasVR) {
                    return;
                }
                ServerNetworking.sendPacketToTrackedPlayers(vrPlayer, false, new VRActivePayloadToClient(vrPlayer.mcPlayer.method_5667(), vrPlayer.isVr()));
                break;
            }
            case VR_POSE: {
                VRPosePayloadToServer payload = (VRPosePayloadToServer)payloadToServer;
                vrPlayer.setPlayerPoseBuffer(payload.pose());
                break;
            }
            case WORLD_SCALE: {
                WorldScalePayloadToServer payload = (WorldScalePayloadToServer)payloadToServer;
                vrPlayer.worldScale = payload.worldScale();
                break;
            }
            case HEIGHT: {
                HeightPayloadToServer payload = (HeightPayloadToServer)payloadToServer;
                vrPlayer.heightScale = payload.heightScale();
            }
        }
    }

    private static void handleHandshake(class_3222 player, VRServerPlayerImpl vrPlayer, Consumer<VisorPayloadToClient> packetConsumer, String version, boolean vrActive, int maxVersion, int minVersion) {
        Logger logger = VisorServerImpl.INSTANCE.getLogger();
        if (VRServerSettings.isServerDebug()) {
            logger.info("Visor: player '{}' joined with {}", (Object)player.method_5477().getString(), (Object)version);
        }
        if (1 <= maxVersion && minVersion <= 1) {
            vrPlayer.networkVersion = Math.min(maxVersion, 1);
            if (VRServerSettings.isServerDebug()) {
                logger.info("Visor: {} networking supported, using version {}", (Object)player.method_5477().getString(), (Object)vrPlayer.networkVersion);
            }
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"Unsupported visor version, VR features will not work"));
            if (VRServerSettings.isServerDebug()) {
                logger.info("Visor: {} networking not supported. client range [{},{}], server range [{},{}]", (Object)player.method_5820(), (Object)minVersion, (Object)maxVersion, (Object)1, (Object)1);
            }
            return;
        }
        vrPlayer.setVr(vrActive);
        if (VRServerSettings.isServerDebug()) {
            VisorServerImpl.LOGGER.info("VR: player '{}' joined with {}", (Object)vrPlayer.getMcPlayer().method_5477().getString(), (Object)version);
        }
        VisorServerImpl.INSTANCE.putVrPlayer(vrPlayer);
        packetConsumer.accept(new HandshakePayloadToClient(vrPlayer.networkVersion));
        packetConsumer.accept(new SettingsPayloadToClient(ServerConfig.getSettingsForClient().toPlaintext()));
    }
}

