/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.loader.fabric;

import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.common.network.toclient.VisorPayloadToClient;
import me.phoenixra.visor.api.common.network.toserver.VisorPayloadToServer;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class FabricModLoader
implements ModLoader {
    private final File configFolder = FabricLoader.getInstance().getConfigDir().toFile();

    @Override
    public File getConfigFolder() {
        return this.configFolder;
    }

    @Override
    @NotNull
    public String getId() {
        return "fabric";
    }

    @Override
    public boolean isModLoaded(@NotNull String id) {
        return FabricLoader.getInstance().isModLoaded(id);
    }

    @Override
    @NotNull
    public String getModVersion(@NotNull String id) {
        if (this.isModLoaded("visor")) {
            return ((ModContainer)FabricLoader.getInstance().getModContainer(id).get()).getMetadata().getVersion().getFriendlyString();
        }
        return "version not found";
    }

    @Override
    public boolean isDedicatedServer() {
        return FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.SERVER);
    }

    @Override
    public boolean enableRenderTargetStencil(@NotNull class_276 renderTarget) {
        return false;
    }

    @Override
    public double getItemEntityReach(double baseRange, class_1799 itemStack, class_1304 slot) {
        return baseRange;
    }

    @Override
    @NotNull
    public List<Class<?>> getClassesAnnotated(final @NotNull Class<? extends Annotation> annotation, @NotNull String modId, @NotNull String packagePath) {
        try {
            ArrayList result = new ArrayList();
            ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer(modId).orElseThrow(() -> new IllegalArgumentException("Unknown mod: " + modId));
            String pkgPath = packagePath.replace('.', '/');
            for (Path root : container.getRootPaths()) {
                final Path pkgRoot = root.resolve(pkgPath);
                if (!Files.exists(pkgRoot, new LinkOption[0])) continue;
                Stream<Path> stream = Files.walk(pkgRoot, new FileVisitOption[0]);
                try {
                    stream.filter(p -> p.getFileName().toString().endsWith(".class")).forEach(classFile -> {
                        try (InputStream in = Files.newInputStream(classFile, new OpenOption[0]);){
                            ClassReader reader = new ClassReader(in);
                            reader.accept(new ClassVisitor(589824, (Path)classFile, packagePath, result){
                                final /* synthetic */ Path val$classFile;
                                final /* synthetic */ String val$packagePath;
                                final /* synthetic */ List val$result;
                                {
                                    this.val$classFile = path2;
                                    this.val$packagePath = string;
                                    this.val$result = list;
                                    super(api);
                                }

                                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                                    String found = Type.getType((String)desc).getClassName();
                                    if (found.equals(annotation.getName())) {
                                        Path rel = pkgRoot.relativize(this.val$classFile);
                                        String className = this.val$packagePath + "." + rel.toString().replace('/', '.').replace('\\', '.').replaceAll("\\.class$", "");
                                        try {
                                            this.val$result.add(Class.forName(className, false, Thread.currentThread().getContextClassLoader()));
                                        }
                                        catch (ClassNotFoundException e) {
                                            throw new RuntimeException(e);
                                        }
                                    }
                                    return super.visitAnnotation(desc, visible);
                                }
                            }, 7);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public class_2596<?> createPacketToClient(@NotNull VisorPayloadToClient payload) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        payload.write(buffer);
        return ServerPlayNetworking.createS2CPacket((class_2960)payload.id(), (class_2540)buffer);
    }

    @Override
    @NotNull
    public class_2596<?> createPacketToServer(@NotNull VisorPayloadToServer payload) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        payload.write(buffer);
        return ClientPlayNetworking.createC2SPacket((class_2960)payload.id(), (class_2540)buffer);
    }

    @Override
    public boolean renderBlockOverlay(class_1657 player, class_4587 mat, class_2680 state, class_2338 pos) {
        return false;
    }

    @Override
    public boolean renderWaterOverlay(class_1657 player, class_4587 mat) {
        return false;
    }

    @Override
    public boolean renderFireOverlay(class_1657 player, class_4587 mat) {
        return false;
    }
}

