/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.api;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import me.phoenixra.atumconfig.api.ConfigLogger;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.atumconfig.api.config.ConfigParser;
import me.phoenixra.atumconfig.api.config.ConfigType;
import me.phoenixra.atumconfig.api.config.catalog.ConfigCatalog;
import me.phoenixra.atumconfig.api.config.catalog.ConfigCatalogListener;
import me.phoenixra.atumconfig.api.placeholders.PlaceholderHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ConfigManager {
    @NotNull
    public String getId();

    @NotNull
    public Path getDirectory();

    public boolean supportsColorCodes();

    public void reloadAll();

    @NotNull
    public ConfigLogger getLogger();

    @NotNull
    public Optional<PlaceholderHandler> getPlaceholderHandler();

    public void setPlaceholderHandler(@Nullable PlaceholderHandler var1);

    @NotNull
    public <T> Optional<ConfigParser<T>> getConfigParser(@NotNull Class<T> var1);

    public void addConfigParser(@NotNull ConfigParser<?> var1);

    @NotNull
    public Config createConfig(@NotNull ConfigType var1, @Nullable Map<String, Object> var2);

    @NotNull
    public Config createConfigFromStream(@NotNull ConfigType var1, @NotNull InputStream var2);

    @NotNull
    public Config createConfigFromString(@NotNull ConfigType var1, @NotNull String var2);

    @NotNull
    public ConfigFile createConfigFile(@NotNull ConfigType var1, @NotNull String var2, @NotNull Path var3, boolean var4) throws IOException;

    @NotNull
    default public ConfigFile createConfigFile(@NotNull ConfigType type, @NotNull String id, @NotNull Path relativePath) throws IOException {
        return this.createConfigFile(type, id, relativePath, false);
    }

    @NotNull
    public ConfigCatalog createCatalog(@NotNull ConfigType var1, @NotNull String var2, @NotNull Path var3, boolean var4, @NotNull ConfigCatalogListener var5);

    @NotNull
    default public ConfigCatalog createCatalog(@NotNull ConfigType type, @NotNull String id, @NotNull Path relativeDirectory, @NotNull ConfigCatalogListener catalogListener) {
        return this.createCatalog(type, id, relativeDirectory, false, catalogListener);
    }

    @NotNull
    public ConfigManager addConfigFile(@NotNull ConfigFile var1);

    @NotNull
    public ConfigManager addCatalog(@NotNull ConfigCatalog var1);

    @NotNull
    public Optional<ConfigCatalog> getCatalog(@NotNull String var1);

    @NotNull
    public Optional<ConfigFile> getConfigFile(@NotNull String var1);

    @NotNull
    public Map<String, ConfigFile> getConfigFilesMap();

    @NotNull
    public Map<String, ConfigCatalog> getConfigCatalogsMap();
}

