/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.api.placeholders.types;

import java.util.function.Supplier;
import java.util.regex.Pattern;
import me.phoenixra.atumconfig.api.placeholders.Placeholder;
import me.phoenixra.atumconfig.api.placeholders.context.PlaceholderContext;
import me.phoenixra.atumconfig.api.utils.Objects;
import me.phoenixra.atumconfig.api.utils.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StaticPlaceholder
implements Placeholder {
    private final String identifier;
    private final Pattern pattern;
    private final Supplier<@Nullable String> function;

    public StaticPlaceholder(@NotNull String identifier, @NotNull Supplier<@Nullable String> function) {
        this.identifier = "%" + identifier + "%";
        this.pattern = Pattern.compile(this.identifier, 16);
        this.function = function;
    }

    @Override
    @Nullable
    public String getValue(@NotNull String replacing, @NotNull PlaceholderContext context) {
        return this.function.get();
    }

    @Override
    public String tryTranslateQuickly(@NotNull String text, @NotNull PlaceholderContext context) {
        return StringUtils.replaceFast(text, this.identifier, Objects.requireNonNullElse(this.getValue(this.identifier, context), ""));
    }

    public String toString() {
        return "StaticPlaceholder[identifier=" + this.identifier + "]";
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StaticPlaceholder)) {
            return false;
        }
        StaticPlaceholder that = (StaticPlaceholder)o;
        return Objects.equals(this.getPattern(), that.getPattern());
    }

    public int hashCode() {
        return Objects.hash(this.getPattern());
    }
}

