/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.api.utils;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import me.phoenixra.atumconfig.api.ConfigManager;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    private FileUtils() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static Set<String> getAllPathsInResourceFolder(@NotNull ConfigManager configManager, @NotNull Path dir) {
        LinkedHashSet<String> found;
        block41: {
            found = new LinkedHashSet<String>();
            String basePath = dir.toString().replace(File.separatorChar, '/');
            ClassLoader cl = configManager.getClass().getClassLoader();
            URL url = cl.getResource(basePath);
            if (url == null) {
                configManager.getLogger().logWarn("Resource folder not found on classpath: " + basePath);
                return found;
            }
            try {
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    Path folder = Paths.get(url.toURI());
                    try (Stream<Path> stream = Files.walk(folder, new FileVisitOption[0]);){
                        stream.forEach(p -> {
                            Path rel = folder.relativize((Path)p);
                            String relStr = rel.toString().replace(File.separatorChar, '/');
                            if (!relStr.isEmpty()) {
                                found.add(basePath + "/" + relStr);
                            }
                        });
                        break block41;
                    }
                }
                if ("jar".equals(protocol)) {
                    String[] parts = url.toExternalForm().split("!");
                    URI jarUri = URI.create(parts[0]);
                    String inside = parts[1];
                    try (FileSystem fs = FileSystems.newFileSystem(jarUri, Collections.emptyMap());){
                        Path folder = fs.getPath(inside, new String[0]);
                        try (Stream<Path> stream = Files.walk(folder, new FileVisitOption[0]);){
                            stream.forEach(p -> {
                                Path rel = folder.relativize((Path)p);
                                String relStr = rel.toString().replace(File.separatorChar, '/');
                                if (!relStr.isEmpty()) {
                                    found.add(basePath + "/" + relStr);
                                }
                            });
                            break block41;
                        }
                    }
                }
                configManager.getLogger().logWarn("Unsupported URL protocol for resource listing: " + protocol);
            }
            catch (Exception e) {
                configManager.getLogger().logError("Failed listing resources in folder: " + basePath, e);
            }
        }
        return found;
    }
}

