/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.api.utils;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class NumberUtils {
    private static final TreeMap<Integer, String> NUMERALS = new TreeMap();
    private static DecimalFormat doubleFormatter = new DecimalFormat("0.00");

    private NumberUtils() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    @NotNull
    public static String format(double toFormat) {
        String formatted = doubleFormatter.format(toFormat);
        return formatted.endsWith("00") ? String.valueOf((int)toFormat) : formatted;
    }

    @NotNull
    public static String toNumeral(int number) {
        return NumberUtils.toNumeral(number, -1);
    }

    @NotNull
    public static String toNumeral(int number, int romanNumberLimit) {
        if (number > romanNumberLimit && romanNumberLimit != -1) {
            return String.valueOf(number);
        }
        if (number >= 1 && number <= 4096) {
            int l = NUMERALS.floorKey(number);
            if (number == l) {
                return NUMERALS.get(number);
            }
            return NUMERALS.get(l) + NumberUtils.toNumeral(number - l);
        }
        return String.valueOf(number);
    }

    public static int fromNumeral(@NotNull String numeral) {
        if (numeral.isEmpty()) {
            return 0;
        }
        for (Map.Entry entry : NUMERALS.descendingMap().entrySet()) {
            if (!numeral.startsWith((String)entry.getValue())) continue;
            return (Integer)entry.getKey() + NumberUtils.fromNumeral(numeral.substring(((String)entry.getValue()).length()));
        }
        return 0;
    }

    public static boolean isIntegerOrDouble(String value) {
        try {
            if (value.contains(".")) {
                Double.parseDouble(value);
            } else {
                Integer.parseInt(value);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isLong(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isFloat(String value) {
        try {
            Float.parseFloat(value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        NUMERALS.put(1000, "M");
        NUMERALS.put(900, "CM");
        NUMERALS.put(500, "D");
        NUMERALS.put(400, "CD");
        NUMERALS.put(100, "C");
        NUMERALS.put(90, "XC");
        NUMERALS.put(50, "L");
        NUMERALS.put(40, "XL");
        NUMERALS.put(10, "X");
        NUMERALS.put(9, "IX");
        NUMERALS.put(5, "V");
        NUMERALS.put(4, "IV");
        NUMERALS.put(1, "I");
    }
}

