/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.phoenixra.atumconfig.api.ConfigLogger;
import me.phoenixra.atumconfig.api.ConfigManager;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.atumconfig.api.config.ConfigParser;
import me.phoenixra.atumconfig.api.config.ConfigType;
import me.phoenixra.atumconfig.api.config.catalog.ConfigCatalog;
import me.phoenixra.atumconfig.api.config.catalog.ConfigCatalogListener;
import me.phoenixra.atumconfig.api.placeholders.PlaceholderHandler;
import me.phoenixra.atumconfig.core.config.AtumConfig;
import me.phoenixra.atumconfig.core.config.AtumConfigCatalog;
import me.phoenixra.atumconfig.core.config.AtumConfigFile;
import me.phoenixra.atumconfig.core.config.typehandlers.ConfigTypeHandler;
import me.phoenixra.libs.redempt.crunch.functional.EvaluationEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AtumConfigManager
implements ConfigManager {
    private final String id;
    private final Path directory;
    private final ConfigLogger logger;
    private final boolean supportColorCodes;
    private PlaceholderHandler placeholderHandler;
    protected Map<String, ConfigFile> configFilesMap = new ConcurrentHashMap<String, ConfigFile>();
    protected Map<String, ConfigCatalog> configCatalogsMap = new ConcurrentHashMap<String, ConfigCatalog>();
    protected Map<Class<?>, ConfigParser<?>> configParsersMap = new ConcurrentHashMap();
    private EvaluationEnvironment evaluationEnvironment = new EvaluationEnvironment();

    public AtumConfigManager(@NotNull String id, @NotNull Path directory, @NotNull ConfigLogger logger, boolean supportColorCodes) {
        this.id = id;
        this.directory = directory;
        this.logger = logger;
        this.supportColorCodes = supportColorCodes;
    }

    public AtumConfigManager(@NotNull String id, @NotNull Path directory, boolean supportColorCodes) {
        this.id = id;
        this.directory = directory;
        this.logger = ConfigLogger.SIMPLE;
        this.supportColorCodes = supportColorCodes;
    }

    @Override
    public boolean supportsColorCodes() {
        return this.supportColorCodes;
    }

    @Override
    @NotNull
    public Config createConfig(@NotNull ConfigType type, @Nullable Map<String, Object> valuesMap) {
        return new AtumConfig(this, type, valuesMap);
    }

    @Override
    @NotNull
    public Config createConfigFromStream(@NotNull ConfigType type, @NotNull InputStream stream) {
        InputStreamReader reader = new InputStreamReader(stream);
        String s = ConfigTypeHandler.readToString(reader);
        return this.createConfig(type, ConfigTypeHandler.toMap(this, type, s));
    }

    @Override
    @NotNull
    public Config createConfigFromString(@NotNull ConfigType type, @NotNull String input) {
        return this.createConfig(type, ConfigTypeHandler.toMap(this, type, input));
    }

    @Override
    @NotNull
    public ConfigFile createConfigFile(@NotNull ConfigType type, @NotNull String id, @NotNull Path relativePath, boolean forceLoadResource) throws IOException {
        AtumConfigFile config = new AtumConfigFile(this, type, id, relativePath, forceLoadResource);
        this.addConfigFile(config);
        return config;
    }

    @Override
    @NotNull
    public ConfigCatalog createCatalog(@NotNull ConfigType type, @NotNull String id, @NotNull Path relativeDirectory, boolean nested, @NotNull ConfigCatalogListener catalogListener) {
        AtumConfigCatalog catalog = new AtumConfigCatalog(this, type, id, relativeDirectory, nested, catalogListener);
        this.addCatalog(catalog);
        return catalog;
    }

    @Override
    public void reloadAll() {
        ArrayList<String> removal = new ArrayList<String>();
        for (Map.Entry<String, ConfigFile> entry : this.configFilesMap.entrySet()) {
            if (!entry.getValue().getFile().exists() || !entry.getValue().getFile().isFile()) {
                removal.add(entry.getKey());
                continue;
            }
            try {
                entry.getValue().reload();
            }
            catch (Exception exception) {
                this.getLogger().logError("Caught an Exception while trying to reload the config with name:" + entry.getKey(), exception);
            }
        }
        removal.forEach(this.configFilesMap::remove);
        this.configCatalogsMap.values().forEach(ConfigCatalog::reload);
    }

    @Override
    @NotNull
    public ConfigManager addConfigFile(@NotNull ConfigFile config) {
        this.configFilesMap.put(config.getName(), config);
        return this;
    }

    @Override
    @NotNull
    public ConfigManager addCatalog(@NotNull ConfigCatalog configCategory) {
        this.configCatalogsMap.put(configCategory.getId(), configCategory);
        return this;
    }

    @Override
    @NotNull
    public Optional<ConfigFile> getConfigFile(@NotNull String name) {
        return Optional.ofNullable(this.configFilesMap.get(name));
    }

    @Override
    @NotNull
    public Optional<ConfigCatalog> getCatalog(@NotNull String id) {
        return Optional.ofNullable(this.configCatalogsMap.get(id));
    }

    @Override
    @NotNull
    public Optional<PlaceholderHandler> getPlaceholderHandler() {
        return Optional.ofNullable(this.placeholderHandler);
    }

    @Override
    @NotNull
    public <T> Optional<ConfigParser<T>> getConfigParser(@NotNull Class<T> clazz) {
        return Optional.ofNullable(this.configParsersMap.get(clazz));
    }

    @Override
    public void addConfigParser(@NotNull ConfigParser<?> configParser) {
        this.configParsersMap.put(configParser.getClassParsed(), configParser);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Path getDirectory() {
        return this.directory;
    }

    @Override
    public ConfigLogger getLogger() {
        return this.logger;
    }

    @Override
    public void setPlaceholderHandler(PlaceholderHandler placeholderHandler) {
        this.placeholderHandler = placeholderHandler;
    }

    @Override
    public Map<String, ConfigFile> getConfigFilesMap() {
        return this.configFilesMap;
    }

    @Override
    public Map<String, ConfigCatalog> getConfigCatalogsMap() {
        return this.configCatalogsMap;
    }

    public Map<Class<?>, ConfigParser<?>> getConfigParsersMap() {
        return this.configParsersMap;
    }

    public EvaluationEnvironment getEvaluationEnvironment() {
        return this.evaluationEnvironment;
    }

    public void setEvaluationEnvironment(EvaluationEnvironment evaluationEnvironment) {
        this.evaluationEnvironment = evaluationEnvironment;
    }
}

