/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.core.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.phoenixra.atumconfig.api.ConfigManager;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.atumconfig.api.config.ConfigParser;
import me.phoenixra.atumconfig.api.config.ConfigType;
import me.phoenixra.atumconfig.api.placeholders.Placeholder;
import me.phoenixra.atumconfig.api.placeholders.PlaceholderHandler;
import me.phoenixra.atumconfig.api.placeholders.context.PlaceholderContext;
import me.phoenixra.atumconfig.core.AtumConfigManager;
import me.phoenixra.atumconfig.core.config.AtumConfigSection;
import me.phoenixra.atumconfig.core.config.typehandlers.ConfigTypeHandler;
import me.phoenixra.libs.redempt.crunch.Crunch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AtumConfig
implements Config {
    protected ConfigManager configOwner;
    protected ConfigType configType;
    protected List<Placeholder> injectedPlaceholders = Collections.synchronizedList(new ArrayList());
    protected Map<String, Object> values = Collections.synchronizedMap(new LinkedHashMap());

    public AtumConfig(ConfigManager configOwner, ConfigType configType, Map<String, Object> values) {
        this.configOwner = configOwner;
        this.configType = configType;
        if (values != null) {
            this.applyData(values);
        }
    }

    public AtumConfig(ConfigManager configOwner, ConfigType configType) {
        this(configOwner, configType, new ConcurrentHashMap<String, Object>());
    }

    @Override
    public void applyData(@NotNull Map<String, Object> values) {
        Objects.requireNonNull(values);
        this.values.clear();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public List<String> getKeys(boolean deep) {
        return deep ? this.recurseKeys(new HashSet<String>(), "") : new ArrayList<String>(this.values.keySet());
    }

    @Override
    @NotNull
    public List<String> recurseKeys(@NotNull Set<String> current, @NotNull String root) {
        HashSet<String> list = new HashSet<String>();
        for (String key : this.getKeys(false)) {
            list.add(root + key);
            Object found = this.get(key);
            if (!(found instanceof Config)) continue;
            list.addAll(((Config)found).recurseKeys(current, root + key + "."));
        }
        return new ArrayList<String>(list);
    }

    @Override
    @Nullable
    public Object get(@NotNull String path) {
        String nearestPath = path.split("\\.")[0];
        if (path.contains(".")) {
            String remainingPath = path.replaceFirst(nearestPath + "\\.", "");
            if (remainingPath.isEmpty()) {
                return null;
            }
            Object first = this.get(nearestPath);
            if (first instanceof Config) {
                return ((Config)first).get(remainingPath);
            }
            return null;
        }
        return this.values.get(nearestPath);
    }

    @Override
    public void set(@NotNull String path, @Nullable Object obj) {
        String nearestPath = path.split("\\.")[0];
        if (path.contains(".")) {
            String remainingPath = path.replaceFirst(nearestPath + "\\.", "");
            if (remainingPath.isEmpty()) {
                return;
            }
            Config section = this.getSubsectionOrNull(nearestPath);
            if (section == null) {
                section = new AtumConfigSection(this.getConfigOwner(), this.configType, null);
            }
            section.set(remainingPath, obj);
            this.values.put(nearestPath, section);
            return;
        }
        if (obj == null) {
            this.values.remove(nearestPath);
        } else {
            this.values.put(nearestPath, ConfigTypeHandler.constrainConfigTypes(this.configOwner, this.configType, obj));
        }
    }

    @Override
    public String toPlaintext() {
        return ConfigTypeHandler.toString(this.configType, this.values);
    }

    @Override
    public boolean hasPath(@NotNull String path) {
        return this.get(path) != null;
    }

    @Override
    @Nullable
    public <T> T getParsedOrNull(@NotNull String path, Class<T> clazz) {
        Optional<ConfigParser<T>> parser = this.getConfigOwner().getConfigParser(clazz);
        if (!parser.isPresent()) {
            return null;
        }
        Config subsection = this.getSubsectionOrNull(path);
        if (subsection == null) {
            return null;
        }
        return parser.get().fromConfig(subsection);
    }

    @Override
    @Nullable
    public <T> List<T> getParsedListOrNull(@NotNull String path, Class<T> clazz) {
        Optional<ConfigParser<T>> parserOptional = this.getConfigOwner().getConfigParser(clazz);
        if (!parserOptional.isPresent()) {
            return null;
        }
        List<Config> list = this.getList(path, Config.class);
        if (list == null) {
            return null;
        }
        ConfigParser<T> parser = parserOptional.get();
        return list.stream().map(parser::fromConfig).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Byte getByteOrNull(@NotNull String path) {
        Object obj = this.get(path);
        return obj instanceof Number ? Byte.valueOf(((Number)obj).byteValue()) : null;
    }

    @Override
    @Nullable
    public List<Byte> getByteListOrNull(@NotNull String path) {
        List<Number> list = this.getList(path, Number.class);
        if (list == null) {
            return null;
        }
        return list.stream().map(Number::byteValue).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Short getShortOrNull(@NotNull String path) {
        Object obj = this.get(path);
        return obj instanceof Number ? Short.valueOf(((Number)obj).shortValue()) : null;
    }

    @Override
    @Nullable
    public List<Short> getShortListOrNull(@NotNull String path) {
        List<Number> list = this.getList(path, Number.class);
        if (list == null) {
            return null;
        }
        return list.stream().map(Number::shortValue).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Integer getIntOrNull(@NotNull String path) {
        Object obj = this.get(path);
        return obj instanceof Number ? Integer.valueOf(((Number)obj).intValue()) : null;
    }

    @Override
    @Nullable
    public List<Integer> getIntListOrNull(@NotNull String path) {
        List<Number> list = this.getList(path, Number.class);
        if (list == null) {
            return null;
        }
        return list.stream().map(Number::intValue).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Long getLongOrNull(@NotNull String path) {
        Object obj = this.get(path);
        return obj instanceof Number ? Long.valueOf(((Number)obj).longValue()) : null;
    }

    @Override
    @Nullable
    public List<Long> getLongListOrNull(@NotNull String path) {
        List<Number> list = this.getList(path, Number.class);
        if (list == null) {
            return null;
        }
        return list.stream().map(Number::longValue).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Float getFloatOrNull(@NotNull String path) {
        Object obj = this.get(path);
        return obj instanceof Number ? Float.valueOf(((Number)obj).floatValue()) : null;
    }

    @Override
    @Nullable
    public List<Float> getFloatListOrNull(@NotNull String path) {
        List<Number> list = this.getList(path, Number.class);
        if (list == null) {
            return null;
        }
        return list.stream().map(Number::floatValue).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Double getDoubleOrNull(@NotNull String path) {
        Object obj = this.get(path);
        return obj instanceof Number ? Double.valueOf(((Number)obj).doubleValue()) : null;
    }

    @Override
    @Nullable
    public List<Double> getDoubleListOrNull(@NotNull String path) {
        List<Number> list = this.getList(path, Number.class);
        if (list == null) {
            return null;
        }
        return list.stream().map(Number::doubleValue).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Boolean getBoolOrNull(@NotNull String path) {
        Object obj = this.get(path);
        return obj instanceof Boolean ? (Boolean)obj : null;
    }

    @Override
    @Nullable
    public List<Boolean> getBoolListOrNull(@NotNull String path) {
        return this.getList(path, Boolean.class);
    }

    @Override
    @Nullable
    public String getStringOrNull(@NotNull String path) {
        Object obj = this.get(path);
        return obj != null ? obj.toString() : null;
    }

    @Override
    @Nullable
    public List<String> getStringListOrNull(@NotNull String path) {
        List<Object> list = this.getList(path, Object.class);
        if (list == null) {
            return null;
        }
        return list.stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Config getSubsectionOrNull(@NotNull String path) {
        Object obj = this.get(path);
        return obj instanceof Config ? (Config)obj : null;
    }

    @Override
    @Nullable
    public List<? extends Config> getSubsectionListOrNull(@NotNull String path) {
        return this.getList(path, Config.class);
    }

    @Override
    @NotNull
    public Map<String, Config> getAllSubsections() {
        LinkedHashMap<String, Config> map = new LinkedHashMap<String, Config>();
        for (String key : this.getKeys(false)) {
            Config obj = this.getSubsectionOrNull(key);
            if (obj == null) continue;
            map.put(key, obj);
        }
        return map;
    }

    @Override
    public double getEvaluated(@NotNull String path, @NotNull PlaceholderContext context) {
        String text = this.getStringOrNull(path);
        if (text == null) {
            return 0.0;
        }
        return Crunch.compileExpression(this.getConfigOwner().getPlaceholderHandler().orElse(PlaceholderHandler.EMPTY).translatePlaceholders(text, context), ((AtumConfigManager)this.getConfigOwner()).getEvaluationEnvironment()).evaluate();
    }

    @Nullable
    private <T> List<T> getList(String path, Class<T> type) {
        Object obj = this.get(path);
        if (!(obj instanceof Iterable)) {
            return null;
        }
        Iterable iterable = (Iterable)obj;
        ArrayList<T> result = new ArrayList<T>();
        for (Object elem : iterable) {
            if (!type.isInstance(elem)) {
                return null;
            }
            result.add(type.cast(elem));
        }
        return result;
    }

    @Override
    public void addPlaceholder(@NotNull Iterable<Placeholder> placeholders, boolean deep) {
        for (Placeholder placeholder : placeholders) {
            if (placeholder == null || this.injectedPlaceholders.contains(placeholder)) continue;
            this.injectedPlaceholders.add(placeholder);
        }
        if (deep) {
            for (Object object : this.values.values()) {
                if (!(object instanceof Config)) continue;
                ((Config)object).addPlaceholder(placeholders, true);
            }
        }
    }

    @Override
    public void removePlaceholder(@NotNull Iterable<Placeholder> placeholders, boolean deep) {
        for (Placeholder placeholder : placeholders) {
            if (placeholder == null) continue;
            this.injectedPlaceholders.remove(placeholder);
        }
        if (deep) {
            for (Object object : this.values.values()) {
                if (!(object instanceof Config)) continue;
                ((Config)object).removePlaceholder(placeholders, true);
            }
        }
    }

    @Override
    public void clearPlaceholders(boolean deep) {
        this.injectedPlaceholders.clear();
        if (deep) {
            for (Object object : this.values.values()) {
                if (!(object instanceof Config)) continue;
                ((Config)object).clearPlaceholders(true);
            }
        }
    }

    @Override
    @NotNull
    public List<Placeholder> getPlaceholders() {
        return this.injectedPlaceholders;
    }

    @Override
    @NotNull
    public ConfigType getType() {
        return this.configType;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.values;
    }

    @Override
    public ConfigManager getConfigOwner() {
        return this.configOwner;
    }
}

