/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.core.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import me.phoenixra.atumconfig.api.ConfigManager;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.atumconfig.api.config.ConfigType;
import me.phoenixra.atumconfig.core.config.AtumConfig;
import me.phoenixra.atumconfig.core.config.typehandlers.ConfigTypeHandler;
import org.jetbrains.annotations.NotNull;

public class AtumConfigFile
extends AtumConfig
implements ConfigFile {
    private String id;
    private Path relativeFilePath;
    private Path absolutePath;
    protected File file;

    public AtumConfigFile(@NotNull ConfigManager configOwner, @NotNull ConfigType type, @NotNull String id, @NotNull Path relativePath, boolean forceLoadResource) throws IOException {
        super(configOwner, type);
        this.id = id;
        this.relativeFilePath = relativePath;
        this.absolutePath = configOwner.getDirectory().resolve(relativePath).normalize();
        Path parent = this.absolutePath.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        this.file = this.absolutePath.toFile();
        if (!this.file.exists()) {
            this.createFile(forceLoadResource);
        }
        this.reload();
    }

    @Override
    public void createFile(boolean forceLoadResource) {
        if (forceLoadResource || !this.file.exists()) {
            String resourcePath = this.getResourcePath();
            try (InputStream in = this.getClass().getResourceAsStream(resourcePath);){
                if (in == null && forceLoadResource) {
                    throw new IOException("Resource not found: " + resourcePath);
                }
                if (in != null) {
                    Files.copy(in, this.absolutePath, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.createFile(this.absolutePath, new FileAttribute[0]);
                }
            }
            catch (Exception e) {
                this.getConfigOwner().getLogger().logError("Exception while creating config file " + this.getId(), e);
            }
        }
    }

    @Override
    public void reload() throws IOException {
        byte[] bytes = Files.readAllBytes(this.absolutePath);
        String raw = new String(bytes, StandardCharsets.UTF_8);
        Map<String, Object> data = ConfigTypeHandler.toMap(this.getConfigOwner(), this.getType(), raw);
        super.applyData(data);
    }

    @Override
    public void save() throws IOException {
        Files.write(this.absolutePath, this.toPlaintext().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    @NotNull
    public String getResourcePath() {
        String unixPath = this.relativeFilePath.toString().replace('\\', '/');
        return "/" + unixPath;
    }

    @Override
    public String toPlaintext() {
        String text = super.toPlaintext();
        return Arrays.stream(text.split("\\r?\\n")).filter(line -> !line.trim().startsWith("#")).collect(Collectors.joining("\n")) + "\n";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Path getRelativeFilePath() {
        return this.relativeFilePath;
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

