/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.core.config.typehandlers;

import java.lang.reflect.Type;
import java.util.Map;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.atumconfig.api.config.ConfigType;
import me.phoenixra.atumconfig.core.config.AtumConfigSection;
import me.phoenixra.atumconfig.core.config.typehandlers.ConfigTypeHandler;
import me.phoenixra.libs.com.google.gson.Gson;
import me.phoenixra.libs.com.google.gson.GsonBuilder;
import me.phoenixra.libs.com.google.gson.JsonElement;
import me.phoenixra.libs.com.google.gson.JsonSerializationContext;
import me.phoenixra.libs.com.google.gson.JsonSerializer;

public class TypeHandlerJson
extends ConfigTypeHandler {
    private AtumGsonSerializer serializer = new AtumGsonSerializer();

    public TypeHandlerJson() {
        super(ConfigType.JSON);
    }

    @Override
    protected Map<String, Object> parseToMap(String input) {
        return this.serializer.gson.fromJson(input, Map.class);
    }

    @Override
    public String toString(Map<String, Object> map) {
        return this.serializer.gson.toJson(map);
    }

    public AtumGsonSerializer getSerializer() {
        return this.serializer;
    }

    public static class AtumGsonSerializer
    implements JsonSerializer<Config> {
        protected Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter((Type)((Object)AtumConfigSection.class), this).create();

        @Override
        public JsonElement serialize(Config src, Type typeOfSrc, JsonSerializationContext context) {
            return this.gson.toJsonTree(src.toMap());
        }

        public Gson getGson() {
            return this.gson;
        }
    }
}

