/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.api.misc.color;

import java.util.Objects;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.atumvr.api.misc.color.AtumColorImmutable;
import org.jetbrains.annotations.NotNull;

public class AtumColorMutable
implements AtumColor {
    private float red;
    private float green;
    private float blue;
    private float alpha;
    private int redInt;
    private int greenInt;
    private int blueInt;
    private int alphaInt;

    public AtumColorMutable(float red, float green, float blue, float alpha) {
        this.setRGBA(red, green, blue, alpha);
    }

    public AtumColorMutable(int red, int green, int blue, int alpha) {
        this.setRGBA(red, green, blue, alpha);
    }

    public void setRGBA(int red, int green, int blue, int alpha) {
        this.red = (float)red / 255.0f;
        this.green = (float)green / 255.0f;
        this.blue = (float)blue / 255.0f;
        this.alpha = (float)alpha / 255.0f;
        this.updateIntValues();
    }

    public void setRGBA(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.updateIntValues();
    }

    private void updateIntValues() {
        this.redInt = this.floatToInt(this.red);
        this.greenInt = this.floatToInt(this.green);
        this.blueInt = this.floatToInt(this.blue);
        this.alphaInt = this.floatToInt(this.alpha);
    }

    @Override
    @NotNull
    public AtumColorMutable blend(@NotNull AtumColor other, float ratio) {
        this.red = this.red * (1.0f - ratio) + other.getRed() * ratio;
        this.green = this.green * (1.0f - ratio) + other.getGreen() * ratio;
        this.blue = this.blue * (1.0f - ratio) + other.getBlue() * ratio;
        this.alpha = this.alpha * (1.0f - ratio) + other.getAlpha() * ratio;
        this.updateIntValues();
        return this;
    }

    @Override
    @NotNull
    public AtumColorMutable multiply(float multiplier) {
        this.red *= multiplier;
        this.green *= multiplier;
        this.blue *= multiplier;
        this.updateIntValues();
        return this;
    }

    @Override
    @NotNull
    public AtumColorMutable invert() {
        this.red = 1.0f - this.red;
        this.green = 1.0f - this.green;
        this.blue = 1.0f - this.blue;
        this.updateIntValues();
        return this;
    }

    @Override
    @NotNull
    public AtumColorMutable toGrayscale() {
        float luminance;
        this.green = this.blue = (luminance = 0.3f * this.red + 0.59f * this.green + 0.11f * this.blue);
        this.red = this.blue;
        this.updateIntValues();
        return this;
    }

    @Override
    @NotNull
    public AtumColorMutable withAlpha(float newAlpha) {
        this.alpha = newAlpha;
        this.updateIntValues();
        return this;
    }

    @Override
    public double getContrastRatio(@NotNull AtumColor other) {
        double l1 = this.relativeLuminance(this);
        double l2 = this.relativeLuminance(other);
        double lighter = Math.max(l1, l2);
        double darker = Math.min(l1, l2);
        return (lighter + 0.05) / (darker + 0.05);
    }

    private double relativeLuminance(AtumColor color) {
        double r = this.adjust(color.getRed());
        double g = this.adjust(color.getGreen());
        double b = this.adjust(color.getBlue());
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }

    private double adjust(double channel) {
        return channel <= 0.03928 ? channel / 12.92 : Math.pow((channel + 0.055) / 1.055, 2.4);
    }

    public AtumColorImmutable asImmutable() {
        return new AtumColorImmutable(this.red, this.green, this.blue, this.alpha);
    }

    public String toString() {
        return "AtumColorMutable{red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AtumColor)) {
            return false;
        }
        AtumColor that = (AtumColor)o;
        return Float.compare(that.getRed(), this.red) == 0 && Float.compare(that.getGreen(), this.green) == 0 && Float.compare(that.getBlue(), this.blue) == 0 && Float.compare(that.getAlpha(), this.alpha) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha));
    }

    @Override
    public float getRed() {
        return this.red;
    }

    @Override
    public float getGreen() {
        return this.green;
    }

    @Override
    public float getBlue() {
        return this.blue;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public int getRedInt() {
        return this.redInt;
    }

    @Override
    public int getGreenInt() {
        return this.greenInt;
    }

    @Override
    public int getBlueInt() {
        return this.blueInt;
    }

    @Override
    public int getAlphaInt() {
        return this.alphaInt;
    }
}

