/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core;

import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.OpenXRState;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrQuaternionf;
import org.lwjgl.openxr.XrReferenceSpaceCreateInfo;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSpaceLocation;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.openxr.XrVector4f;
import org.lwjgl.system.MemoryStack;

public class OpenXRHelper {
    public static XrPosef getPoseIdentity(MemoryStack stack) {
        return XrPosef.calloc(stack).orientation(XrQuaternionf.calloc(stack).set(0.0f, 0.0f, 0.0f, 1.0f)).position$(XrVector3f.calloc(stack).set(0.0f, 0.0f, 0.0f));
    }

    @Nullable
    public static XrSpaceLocation xrLocationFromSpace(OpenXRProvider provider, XrSpace xrSpace, MemoryStack stack) {
        XrSpaceLocation space_location = XrSpaceLocation.calloc(stack).type(42);
        provider.checkXRError(XR10.xrLocateSpace(xrSpace, provider.getState().getVrSession().getXrAppSpace(), provider.getXrDisplayTime(), space_location), "xrLocateSpace", new String[0]);
        if ((space_location.locationFlags() & 2L) != 0L && (space_location.locationFlags() & 1L) != 0L) {
            return space_location;
        }
        return null;
    }

    public static XrSpace createReferenceSpace(OpenXRState state, int spaceType, XrPosef identityPose, MemoryStack stack) {
        XrReferenceSpaceCreateInfo spaceInfo = XrReferenceSpaceCreateInfo.calloc(stack).type(37).next(0L).referenceSpaceType(spaceType).poseInReferenceSpace(identityPose);
        XrSession handle = state.getVrSession().getHandle();
        PointerBuffer pSpace = stack.callocPointer(1);
        state.getVrProvider().checkXRError(XR10.xrCreateReferenceSpace(handle, spaceInfo, pSpace), "xrCreateReferenceSpace", "Spacetype: " + spaceType);
        return new XrSpace(pSpace.get(0), handle);
    }

    public static Matrix4f normalizeXrPose(XrPosef xrPose) {
        XrQuaternionf orientation = xrPose.orientation();
        XrVector3f position = xrPose.position$();
        Quaternionf rotation = new Quaternionf(orientation.x(), orientation.y(), orientation.z(), orientation.w());
        return new Matrix4f().identity().translate(position.x(), position.y(), position.z()).rotate((Quaternionfc)rotation);
    }

    public static Quaternionf normalizeXrQuaternion(XrQuaternionf xrQuaternion) {
        return new Quaternionf(xrQuaternion.x(), xrQuaternion.y(), xrQuaternion.z(), xrQuaternion.w());
    }

    public static Vector2f normalizeXrVector(XrVector2f xrVector) {
        return new Vector2f(xrVector.x(), xrVector.y());
    }

    public static Vector3f normalizeXrVector(XrVector3f xrVector) {
        return new Vector3f(xrVector.x(), xrVector.y(), xrVector.z());
    }

    public static Vector4f normalizeXrVector(XrVector4f xrVector) {
        return new Vector4f(xrVector.x(), xrVector.y(), xrVector.z(), xrVector.w());
    }
}

