/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.init;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import me.phoenixra.atumvr.core.OpenXRHelper;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.OpenXRState;
import me.phoenixra.atumvr.core.init.OpenXRInstance;
import me.phoenixra.atumvr.core.init.OpenXRSystem;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.FBDisplayRefreshRate;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrQuaternionf;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSessionCreateInfo;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Struct;

public class OpenXRSession {
    private final OpenXRState xrState;
    protected XrSession handle;
    protected XrSpace xrAppSpace;
    protected XrSpace xrViewSpace;

    public OpenXRSession(OpenXRState xrState) {
        this.xrState = xrState;
    }

    public void init() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            OpenXRProvider provider = this.xrState.getVrProvider();
            this.initSession(provider, stack);
            this.initSpaces(stack);
            this.initDisplayRefreshRate(provider, stack);
        }
    }

    private void initSession(OpenXRProvider provider, MemoryStack stack) {
        OpenXRInstance xrInstance = this.xrState.getVrInstance();
        OpenXRSystem xrSystem = this.xrState.getVrSystem();
        long systemId = this.xrState.getVrSystem().getSystemId();
        Struct<?> graphicsBind = xrSystem.createGraphicsBinding(stack, xrInstance.getHandle(), systemId, provider.getRenderer().getWindowHandle());
        XrSessionCreateInfo sessionInfo = XrSessionCreateInfo.calloc(stack).type(8).next(graphicsBind.address()).systemId(systemId).createFlags(0L);
        PointerBuffer sessionBuf = stack.callocPointer(1);
        provider.checkXRError(XR10.xrCreateSession(xrInstance.getHandle(), sessionInfo, sessionBuf), "xrCreateSession", "Failed to create session");
        this.handle = new XrSession(sessionBuf.get(0), xrInstance.getHandle());
    }

    private void initSpaces(MemoryStack stack) {
        XrPosef identity = XrPosef.calloc(stack).set(XrQuaternionf.calloc(stack).set(0.0f, 0.0f, 0.0f, 1.0f), XrVector3f.calloc(stack).set(0.0f, 0.0f, 0.0f));
        this.xrAppSpace = OpenXRHelper.createReferenceSpace(this.xrState, 3, identity, stack);
        identity = XrPosef.calloc(stack).set(XrQuaternionf.calloc(stack).set(0.0f, 0.0f, 0.0f, 1.0f), XrVector3f.calloc(stack).set(0.0f, 0.0f, 0.0f));
        this.xrViewSpace = OpenXRHelper.createReferenceSpace(this.xrState, 1, identity, stack);
    }

    private void initDisplayRefreshRate(OpenXRProvider provider, MemoryStack stack) {
        if (this.handle.getCapabilities().XR_FB_display_refresh_rate) {
            IntBuffer refreshRateCount = stack.callocInt(1);
            provider.checkXRError(FBDisplayRefreshRate.xrEnumerateDisplayRefreshRatesFB(this.handle, refreshRateCount, null), "xrEnumerateDisplayRefreshRatesFB", "first call");
            FloatBuffer refreshRateBuffer = stack.callocFloat(refreshRateCount.get(0));
            provider.checkXRError(FBDisplayRefreshRate.xrEnumerateDisplayRefreshRatesFB(this.handle, refreshRateCount, refreshRateBuffer), "xrEnumerateDisplayRefreshRatesFB", "second call");
            refreshRateBuffer.rewind();
            provider.checkXRError(FBDisplayRefreshRate.xrRequestDisplayRefreshRateFB(this.handle, refreshRateBuffer.get(refreshRateCount.get(0) - 1)), "xrRequestDisplayRefreshRateFB", new String[0]);
        }
    }

    public void destroy() {
        OpenXRProvider provider = this.xrState.getVrProvider();
        if (this.xrAppSpace != null) {
            provider.checkXRError(false, XR10.xrDestroySpace(this.xrAppSpace), "xrDestroySpace", "xrAppSpace");
        }
        if (this.xrViewSpace != null) {
            provider.checkXRError(false, XR10.xrDestroySpace(this.xrViewSpace), "xrDestroySpace", "xrViewSpace");
        }
        if (this.handle != null) {
            provider.checkXRError(false, XR10.xrDestroySession(this.handle), "xrDestroySession", "xrAppSpace");
        }
    }

    public XrSession getHandle() {
        return this.handle;
    }

    public XrSpace getXrAppSpace() {
        return this.xrAppSpace;
    }

    public XrSpace getXrViewSpace() {
        return this.xrViewSpace;
    }
}

