/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input;

import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.phoenixra.atumconfig.api.tuples.PairRecord;
import me.phoenixra.atumvr.api.exceptions.VRException;
import me.phoenixra.atumvr.api.input.VRInputHandler;
import me.phoenixra.atumvr.api.input.device.VRDevice;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.OpenXRAction;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.device.OpenXRDevice;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionSuggestedBinding;
import org.lwjgl.openxr.XrActionsSyncInfo;
import org.lwjgl.openxr.XrActiveActionSet;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.openxr.XrInteractionProfileSuggestedBinding;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSessionActionSetsAttachInfo;
import org.lwjgl.system.MemoryStack;

public abstract class OpenXRInputHandler
implements VRInputHandler {
    private final OpenXRProvider vrProvider;
    private final HashMap<String, Long> paths = new HashMap();
    private final Map<String, OpenXRActionSet> actionSets = new LinkedHashMap<String, OpenXRActionSet>();
    private final Map<String, OpenXRDevice> devices = new LinkedHashMap<String, OpenXRDevice>();
    private Consumer<String> actionListener;

    public OpenXRInputHandler(OpenXRProvider provider) {
        this.vrProvider = provider;
    }

    protected abstract List<? extends OpenXRActionSet> generateActionSets(MemoryStack var1);

    protected abstract List<? extends OpenXRDevice> generateDevices(MemoryStack var1);

    @Override
    public void init() {
        XrSession xrSession = this.vrProvider.getState().getVrSession().getHandle();
        try (MemoryStack stack = MemoryStack.stackPush();){
            this.actionSets.clear();
            List<? extends OpenXRActionSet> loadedActionSets = this.generateActionSets(stack);
            loadedActionSets.forEach(OpenXRActionSet::init);
            long[] actionSetsArray = new long[loadedActionSets.size()];
            int i = 0;
            for (OpenXRActionSet openXRActionSet : loadedActionSets) {
                this.actionSets.put(openXRActionSet.getName(), openXRActionSet);
                actionSetsArray[i] = openXRActionSet.getHandle().address();
                ++i;
            }
            this.suggestDefaultBindings(stack);
            XrSessionActionSetsAttachInfo attach_info = XrSessionActionSetsAttachInfo.calloc(stack).set(60, 0L, MemoryStack.stackPointers((long[])actionSetsArray));
            this.vrProvider.checkXRError(XR10.xrAttachSessionActionSets(xrSession, attach_info), "xrAttachSessionActionSets", new String[0]);
            this.devices.clear();
            for (OpenXRDevice openXRDevice : this.generateDevices(stack)) {
                this.devices.put(openXRDevice.getId(), openXRDevice);
            }
        }
    }

    @Override
    public void update() {
        XrInstance instance = this.vrProvider.getState().getVrInstance().getHandle();
        XrSession session = this.vrProvider.getState().getVrSession().getHandle();
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrActiveActionSet.Buffer buffer = XrActiveActionSet.calloc(this.actionSets.size(), stack);
            int i = 0;
            for (OpenXRActionSet actionSet : this.actionSets.values()) {
                ((XrActiveActionSet)buffer.get(i)).set(actionSet.getHandle(), 0L);
                ++i;
            }
            XrActionsSyncInfo syncInfo = XrActionsSyncInfo.calloc(stack).type(61).activeActionSets(buffer);
            this.vrProvider.checkXRError(XR10.xrSyncActions(session, syncInfo), "xrSyncActions", new String[0]);
        }
        for (OpenXRActionSet openXRActionSet : this.actionSets.values()) {
            openXRActionSet.update(this.actionListener);
        }
        for (OpenXRDevice openXRDevice : this.devices.values()) {
            openXRDevice.update();
        }
    }

    private void suggestDefaultBindings(MemoryStack stack) {
        XrInstance xrInstance = this.vrProvider.getState().getVrInstance().getHandle();
        List<XRInteractionProfile> supportedProfiles = XRInteractionProfile.getSupported(this.vrProvider);
        for (XRInteractionProfile profile : supportedProfiles) {
            ArrayList<PairRecord<OpenXRAction, String>> bindingsSet = new ArrayList<PairRecord<OpenXRAction, String>>();
            for (OpenXRActionSet actionSet : this.actionSets.values()) {
                List<PairRecord<OpenXRAction, String>> binds = actionSet.getDefaultBindings(profile);
                if (binds == null || binds.isEmpty()) continue;
                bindingsSet.addAll(binds);
            }
            if (bindingsSet.isEmpty()) continue;
            XrActionSuggestedBinding.Buffer bindings = XrActionSuggestedBinding.calloc(bindingsSet.size(), stack);
            for (int i = 0; i < bindingsSet.size(); ++i) {
                PairRecord binding = (PairRecord)bindingsSet.get(i);
                ((XrActionSuggestedBinding)bindings.get(i)).set(((OpenXRAction)binding.first()).getHandle(), this.getPath((String)binding.second()));
            }
            XrInteractionProfileSuggestedBinding suggested_binds = XrInteractionProfileSuggestedBinding.calloc(stack).set(51, 0L, this.getPath(profile.getPathName()), bindings);
            this.vrProvider.checkXRError(XR10.xrSuggestInteractionProfileBindings(xrInstance, suggested_binds), "xrSuggestInteractionProfileBindings", new String[0]);
        }
    }

    public Collection<? extends OpenXRActionSet> getActionSets() {
        return this.actionSets.values();
    }

    public Collection<? extends OpenXRDevice> getDevices() {
        return this.devices.values();
    }

    @Override
    public OpenXRDevice getDevice(String id) {
        return this.devices.get(id);
    }

    @Override
    public void registerDevice(VRDevice device) {
        if (!(device instanceof OpenXRDevice)) {
            throw new VRException("Cannot register device that is not instanceof OpenXRDevice");
        }
        OpenXRDevice openXRDevice = (OpenXRDevice)device;
        this.devices.put(device.getId(), openXRDevice);
    }

    public long getPath(String pathString) {
        return this.paths.computeIfAbsent(pathString, s -> {
            try (MemoryStack ignored = MemoryStack.stackPush();){
                LongBuffer buf = MemoryStack.stackCallocLong((int)1);
                int xrResult = XR10.xrStringToPath(this.vrProvider.getState().getVrInstance().getHandle(), pathString, buf);
                if (xrResult == -21) {
                    throw new VRException("Invalid path:\"" + pathString + "\"");
                }
                this.vrProvider.checkXRError(xrResult, "xrStringToPath", new String[0]);
                Long l = buf.get();
                return l;
            }
        });
    }

    @Override
    public void destroy() {
        this.actionSets.values().forEach(OpenXRActionSet::destroy);
        this.actionSets.clear();
        this.devices.clear();
    }

    @Override
    public OpenXRProvider getVrProvider() {
        return this.vrProvider;
    }

    public Consumer<String> getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(Consumer<String> actionListener) {
        this.actionListener = actionListener;
    }
}

