/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.phoenixra.atumconfig.api.tuples.PairRecord;
import me.phoenixra.atumvr.api.input.action.VRActionSet;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.init.OpenXRInstance;
import me.phoenixra.atumvr.core.input.action.OpenXRAction;
import me.phoenixra.atumvr.core.input.action.OpenXRMultiAction;
import me.phoenixra.atumvr.core.input.action.OpenXRSingleAction;
import me.phoenixra.atumvr.core.input.action.types.HapticPulseAction;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionSet;
import org.lwjgl.openxr.XrActionSetCreateInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public abstract class OpenXRActionSet
implements VRActionSet {
    private final OpenXRProvider provider;
    private final String name;
    private final String localizedName;
    private XrActionSet handle;
    private final int priority;
    private List<OpenXRAction> actions = new ArrayList<OpenXRAction>();

    public OpenXRActionSet(OpenXRProvider provider, String name, String localizedName, int priority) {
        this.provider = provider;
        this.name = name;
        this.localizedName = localizedName;
        this.priority = priority;
    }

    protected abstract List<OpenXRAction> loadActions(OpenXRProvider var1);

    @Override
    public void update(@Nullable Consumer<String> listener) {
        for (OpenXRAction action : this.getActions()) {
            action.update(listener);
        }
    }

    @Override
    public void init() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            OpenXRInstance xrInstance = this.provider.getState().getVrInstance();
            XrActionSetCreateInfo actionSetCreateInfo = XrActionSetCreateInfo.calloc(stack).set(28, 0L, MemoryUtil.memUTF8((CharSequence)this.name), MemoryUtil.memUTF8((CharSequence)this.localizedName), this.priority);
            PointerBuffer actionSetPoint = MemoryStack.stackCallocPointer((int)1);
            this.provider.checkXRError(XR10.xrCreateActionSet(xrInstance.getHandle(), actionSetCreateInfo, actionSetPoint), "xrCreateActionSet", new String[0]);
            this.handle = new XrActionSet(actionSetPoint.get(0), xrInstance.getHandle());
            this.actions = this.loadActions(this.provider);
            for (OpenXRAction action : this.actions) {
                action.init(this);
            }
        }
    }

    public List<PairRecord<OpenXRAction, String>> getDefaultBindings(XRInteractionProfile profile) {
        ArrayList<PairRecord<OpenXRAction, String>> out = new ArrayList<PairRecord<OpenXRAction, String>>();
        for (OpenXRAction action : this.actions) {
            HapticPulseAction hapticPulseAction;
            Object bind;
            if (action instanceof OpenXRSingleAction) {
                OpenXRSingleAction singleAction = (OpenXRSingleAction)action;
                bind = singleAction.getDefaultBindings(profile);
                if (bind == null) continue;
                out.add(new PairRecord<OpenXRSingleAction, PairRecord<String, String>>(singleAction, (PairRecord<String, String>)bind));
                continue;
            }
            if (action instanceof OpenXRMultiAction) {
                OpenXRMultiAction multiAction = (OpenXRMultiAction)action;
                bind = multiAction.getSubActions().iterator();
                while (bind.hasNext()) {
                    OpenXRMultiAction.SubAction subAction = (OpenXRMultiAction.SubAction)bind.next();
                    String bind2 = subAction.getDefaultBindings(profile);
                    if (bind2 == null) continue;
                    out.add(new PairRecord<OpenXRMultiAction, String>(multiAction, bind2));
                }
                continue;
            }
            if (!(action instanceof HapticPulseAction) || (bind = (hapticPulseAction = (HapticPulseAction)action).getDefaultBindings(profile)) == null) continue;
            out.add(new PairRecord<OpenXRAction, String>(action, (String)((PairRecord)bind).first()));
            out.add(new PairRecord<OpenXRAction, String>(action, (String)((PairRecord)bind).second()));
        }
        return out;
    }

    @Override
    public final void destroy() {
        if (this.handle != null) {
            XR10.xrDestroyActionSet(this.handle);
        }
        for (OpenXRAction action : this.getActions()) {
            action.destroy();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocalizedName() {
        return this.localizedName;
    }

    public XrActionSet getHandle() {
        return this.handle;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public List<OpenXRAction> getActions() {
        return this.actions;
    }
}

